/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import rma.util.ColorContour;
import rma.xml.adapters.XmlColorAdapter;

@XmlRootElement(name="TwoColorColorContour")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TwoColorColorContour
extends ColorContour {
    private static final String MAX_COLOR = "maxColor";
    private static final String MIN_COLOR = "minColor";
    @XmlElement(name="minColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color mMinColor = Color.blue;
    @XmlElement(name="maxColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color mMaxColor = Color.red;

    public void setMinColor(Color minColor) {
        if (minColor == null) {
            return;
        }
        Color tempMinColor = this.mMinColor;
        this.mMinColor = minColor;
        this.mPropertyChangeSupport.firePropertyChange(MIN_COLOR, tempMinColor, this.mMinColor);
    }

    public void setMaxColor(Color maxColor) {
        if (maxColor == null) {
            return;
        }
        Color tempMaxColor = this.mMaxColor;
        this.mMaxColor = maxColor;
        this.mPropertyChangeSupport.firePropertyChange(MAX_COLOR, tempMaxColor, this.mMaxColor);
    }

    public Color getMinColor() {
        return this.mMinColor;
    }

    public Color getMaxColor() {
        return this.mMaxColor;
    }

    @Override
    protected void getRGB0(double[] rgb, double val, double minValue, double maxValue) {
        int r1 = this.mMinColor.getRed();
        int b1 = this.mMinColor.getBlue();
        int g1 = this.mMinColor.getGreen();
        int r2 = this.mMaxColor.getRed();
        int b2 = this.mMaxColor.getBlue();
        int g2 = this.mMaxColor.getGreen();
        double divValue = 0.0;
        if (val < minValue) {
            divValue = 0.0;
        } else if (val > maxValue) {
            divValue = 1.0;
        } else {
            double range = maxValue - minValue;
            divValue = this.safeDiv(range - (maxValue - val), range);
        }
        rgb[0] = (double)r1 + (double)(r2 - r1) * divValue;
        rgb[1] = (double)g1 + (double)(g2 - g1) * divValue;
        rgb[2] = (double)b1 + (double)(b2 - b1) * divValue;
    }

    private double safeDiv(double x1, double x2) {
        double result = 0.0;
        if (x2 != 0.0) {
            result = x1 / x2;
        }
        return result;
    }

    @Override
    protected double[] getRGB0(double val, double minValue, double maxValue) {
        double[] rgb = new double[3];
        this.getRGB0(rgb, val, minValue, maxValue);
        return rgb;
    }
}

