/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import rma.swing.RmaVcrControls;
import rma.swing.VCRControlsListener;
import rma.util.VCRDebug;
import rma.util.VCRPlayer;
import rma.util.VCRPlayerThread;

public class VCRControlsListenerImpl
implements VCRControlsListener {
    protected VCRPlayer _player = null;
    protected RmaVcrControls _controls = null;
    protected VCRPlayerThread _playerThread = null;
    protected boolean _displayCurrentLoc = true;
    protected Runnable _runner;
    private int FF_DELAY = 100;
    private int PLAY_DELAY = 1000;

    public VCRControlsListenerImpl(RmaVcrControls controls) {
        this._controls = controls;
    }

    public VCRControlsListenerImpl(RmaVcrControls controls, Runnable runner) {
        this(controls);
        this._runner = runner;
    }

    public VCRControlsListenerImpl(RmaVcrControls controls, VCRPlayer player) {
        this._controls = controls;
        this.setVCRPlayer(player);
    }

    public void setRunnable(Runnable run) {
        this._runner = run;
        if (this._playerThread != null) {
            this._playerThread.setRunnable(run);
        }
    }

    public VCRPlayer getPlayer() {
        return this._player;
    }

    public VCRPlayer setVCRPlayer(VCRPlayer newPlayer) {
        VCRPlayer oldPlayer = this._player;
        this._player = newPlayer;
        return oldPlayer;
    }

    public void setFastForwardDelay(int value) {
        this.FF_DELAY = value;
    }

    public void setPlayDelay(int value) {
        this.PLAY_DELAY = value;
    }

    @Override
    public void controlSelected(int cmd) {
        if (this._player == null) {
            return;
        }
        switch (cmd) {
            case 0: {
                this._controls.setCurrentPosition(0);
                break;
            }
            case 1: {
                this.setPaused(true);
                break;
            }
            case 2: {
                this.setPaused(false);
                break;
            }
            case 4: {
                this._player.setDelay(this.PLAY_DELAY);
                this.play(this._controls.getCurrentPosition());
                break;
            }
            case 5: {
                this._player.setDelay(this.FF_DELAY);
                this.fastForward(this._controls.getCurrentPosition());
                break;
            }
            case 3: {
                this.stop();
            }
        }
    }

    protected void play(int startPos) {
        if (VCRDebug.debug) {
            System.out.println("VCRControlsListenerImpl.play: START " + startPos);
        }
        if (this._playerThread != null) {
            this._playerThread.stopPlay();
            while (this._playerThread.isProcessing()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this._playerThread = new VCRPlayerThread(this._player, this._controls);
        if (this._runner != null) {
            this._playerThread.setRunnable(this._runner);
        }
        this._playerThread.setPriority(2);
        if (startPos >= this._player.getPlaySize()) {
            this._player.setCurrentPosition(this._player.getPlaySize() - 1);
        }
        this._player.setCurrentPosition(startPos);
        this._playerThread.start();
    }

    public void fastForward(int pos) {
        if (VCRDebug.debug) {
            System.out.println("VCRControlsListenerImpl.fastForward: START " + pos);
        }
        if (this._playerThread == null || !this._playerThread.isAlive()) {
            this.play(pos);
        }
    }

    protected void stop() {
        if (this._playerThread != null) {
            this._playerThread.stopPlay();
        }
    }

    public void setPaused(boolean paused) {
        if (this._playerThread != null && this._playerThread.isAlive()) {
            this._playerThread.setPaused(paused);
        }
    }

    @Override
    public void sliderMoved(int pos) {
        if (this._player == null) {
            return;
        }
        if (VCRDebug.debug) {
            System.out.println("VCRControlsListenerImpl.sliderMoved: position :" + pos);
        }
        this._player.setCurrentPosition(pos);
        if (this._displayCurrentLoc) {
            String curLoc = this._player.getCurrentLocation();
            this._controls.setCurrentLocation(curLoc);
            this._controls.setNoData(!this._player.hasData());
        }
        if (this._runner != null) {
            this._runner.run();
        }
    }

    public void setDisplayCurrentLocation(boolean b) {
        this._displayCurrentLoc = b;
    }
}

