/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import javax.swing.SwingUtilities;
import rma.swing.RmaVcrControls;
import rma.util.VCRDebug;
import rma.util.VCRPlayer;

public class VCRPlayerThread
extends Thread {
    boolean _stopped = false;
    boolean _paused = false;
    VCRPlayer _player;
    private RmaVcrControls _controls = null;
    boolean _processing = false;
    protected Runnable _runGuy;

    public VCRPlayerThread(VCRPlayer player, RmaVcrControls controls) {
        this._player = player;
        this._controls = controls;
    }

    @Override
    public void run() {
        this.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        int size = this._player.getPlaySize();
        if (size < 2) {
            return;
        }
        this._processing = true;
        for (int i = this._player.getCurrentPosition(); i <= size && !this._stopped; ++i) {
            while (this._paused) {
                VCRPlayerThread vCRPlayerThread = this;
                synchronized (vCRPlayerThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this._stopped) break;
            if (VCRDebug.debug) {
                System.out.println("VCRPlayThread: set Current Pos to " + i);
            }
            this._player.setCurrentPosition(i);
            this._controls.setCurrentPosition(this._player.getCurrentPosition());
            this._controls.setNoData(!this._player.hasData());
            try {
                if (this._runGuy != null) {
                    SwingUtilities.invokeAndWait(this._runGuy);
                }
            }
            catch (Exception e) {
                System.out.println("play: exception on invokeAndWait() " + e);
            }
            if (this._stopped) break;
            try {
                Thread.sleep(this._player.getDelay());
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._processing = false;
    }

    public void stopPlay() {
        this._stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        this._paused = paused;
        VCRPlayerThread vCRPlayerThread = this;
        synchronized (vCRPlayerThread) {
            this.notifyAll();
        }
    }

    public boolean isProcessing() {
        return this._processing;
    }

    public void setRunnable(Runnable run) {
        this._runGuy = run;
    }
}

