/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.File;
import java.io.FilenameFilter;

public class WildCardFileFilter
implements FilenameFilter {
    private char[] _pattern;
    private boolean _acceptAll = false;
    private boolean _acceptDirectories = true;

    public WildCardFileFilter(String s) {
        this.setPattern(s);
    }

    public char[] getPattern() {
        return this._pattern;
    }

    public void setPattern(String s) {
        s = s.trim();
        s = WildCardFileFilter.toMinimalPattern(s);
        if ((s = s.toUpperCase()).equals("*") || s.equals("*.*")) {
            this._acceptAll = true;
        }
        this._pattern = s.toCharArray();
    }

    public void setAcceptDirectories(boolean b) {
        this._acceptDirectories = b;
    }

    @Override
    public boolean accept(File dir, String file) {
        File f;
        if (this._acceptAll) {
            return true;
        }
        if (this._acceptDirectories && (f = new File(dir.getPath() + File.separator + file)).isDirectory()) {
            return true;
        }
        String s = file;
        s = s.toUpperCase();
        char[] ca = s.toCharArray();
        return WildCardFileFilter.match(this._pattern, 0, ca, 0);
    }

    public static String toMinimalPattern(String s) {
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        int x = 0;
        int y = s.indexOf(42);
        while (x <= y) {
            sb.append(s.substring(x, ++y));
            x = y;
            while (y < len && s.charAt(y) == '*') {
                x = ++y;
            }
            y = s.indexOf(42, x);
        }
        sb.append(s.substring(x));
        return sb.toString();
    }

    public static boolean match(String pattern, String fileName) {
        pattern = pattern.trim();
        pattern = WildCardFileFilter.toMinimalPattern(pattern);
        pattern = pattern.toUpperCase();
        char[] ca1 = pattern.toCharArray();
        fileName = fileName.trim();
        fileName = fileName.toUpperCase();
        char[] ca2 = fileName.toCharArray();
        return WildCardFileFilter.match(ca1, 0, ca2, 0);
    }

    private static boolean match(char[] pattern, int px, char[] name, int nx) {
        while (px < pattern.length) {
            char pc = pattern[px];
            if (pc == '*') {
                if (px >= pattern.length - 1) {
                    return true;
                }
                for (int x = nx; x < name.length; ++x) {
                    if (!WildCardFileFilter.match(pattern, px + 1, name, x)) continue;
                    return true;
                }
                ++px;
                continue;
            }
            if (nx >= name.length) {
                return false;
            }
            if (pc != '?' && pc != name[nx]) {
                return false;
            }
            ++px;
            ++nx;
        }
        return nx >= name.length;
    }
}

