/*
 * Decompiled with CFR 0.152.
 */
package rma.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicallySizedThreadPool
extends ThreadPoolExecutor {
    private static final Logger LOGGER = Logger.getLogger(DynamicallySizedThreadPool.class.getName());
    private final AtomicLong _requestCount = new AtomicLong();
    private final AtomicLong _requestCountComplete = new AtomicLong();
    private final int _minimumPoolSize;

    public DynamicallySizedThreadPool(int minimumPoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(minimumPoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this._minimumPoolSize = minimumPoolSize;
    }

    public DynamicallySizedThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this._minimumPoolSize = corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable task, Throwable t) {
        try {
            long completeCount = this._requestCountComplete.incrementAndGet();
            LOGGER.log(Level.FINEST, "Request count completed: {0}", completeCount);
            this.tryResetMinThreads();
        }
        finally {
            super.afterExecute(task, t);
        }
    }

    @Override
    public void execute(Runnable task) {
        long count = this._requestCount.incrementAndGet();
        LOGGER.log(Level.FINEST, "Request count: {0}", count);
        super.execute(task);
        this.calcMinThreadLimit();
    }

    private void calcMinThreadLimit() {
        int coreCount = this.determineNextCoreCount();
        coreCount = this.clampToMinMax(coreCount);
        this.updateMinThreadCount(coreCount);
    }

    private int clampToMinMax(int value) {
        return Math.max(this.getCorePoolSize(), Math.min(value, this.getMaximumPoolSize()));
    }

    private int determineNextCoreCount() {
        return this.getQueue().size() + this.getCorePoolSize();
    }

    private synchronized boolean updateMinThreadCount(int count) {
        boolean output = false;
        if (this.getCorePoolSize() != count) {
            this.setCorePoolSize(count);
            LOGGER.log(Level.FINEST, "Updating core pool size: {0}", count);
            output = true;
        }
        return output;
    }

    private void tryResetMinThreads() {
        if (this.getQueue().isEmpty() && this._requestCountComplete.get() == this._requestCount.get() && this.updateMinThreadCount(this._minimumPoolSize)) {
            LOGGER.log(Level.FINEST, "Resetting core pool size");
        }
    }
}

