/*
 * Decompiled with CFR 0.152.
 */
package rma.util.contour;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import rma.services.ServiceLookup;
import rma.services.units.UnitsComponent;
import rma.util.ColorContour;
import rma.util.RMAIO;
import rma.util.contour.ColorContourRecord;

public class ColorContourJPanel
extends JPanel
implements Observer,
UnitsComponent {
    ColorContourRecord _data = null;
    Image _img = null;
    Image _valImg = null;
    int _height = 0;
    int _width = 0;
    int _precision = 1;
    boolean _needToGenerateScale = true;
    boolean _drawTics = true;
    DecimalFormat dFormat = new DecimalFormat();
    int ticDivisor = 100;
    double[] labelVals = null;
    int[] labelX = null;
    int[] labelY = null;
    int _unitSystem = 0;
    ParamDouble _paramDouble = new ParamDouble();
    int _paramId = -1;
    Parameter _param = new Parameter();
    ImageJPanel jPanelColorSample;
    JPanel jPanelValues;
    JLabel jLabelSampleMax;
    JLabel jLabelSampleMin;

    public ColorContourJPanel() {
        this.setFont(new Font("Dialog", 0, 12));
        this.setLayout(new GridBagLayout());
        EtchedBorder eBorder = new EtchedBorder();
        TitledBorder tBorder = new TitledBorder(eBorder, "Scale");
        this.setBorder(tBorder);
        this.jLabelSampleMax = new JLabel();
        this.jLabelSampleMax.setText("0000");
        this.jLabelSampleMax.setHorizontalAlignment(4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.jLabelSampleMin = new JLabel();
        this.jLabelSampleMin.setText("0000");
        this.jLabelSampleMin.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.jPanelValues = new ImageJPanel(){

            @Override
            public void paint(Graphics g) {
                int lastDrawnLabelIndex = -1;
                if (ColorContourJPanel.this._drawTics) {
                    g.setColor(ColorContourJPanel.this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (ColorContourJPanel.this._valImg != null) {
                        Graphics2D g2;
                        Composite oldac = null;
                        if (g instanceof Graphics2D && ColorContourJPanel.this._data != null) {
                            g2 = (Graphics2D)g;
                            oldac = g2.getComposite();
                            AlphaComposite ac = AlphaComposite.getInstance(3, ColorContourJPanel.this._data.getAlpha());
                            g2.setComposite(ac);
                        }
                        g.drawImage(ColorContourJPanel.this._valImg, 0, 0, this);
                        if (g instanceof Graphics2D) {
                            g2 = (Graphics2D)g;
                            if (oldac != null) {
                                g2.setComposite(oldac);
                            }
                        }
                        FontMetrics fm = g.getFontMetrics();
                        int fontHeight = fm.getHeight();
                        int fontAscent = fm.getAscent();
                        int fontDescent = fm.getDescent();
                        if (ColorContourJPanel.this.labelVals != null) {
                            g.setColor(Color.black);
                            int width = this.getWidth();
                            for (int ii = 0; ii < ColorContourJPanel.this.labelVals.length; ++ii) {
                                String val = ColorContourJPanel.this.convertValueToString(ColorContourJPanel.this.labelVals[ii]);
                                int stringWidth = fm.stringWidth(val);
                                int x = width - stringWidth;
                                if (x < 0) {
                                    x = 0;
                                }
                                if (lastDrawnLabelIndex >= 0 && ColorContourJPanel.this.labelY[ii] + fontHeight > ColorContourJPanel.this.labelY[lastDrawnLabelIndex] || lastDrawnLabelIndex >= 0 && ColorContourJPanel.this.labelY[lastDrawnLabelIndex] == ColorContourJPanel.this._height && ColorContourJPanel.this.labelY[ii] + fontHeight > ColorContourJPanel.this.labelY[ii] + fontHeight / 2) continue;
                                if (ColorContourJPanel.this.labelY[ii] - fontAscent < 0) {
                                    g.drawString(val, x, ColorContourJPanel.this.labelY[ii] + fontAscent);
                                    lastDrawnLabelIndex = ii;
                                    continue;
                                }
                                if (ColorContourJPanel.this.labelY[ii] + fontHeight / 2 > ColorContourJPanel.this._height) {
                                    int diff = ColorContourJPanel.this.labelY[ii] + fontHeight / 2 - ColorContourJPanel.this._height;
                                    g.drawString(val, x, ColorContourJPanel.this.labelY[ii] + fontHeight / 2 - diff);
                                    lastDrawnLabelIndex = ii;
                                    continue;
                                }
                                if (ColorContourJPanel.this.labelY[ii] - fontDescent <= 0) continue;
                                g.drawString(val, x, ColorContourJPanel.this.labelY[ii] + fontHeight / 2);
                                lastDrawnLabelIndex = ii;
                            }
                        }
                    }
                }
            }
        };
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.ipadx = 20;
        gbc.ipady = 60;
        gbc.anchor = 13;
        gbc.fill = 1;
        this.add((Component)this.jPanelValues, gbc);
        this.jPanelColorSample = new ImageJPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 20;
        gbc.ipady = 60;
        gbc.anchor = 13;
        gbc.fill = 1;
        this.add((Component)this.jPanelColorSample, gbc);
    }

    public void setDataRecord(ColorContourRecord data) {
        if (this._data != null) {
            this._data.deleteObserver(this);
        }
        this._data = data;
        if (this._data == null) {
            return;
        }
        this._data.addObserver(this);
        ColorContour cc = this._data.getColorContour();
        double min = cc.getMinValue();
        double max = cc.getMaxValue();
        double[] aMax = new double[]{max};
        double[] aMin = new double[]{min};
        this.computeNiceMinMax(aMin, aMax);
        max = aMax[0];
        min = aMin[0];
        this.jLabelSampleMin.setText(RMAIO.setPrecision2(min, 2));
        this.jLabelSampleMax.setText(RMAIO.setPrecision2(max, 2));
        this._needToGenerateScale = true;
        this._unitSystem = this._data.getUnitSystem();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.paintScale();
        this.repaint();
    }

    public ColorContourRecord getDataRecord() {
        return this._data;
    }

    private void computeNiceMinMax(double[] min, double[] max) {
        if (min[0] == max[0]) {
            double v = min[0];
            min[0] = min[0] - min[0] / 2.0;
            max[0] = max[0] + max[0] / 2.0;
        }
    }

    public void paintScale() {
        int jj;
        int rgb;
        int ii;
        if (this._data == null) {
            return;
        }
        FontMetrics fm = this.jPanelValues.getFontMetrics(this.jPanelValues.getFont());
        int fontHeight = fm.getHeight();
        this._width = this.jPanelColorSample.getWidth();
        this._height = this.jPanelColorSample.getHeight();
        if (this._width < 1 || this._height < 1) {
            return;
        }
        int valuesWidth = this.jPanelValues.getWidth();
        int valuesHeight = this.jPanelValues.getHeight();
        ColorContour cc = this._data.getColorContour();
        double max = cc.getMaxValue();
        double min = cc.getMinValue();
        double[] aMax = new double[]{max};
        double[] aMin = new double[]{min};
        this.computeNiceMinMax(aMin, aMax);
        max = aMax[0];
        min = aMin[0];
        double ticInterval = this._data.getTicInterval();
        if (ticInterval <= 0.0) {
            return;
        }
        float convertedTicValue = (float)this.convertValue(ticInterval);
        if ((double)convertedTicValue == Double.NEGATIVE_INFINITY) {
            return;
        }
        String s = "";
        try {
            s = Float.toString(convertedTicValue);
        }
        catch (Exception e) {
            return;
        }
        int idx = s.indexOf(".");
        if (idx > -1) {
            String repeated = "9999";
            int repeatIdx = s.indexOf(repeated);
            if (repeatIdx - idx >= 0) {
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(repeatIdx - idx);
                df.setMinimumFractionDigits(0);
                s = df.format(convertedTicValue);
            }
            s = s.substring(idx);
            this._precision = s.length() - idx;
        } else {
            this._precision = 1;
        }
        this.dFormat.setMaximumFractionDigits(this._precision);
        this.dFormat.setMinimumFractionDigits(this._precision);
        double valHeight = max - min;
        if (valHeight > 0.0) {
            if ((double)convertedTicValue > valHeight) {
                convertedTicValue = (float)valHeight;
            }
        } else {
            return;
        }
        int numtics = (int)Math.floor(valHeight / (double)convertedTicValue) + 1;
        if (numtics < 0) {
            numtics = 0;
        }
        int blackRgb = Color.black.getRGB();
        int backRgb = this.getBackground().getRGB();
        double ticValue = min;
        int[] pix = new int[this._width * this._height];
        int[] vals = new int[valuesWidth * valuesHeight];
        double[] tmpLabelVals = new double[numtics];
        this.labelX = new int[numtics];
        this.labelY = new int[numtics];
        double scl = (max - min) / (double)this._height;
        for (ii = 0; ii < this._height; ++ii) {
            double val = max - (double)ii * scl;
            rgb = cc.getRGB(val, 1.0);
            for (jj = 0; jj < this._width; ++jj) {
                pix[ii * this._width + jj] = rgb;
            }
        }
        for (ii = 0; ii < numtics; ++ii) {
            double pixelPos = (double)(this._height - 1) * ((max - ticValue) / valHeight);
            this.labelX[ii] = 0;
            this.labelY[ii] = (int)pixelPos;
            tmpLabelVals[ii] = ticValue;
            rgb = blackRgb;
            for (jj = 0; (int)pixelPos * this._width + jj < pix.length && jj < this._width; ++jj) {
                pix[(int)pixelPos * this._width + jj] = rgb;
            }
            if (vals != null && vals.length > 0) {
                for (jj = 0; (int)pixelPos * this._width + jj < vals.length && jj < 5; ++jj) {
                    vals[(int)pixelPos * this._width + jj] = rgb;
                }
            }
            ticValue += (double)convertedTicValue;
        }
        if (numtics != tmpLabelVals.length) {
            this.labelVals = new double[numtics];
            System.arraycopy(tmpLabelVals, 0, this.labelVals, 0, this.labelVals.length);
        } else {
            this.labelVals = tmpLabelVals;
        }
        MemoryImageSource mis = new MemoryImageSource(this._width, this._height, pix, 0, this._width);
        this._img = Toolkit.getDefaultToolkit().createImage(mis);
        mis = new MemoryImageSource(valuesWidth, valuesHeight, vals, 0, valuesWidth);
        this._valImg = Toolkit.getDefaultToolkit().createImage(mis);
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this._img, 0);
        tracker.addImage(this._valImg, 1);
        try {
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tracker.waitForID(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jPanelColorSample.repaint();
        if (this._drawTics) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ColorContourJPanel.this.jPanelValues.repaint();
                }
            });
        }
    }

    public void setDrawTics(boolean b) {
        this._drawTics = b;
        this.jPanelValues.setVisible(b);
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleValue) {
        if (this._unitSystem == 0) {
            return;
        }
        if (paramId != this._paramId) {
            return;
        }
        this.jPanelColorSample.repaint();
    }

    @Override
    public void setDisplayUnitsSystem(int unitSys) {
        if (this._unitSystem == 0) {
            return;
        }
        this.jPanelColorSample.repaint();
    }

    @Override
    public String getDisplayUnitsString(int unitSys) {
        return "";
    }

    private double convertValue(double d) {
        int displayUnitsSys;
        if (this._data == null) {
            return Double.NEGATIVE_INFINITY;
        }
        String units = this._data.getUnits();
        String newUnits = Units.getUnitsForAlias(units);
        if (newUnits != null) {
            units = newUnits;
        } else {
            newUnits = units;
        }
        this._paramDouble.setValue(d);
        int paramId = this._data.getParamId();
        if (paramId != -1 && (displayUnitsSys = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem()) != this._data.getUnitSystem()) {
            String displayUnits = Parameter.getUnitsStringForSystem(paramId, displayUnitsSys);
            try {
                this._paramDouble = Units.convertUnits(this._paramDouble, newUnits, displayUnits);
            }
            catch (Exception eee) {
                return this._paramDouble.getValue();
            }
        }
        return this._paramDouble.getValue();
    }

    private String convertValueToString(double d) {
        if (this._unitSystem == 0) {
            return this.dFormat.format(d);
        }
        double newVal = this.convertValue(d);
        if (newVal == Double.NEGATIVE_INFINITY) {
            return "";
        }
        return this.dFormat.format(newVal);
    }

    public JPanel getPanelValues() {
        return this.jPanelValues;
    }

    class ImageJPanel
    extends JPanel {
        ImageJPanel() {
        }

        @Override
        public void paint(Graphics g) {
            if (g != null) {
                if (ColorContourJPanel.this._needToGenerateScale || ColorContourJPanel.this._height != this.getHeight() || ColorContourJPanel.this._width != this.getWidth()) {
                    ColorContourJPanel.this.paintScale();
                    ColorContourJPanel.this._needToGenerateScale = false;
                }
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (ColorContourJPanel.this._img != null) {
                    Graphics2D g2;
                    Composite oldac = null;
                    if (g instanceof Graphics2D && ColorContourJPanel.this._data != null) {
                        g2 = (Graphics2D)g;
                        oldac = g2.getComposite();
                        AlphaComposite ac = AlphaComposite.getInstance(3, ColorContourJPanel.this._data.getAlpha());
                        g2.setComposite(ac);
                    }
                    g.drawImage(ColorContourJPanel.this._img, 0, 0, this);
                    if (g instanceof Graphics2D) {
                        g2 = (Graphics2D)g;
                        if (oldac != null) {
                            g2.setComposite(oldac);
                        }
                    }
                }
            }
        }
    }
}

