/*
 * Decompiled with CFR 0.152.
 */
package rma.util.debug;

import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public abstract class CheckThreadViolationRepaintManager
extends RepaintManager {
    private final boolean completeCheck;
    private WeakReference<JComponent> lastComponent;

    CheckThreadViolationRepaintManager() {
        this(true);
    }

    CheckThreadViolationRepaintManager(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations(CheckThreadViolationRepaintManager.checkNotNull(component));
        super.addInvalidComponent(component);
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    @Override
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations(CheckThreadViolationRepaintManager.checkNotNull(component));
        super.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c2) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c2.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean imageUpdate = false;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean isRma = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if ("repaint".equals(st.getMethodName())) {
                    repaint = true;
                    fromSwing = false;
                }
                if (isRma) continue;
                isRma = this.checkIfRma(st);
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (!isRma) {
                return;
            }
            if (this.lastComponent != null && c2 == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c2);
            this.violationFound(c2, stackTrace);
        }
    }

    abstract void violationFound(JComponent var1, StackTraceElement[] var2);

    private boolean checkIfRma(StackTraceElement st) {
        boolean retval = false;
        String className = st.getClassName();
        if (className.contains("usace") && !className.endsWith("CheckThreadViolationRepaintManager")) {
            retval = true;
        }
        if (className.startsWith("hec")) {
            retval = true;
        }
        if (className.contains("wcds")) {
            retval = true;
        }
        if (className.startsWith("rma")) {
            retval = true;
        }
        if (className.contains("hec2")) {
            retval = true;
        }
        if (className.contains("com.rma")) {
            retval = true;
        }
        if (className.contains("cwmsdb")) {
            retval = true;
        }
        return retval;
    }
}

