/*
 * Decompiled with CFR 0.152.
 */
package rma.util.debug;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import rma.util.debug.CheckThreadViolationRepaintManager;
import rma.util.debug.EdtViolationException;

public class LogViolationRepaintManager
extends CheckThreadViolationRepaintManager {
    private static final Logger logger = Logger.getLogger(LogViolationRepaintManager.class.getName());
    public static final String PROP = "LogEDT";
    private static RepaintManager previousRepaintManager;

    public static LogViolationRepaintManager install() {
        RepaintManager m = LogViolationRepaintManager.currentRepaintManager();
        if (m instanceof LogViolationRepaintManager) {
            return (LogViolationRepaintManager)m;
        }
        return LogViolationRepaintManager.installNew();
    }

    public static Boolean possiblyInstall() {
        boolean shouldLog = Boolean.getBoolean(PROP);
        if (shouldLog) {
            LogViolationRepaintManager.install();
        }
        return shouldLog;
    }

    public static RepaintManager uninstall() {
        RepaintManager restored = previousRepaintManager;
        if (restored != null) {
            LogViolationRepaintManager.setCurrentManager(restored);
            previousRepaintManager = null;
        }
        return restored;
    }

    private static RepaintManager currentRepaintManager() {
        try {
            RepaintManager repaintManager = LogViolationRepaintManager.currentManager(null);
            if (repaintManager instanceof RepaintManager) {
                return repaintManager;
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        return null;
    }

    private static LogViolationRepaintManager installNew() {
        LogViolationRepaintManager m = new LogViolationRepaintManager();
        previousRepaintManager = LogViolationRepaintManager.currentRepaintManager();
        LogViolationRepaintManager.setCurrentManager(m);
        return m;
    }

    public LogViolationRepaintManager() {
    }

    public LogViolationRepaintManager(boolean completeCheck) {
        super(completeCheck);
    }

    @Override
    void violationFound(JComponent c2, StackTraceElement[] stackTraceElements) {
        EdtViolationException e = new EdtViolationException("This is not an uncaught exception, it is the cause of the EDT violation.");
        e.setStackTrace(stackTraceElements);
        logger.log(Level.WARNING, "Thread " + Thread.currentThread().getName() + " is improperly accessing UI components.", e);
    }
}

