/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CustomFormatter
extends Formatter {
    private static final Logger logger = Logger.getLogger(CustomFormatter.class.getName());
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS Z";
    private static final DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    public static final String DEFAULT_FORMAT = "%t %L: %E %m";
    protected static final StackTraceElement nullElement = new StackTraceElement("?", "?", "?", -1);
    private final MessageFormat messageFormat;
    private final boolean[] needsArg;
    private final DateFormat dateFormat;
    protected static final boolean useReflective;
    private static final Method getStackTraceElement;
    private static final Method getStackTraceDepth;

    public CustomFormatter() {
        String propName;
        Object format;
        LogManager logManager = LogManager.getLogManager();
        String classname = this.getClass().getName();
        String dateFormatKey = classname + ".date.format";
        String strDateFormat = logManager.getProperty(dateFormatKey);
        this.dateFormat = strDateFormat != null ? new SimpleDateFormat(strDateFormat) : defaultDateFormat;
        String dateFormatTimeZoneKey = classname + ".date.timezone";
        String strDateFormatTimeZone = logManager.getProperty(dateFormatTimeZoneKey);
        if (strDateFormatTimeZone != null) {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone(strDateFormatTimeZone));
        }
        if ((format = logManager.getProperty(propName = classname + ".format")) == null || ((String)format).trim().length() == 0) {
            format = DEFAULT_FORMAT;
        }
        if (((String)format).contains("{") || ((String)format).contains("}")) {
            throw new IllegalArgumentException("curly braces not allowed");
        }
        format = ((String)format).replace("%L", "{0}").replace("%m", "{1}").replace("%M", "{2}").replace("%t", "{3}").replace("%c", "{4}").replace("%T", "{5}").replace("%n", "{6}").replace("%C", "{7}").replace("%E", "{8}") + "\n";
        this.messageFormat = new MessageFormat((String)format);
        Format[] formatsByArgumentIndex = this.messageFormat.getFormatsByArgumentIndex();
        this.needsArg = new boolean[9];
        for (int i = 0; i < formatsByArgumentIndex.length; ++i) {
            this.needsArg[i] = ((String)format).contains("{" + i + "}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        Object[] arguments = new String[9];
        StringBuffer sb = new StringBuffer(256);
        if (this.needsArg[0]) {
            arguments[0] = record.getLevel().toString();
        }
        if (this.needsArg[1]) {
            sb = this.formatMessage(record, sb);
            sb = this.getThrowableMessage(record, sb);
            arguments[1] = sb.toString();
        }
        arguments[2] = this.needsArg[2] ? record.getSourceMethodName() : "?";
        if (this.needsArg[3]) {
            sb.delete(0, sb.length());
            Date date = new Date(record.getMillis());
            FieldPosition fieldPos = new FieldPosition(0);
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                sb = this.dateFormat.format(date, sb, fieldPos);
            }
            arguments[3] = sb.toString();
        }
        arguments[4] = this.needsArg[4] || this.needsArg[7] ? record.getSourceClassName() : "?";
        if (this.needsArg[5]) {
            arguments[5] = Integer.toString(record.getThreadID());
        }
        if (this.needsArg[6]) {
            arguments[6] = record.getLoggerName();
        }
        if (this.needsArg[7]) {
            int start = arguments[4].lastIndexOf(46) + 1;
            arguments[7] = start > 0 && start < arguments[4].length() ? arguments[4].substring(start) : arguments[4];
        }
        if (this.needsArg[8]) {
            sb.delete(0, sb.length());
            this.getEclipseFormat(record, sb);
            arguments[8] = sb.toString();
        } else {
            arguments[8] = "(?:?)";
        }
        sb.delete(0, sb.length());
        FieldPosition fieldPos = new FieldPosition(0);
        MessageFormat messageFormat = this.messageFormat;
        synchronized (messageFormat) {
            sb = this.messageFormat.format(arguments, sb, fieldPos);
        }
        return sb.toString();
    }

    public synchronized StringBuffer formatMessage(LogRecord record, StringBuffer result) {
        String format = record.getMessage();
        ResourceBundle catalog = record.getResourceBundle();
        if (catalog != null) {
            try {
                format = catalog.getString(record.getMessage());
            }
            catch (MissingResourceException ex) {
                format = record.getMessage();
            }
        }
        try {
            Object[] parameters = record.getParameters();
            if (parameters == null || parameters.length == 0) {
                result.append(format);
            } else if (format.indexOf("{0") >= 0 || format.indexOf("{1") >= 0 || format.indexOf("{2") >= 0 || format.indexOf("{3") >= 0) {
                MessageFormat temp = new MessageFormat(format);
                temp.format(parameters, result, new FieldPosition(0));
            } else {
                result.append(format);
            }
        }
        catch (Exception ex) {
            result.append(format);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer getThrowableMessage(LogRecord record, StringBuffer sb) {
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            try (PrintWriter pw = null;){
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.flush();
                sb.append('\n').append(sw.toString());
            }
        }
        return sb;
    }

    public StringBuffer getEclipseFormat(LogRecord logRecord, StringBuffer sb) {
        Throwable newThrowable = new Throwable();
        StackTraceElement element = this.logRecordHasLogSite(logRecord) ? this.findCallingElementByName(newThrowable, logRecord.getSourceClassName(), logRecord.getSourceMethodName(), 7) : (useReflective ? this.findCallingElementReflective(newThrowable, 7) : CustomFormatter.findCallingElement(newThrowable, 7));
        CustomFormatter.appendEclipseFormat(element, sb);
        return sb;
    }

    private boolean logRecordHasLogSite(LogRecord logRecord) {
        if (logRecord != null && logRecord.getSourceClassName() != null && logRecord.getSourceMethodName() != null) {
            return !logRecord.getSourceClassName().isEmpty() && !logRecord.getSourceMethodName().isEmpty();
        }
        return false;
    }

    public static StringBuffer appendEclipseFormat(StackTraceElement element, StringBuffer sb) {
        if (element == null || nullElement == element) {
            sb.append("(?:?)");
        } else {
            String filename = element.getFileName();
            int lineNumber = element.getLineNumber();
            if (lineNumber <= 0) {
                if (filename == null || filename.isEmpty()) {
                    sb.append("(?:?)");
                } else {
                    sb.append('(').append(filename).append(":?)");
                }
            } else if (filename == null || filename.isEmpty()) {
                sb.append("(?:").append(lineNumber).append(')');
            } else {
                sb.append('(').append(filename).append(':').append(lineNumber).append(')');
            }
        }
        return sb;
    }

    private StackTraceElement findCallingElementByName(Throwable newThrowable, String className, String methodName, int skip) {
        StackTraceElement element = nullElement;
        StackTraceElement[] stackTrace = newThrowable.getStackTrace();
        int stackTraceSize = stackTrace.length;
        for (int i = skip; i < stackTraceSize; ++i) {
            StackTraceElement testing = stackTrace[i];
            if (!className.equals(testing.getClassName()) || !methodName.equals(testing.getMethodName())) continue;
            element = testing;
            break;
        }
        return element;
    }

    public static StackTraceElement findCallingElement(Throwable newThrowable, int depth) {
        StackTraceElement retval = nullElement;
        StackTraceElement[] stackTrace = newThrowable.getStackTrace();
        int lastIdx = CustomFormatter.firstIndexNot(stackTrace, Logger.class.getName(), depth);
        if (lastIdx >= 0 && lastIdx < stackTrace.length) {
            retval = stackTrace[lastIdx];
        }
        return retval;
    }

    private static int firstIndexNot(StackTraceElement[] stackTrace, String classname, int fromIndex) {
        int idx = -1;
        if (classname != null && stackTrace != null && fromIndex >= 0 && stackTrace.length > fromIndex) {
            for (int i = fromIndex; i < stackTrace.length; ++i) {
                if (classname.equals(stackTrace[i].getClassName())) continue;
                idx = i;
                break;
            }
        }
        return idx;
    }

    private StackTraceElement findCallingElementReflective(Throwable newThrowable, int depth) {
        StackTraceElement element = nullElement;
        String classname = Logger.class.getName();
        try {
            int maxDepth = CustomFormatter.getStackTraceDepth(newThrowable);
            if (depth < maxDepth) {
                element = CustomFormatter.getStackTraceElement(newThrowable, depth++);
                while (depth < maxDepth && element != null && classname.equals(element.getClassName())) {
                    element = CustomFormatter.getStackTraceElement(newThrowable, depth++);
                }
            }
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "Caught an IllegalAccessException getting StackTraceElement.", ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, "Caught an IllegalArgumentException getting StackTraceElement.", ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.SEVERE, "Caught an InvocationTargetException getting StackTraceElement.", ex);
        }
        return element;
    }

    public static int getStackTraceDepth(Throwable newThrowable) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        int maxDepth;
        if (useReflective) {
            maxDepth = (Integer)getStackTraceDepth.invoke((Object)newThrowable, new Object[0]);
        } else {
            StackTraceElement[] stackTrace = newThrowable.getStackTrace();
            maxDepth = stackTrace.length;
        }
        return maxDepth;
    }

    public static StackTraceElement getStackTraceElement(Throwable newThrowable, int depth) {
        StackTraceElement element = nullElement;
        if (useReflective) {
            try {
                element = (StackTraceElement)getStackTraceElement.invoke((Object)newThrowable, depth);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.WARNING, "Caught an IllegalAccessException getting StackTraceElement.", ex);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.WARNING, "Caught an IllegalArgumentException getting StackTraceElement.", ex);
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.WARNING, "Caught an InvocationTargetException getting StackTraceElement.", ex);
            }
        } else {
            StackTraceElement[] stackTrace = newThrowable.getStackTrace();
            if (stackTrace != null && stackTrace.length > depth) {
                element = stackTrace[depth];
            }
        }
        return element;
    }

    public static boolean useReflection() {
        return useReflective;
    }

    static {
        boolean shouldUseReflective = false;
        Method getSTE = null;
        Method getSTD = null;
        try {
            getSTE = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            getSTE.setAccessible(true);
            getSTD = Throwable.class.getDeclaredMethod("getStackTraceDepth", new Class[0]);
            getSTD.setAccessible(true);
            shouldUseReflective = true;
        }
        catch (NoSuchMethodException | NullPointerException | SecurityException e) {
            logger.log(Level.FINE, "Could not get reflective access to getStackTraceElement and getStackTraceDepth.  Defaulting to standard method calls.", e);
        }
        getStackTraceElement = getSTE;
        getStackTraceDepth = getSTD;
        useReflective = shouldUseReflective;
    }
}

