/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import java.util.logging.Filter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public abstract class DecoratingLogFilter
implements Filter {
    private Filter _filter = null;

    public DecoratingLogFilter() {
        this.configure();
    }

    private void configure() {
        String cname = this.getClass().getName();
        this.setFilter(this.getFilterProperty(cname + ".filter", null));
    }

    public void setFilter(Filter filterProperty) {
        this._filter = filterProperty;
    }

    protected Filter getFilterProperty(String name, Filter defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        boolean retval = true;
        if (this._filter != null) {
            retval = this._filter.isLoggable(record);
        }
        return retval;
    }
}

