/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import rma.util.logging.DecoratingLogFilter;

public class LevelCeilingFilter
extends DecoratingLogFilter {
    private int _level = Level.INFO.intValue();

    public LevelCeilingFilter() {
        this.configure();
    }

    private void configure() {
        String cname = this.getClass().getName();
        this.setLevel(this.getLevelProperty(cname + ".level", Level.INFO));
    }

    public void setLevel(Level levelProperty) {
        if (levelProperty != null) {
            this._level = levelProperty.intValue();
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        Level recordLevel;
        boolean retval = false;
        if (record != null && (recordLevel = record.getLevel()) != null && recordLevel.intValue() <= this._level) {
            retval = super.isLoggable(record);
        }
        return retval;
    }

    protected Level getLevelProperty(String name, Level defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }
}

