/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class LogLevelSetterDemo {
    private static final String NAME_OF_LOGGER_TO_CHANGE = "LoggingLevelDemo";
    private static final Logger logger = Logger.getLogger(LogLevelSetterDemo.class.getName());

    public static void main(String[] args) throws IOException {
        JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:56002/jmxrmi");
        JMXConnector connector = JMXConnectorFactory.connect(address);
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        LoggingMXBean proxy = ManagementFactory.newPlatformMXBeanProxy(connection, "java.util.logging:type=Logging", LoggingMXBean.class);
        StringBuilder sb = new StringBuilder();
        for (String name : proxy.getLoggerNames()) {
            sb.append(name);
            sb.append(' ');
        }
        logger.warning("Logger names: " + sb.toString());
        String loggerLevel = proxy.getLoggerLevel(NAME_OF_LOGGER_TO_CHANGE);
        if (args.length != 0) {
            logger.warning("LoggingLevelDemo level was:" + loggerLevel + " setting to " + args[0]);
            proxy.setLoggerLevel(NAME_OF_LOGGER_TO_CHANGE, args[0]);
        }
        if (loggerLevel == null || !loggerLevel.equals(Level.WARNING.getName()) && !loggerLevel.equals(Level.FINEST.getName())) {
            logger.warning("LoggingLevel level was:" + loggerLevel + " setting to warning");
            proxy.setLoggerLevel(NAME_OF_LOGGER_TO_CHANGE, Level.WARNING.getName());
        } else if (loggerLevel.equals(Level.WARNING.getName())) {
            logger.warning("LoggingLevel level was:" + loggerLevel + " setting to finest");
            proxy.setLoggerLevel(NAME_OF_LOGGER_TO_CHANGE, Level.FINEST.getName());
        } else if (loggerLevel.equals(Level.FINEST.getName())) {
            logger.warning("LoggingLevel level was:" + loggerLevel + " setting to warning");
            proxy.setLoggerLevel(NAME_OF_LOGGER_TO_CHANGE, Level.WARNING.getName());
        }
    }
}

