/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingLevelDemo {
    private static final Logger logger = Logger.getLogger(LoggingLevelDemo.class.getName());
    private static final Logger logger2 = Logger.getLogger(LoggingLevelDemo.class.getName(), "rma.util.logging.logging");

    public static void main(String[] args) throws InterruptedException {
        while (true) {
            LoggingLevelDemo.logMessage(Level.FINEST);
            Thread.sleep(250L);
            LoggingLevelDemo.logMessage(Level.FINER);
            Thread.sleep(250L);
            LoggingLevelDemo.logMessage(Level.FINE);
            Thread.sleep(250L);
            LoggingLevelDemo.logWithArgs(Level.FINE);
            Thread.sleep(250L);
            LoggingLevelDemo.logWithArgsFromBundle(Level.FINE);
            Thread.sleep(250L);
            LoggingLevelDemo.logMessage(Level.INFO);
            Thread.sleep(250L);
            LoggingLevelDemo.logMessage(Level.WARNING);
            Thread.sleep(250L);
            LoggingLevelDemo.logMessage(Level.SEVERE);
            Thread.sleep(250L);
            try {
                LoggingLevelDemo.throwAnException();
                continue;
            }
            catch (Exception e) {
                Logger.getLogger(LoggingLevelDemo.class.getName()).log(Level.WARNING, "Caught an Exception", e);
                continue;
            }
            break;
        }
    }

    private static void logMessage(Level level) {
        logger.log(level, level.getName() + " message.");
    }

    private static void logWithArgs(Level level) {
        Integer int13 = 13;
        Integer int42 = 42;
        String msg = level.getName() + " Hello world, your lucky numbers are: {0}, {1}";
        logger.log(level, msg, new Object[]{int13, int42});
    }

    private static void logWithArgsFromBundle(Level level) {
        Integer int13 = 13;
        Integer int42 = 42;
        String msgKey = "Message1";
        logger2.log(level, msgKey, new Object[]{int13, int42});
    }

    private static void throwAnException() throws Exception {
        throw new IllegalArgumentException("A Fake illegal argument exception");
    }
}

