/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.LogContext;
import com.google.common.flogger.LoggingApi;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.parser.DefaultPrintfMessageParser;
import com.google.common.flogger.parser.MessageParser;
import java.util.logging.Level;
import rma.util.logging.MarkingClassLoggerBackendWrapper;

public final class MarkingClassLogger
extends AbstractLogger<Api> {
    static final NoOp NO_OP = new NoOp();

    public static MarkingClassLogger forMarkingClass(Class<?> markingClass) {
        String loggingClass = Platform.getCallerFinder().findLoggingClass(MarkingClassLogger.class);
        return new MarkingClassLogger(new MarkingClassLoggerBackendWrapper(Platform.getBackend((String)loggingClass), Platform.getBackend((String)markingClass.getName())));
    }

    private MarkingClassLogger(MarkingClassLoggerBackendWrapper markingLoggerBackendWrapper) {
        super((LoggerBackend)markingLoggerBackendWrapper);
    }

    public Api at(Level level) {
        boolean isLoggable = this.isLoggable(level);
        boolean isForced = Platform.shouldForceLogging((String)this.getName(), (Level)level, (boolean)isLoggable);
        return isLoggable || isForced ? new Context(level, isForced) : NO_OP;
    }

    final class Context
    extends LogContext<MarkingClassLogger, Api>
    implements Api {
        private Context(Level level, boolean isForced) {
            super(level, isForced);
        }

        protected MarkingClassLogger getLogger() {
            return MarkingClassLogger.this;
        }

        protected Api api() {
            return this;
        }

        protected Api noOp() {
            return NO_OP;
        }

        protected MessageParser getMessageParser() {
            return DefaultPrintfMessageParser.getInstance();
        }
    }

    private static final class NoOp
    extends LoggingApi.NoOp<Api>
    implements Api {
        private NoOp() {
        }
    }

    public static interface Api
    extends HecLoggingApi<Api> {
    }

    private static interface HecLoggingApi<API extends HecLoggingApi<API>>
    extends LoggingApi<API> {
    }
}

