/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.LoggerBackend;
import java.util.logging.Level;

public class MarkingClassLoggerBackendWrapper
extends LoggerBackend {
    private LoggerBackend _toWrap;
    private LoggerBackend _markingClassLogger;

    public MarkingClassLoggerBackendWrapper(LoggerBackend toWrap, LoggerBackend markingClassLogger) {
        this._toWrap = toWrap;
        this._markingClassLogger = markingClassLogger;
    }

    public String getLoggerName() {
        return this._toWrap.getLoggerName();
    }

    public boolean isLoggable(Level lvl) {
        return this._toWrap.isLoggable(lvl) || this._markingClassLogger.isLoggable(lvl);
    }

    public void log(LogData data) {
        Level logLevel = data.getLevel();
        if (this._markingClassLogger.isLoggable(logLevel) && !this._toWrap.isLoggable(logLevel)) {
            this._markingClassLogger.log(data);
        } else {
            this._toWrap.log(data);
        }
    }

    public void handleError(RuntimeException error, LogData badData) {
        Level logLevel = badData.getLevel();
        if (this._markingClassLogger.isLoggable(logLevel) && !this._toWrap.isLoggable(logLevel)) {
            this._markingClassLogger.handleError(error, badData);
        } else {
            this._toWrap.handleError(error, badData);
        }
    }
}

