/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.LogSite;
import java.io.OutputStream;
import java.io.PrintStream;
import rma.util.logging.StackTraceElementLogSite;

public final class OutputStreamLogger
extends OutputStream {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String LINE_SEP = System.lineSeparator();
    private static final int LINE_SEP_LENGTH = LINE_SEP.length();
    private StringBuilder _outputBuffer = new StringBuilder();
    private final Class<?> _wrappingClass;

    public OutputStreamLogger() {
        this(PrintStream.class);
    }

    private OutputStreamLogger(Class<?> wrappingClass) {
        this._wrappingClass = wrappingClass;
    }

    @Override
    public synchronized void write(int b) {
        char character = (char)b;
        this._outputBuffer.append(character);
        if (character == LINE_SEP.charAt(LINE_SEP_LENGTH - 1) && this.endsWithLineSep()) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atInfo()).withInjectedLogSite(this.determineLogSite())).log(this._outputBuffer.toString());
            this.clearBuffer();
        }
    }

    private synchronized void clearBuffer() {
        this._outputBuffer = new StringBuilder();
    }

    private synchronized boolean endsWithLineSep() {
        boolean endsWithLineSep = true;
        int bufferLength = this._outputBuffer.length();
        for (int i = 0; i < LINE_SEP_LENGTH; ++i) {
            int bufferOffset = bufferLength - (LINE_SEP_LENGTH - i);
            if (bufferOffset < 0 || bufferOffset >= bufferLength) {
                endsWithLineSep = false;
                break;
            }
            if (LINE_SEP.charAt(i) == this._outputBuffer.charAt(bufferOffset)) continue;
            endsWithLineSep = false;
            break;
        }
        if (endsWithLineSep) {
            this.trimLineSep(bufferLength);
        }
        return endsWithLineSep;
    }

    private synchronized void trimLineSep(int bufferLength) {
        int bufferStartOffset = bufferLength - LINE_SEP_LENGTH;
        this._outputBuffer.delete(bufferStartOffset, bufferLength);
    }

    private LogSite determineLogSite() {
        StackTraceElement atCurrentIndex;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement lastBeforeWrappingClass = null;
        for (int i = stackTrace.length - 1; i >= 0 && !(atCurrentIndex = stackTrace[i]).getClassName().equals(this._wrappingClass.getName()); --i) {
            lastBeforeWrappingClass = atCurrentIndex;
        }
        if (lastBeforeWrappingClass == null) {
            lastBeforeWrappingClass = stackTrace[stackTrace.length - 3];
        }
        return StackTraceElementLogSite.of(lastBeforeWrappingClass);
    }
}

