/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import rma.util.logging.CustomFormatter;

public class StackFilteringFormatter
extends CustomFormatter {
    private final Set<String> ignoreInStack = new HashSet<String>();

    public StackFilteringFormatter() {
        LogManager logManager = LogManager.getLogManager();
        String classname = this.getClass().getName();
        this.ignoreInStack.add(Logger.class.getName());
        this.ignoreInStack.add("hec2.wat.plugin.gridgaincompute.ProgressLogger");
        this.ignoreInStack.add("java.util.logging.LoggingProxyImpl");
        this.ignoreInStack.add("sun.util.logging.LoggingSupport");
        this.ignoreInStack.add("sun.util.logging.PlatformLogger$JavaLogger");
        this.ignoreInStack.add("sun.util.logging.PlatformLogger$JavaLoggerProxy");
        this.ignoreInStack.add("org.apache.commons.logging.impl.Jdk14Logger");
        this.ignoreInStack.add("sun.util.logging.PlatformLogger");
        this.ignoreInStack.add("hec2.wat.model.progress.FrmComputeProgressHandler");
        this.ignoreInStack.add("hec2.wat.model.progress.ComputeProgressHandler2");
        this.ignoreInStack.add("org.apache.ignite.logger.java.JavaLogger");
        this.ignoreInStack.add("com.rma.model.ComputeProgressHandler");
        this.ignoreInStack.add("rma.util.logging.MarkingClassLogger");
        this.ignoreInStack.add("rma.util.logging.MarkingClassLogger$Api");
        this.ignoreInStack.add("rma.util.logging.MarkingClassLogger$Context");
        this.ignoreInStack.add("rma.util.logging.MarkingClassLogger$HecLoggingApi");
        this.ignoreInStack.add("rma.util.logging.MarkingClassLogger$NoOp");
        this.ignoreInStack.add("rma.util.logging.MarkingClassLoggerBackendWrapper");
        this.ignoreInStack.add("com.google.common.flogger.AbstractLogger");
        this.ignoreInStack.add("com.google.common.flogger.LogContext");
        this.ignoreInStack.add("com.google.common.flogger.FluentLogger");
        this.ignoreInStack.add("org.apache.ignite.internal.GridLoggerProxy");
        String extraIgnores = logManager.getProperty(classname + ".stackignore");
        if (extraIgnores != null && !extraIgnores.isEmpty()) {
            String[] split;
            for (String string : split = extraIgnores.split(",")) {
                this.ignoreInStack.add(string.trim());
            }
        }
    }

    @Override
    public StringBuffer getEclipseFormat(LogRecord logRecord, StringBuffer sb) {
        return this.getEclipseFormat(sb, this.ignoreInStack);
    }

    protected StringBuffer getEclipseFormat(StringBuffer sb, Set<String> ignoreInStack2) {
        StackTraceElement element = StackFilteringFormatter.findCallingElement(ignoreInStack2);
        StackFilteringFormatter.appendEclipseFormat(element, sb);
        return sb;
    }

    public static StackTraceElement findCallingElement(Set<String> ignoreClassnames) {
        StackTraceElement element = nullElement;
        int depth = 9;
        try {
            Throwable newThrowable = new Throwable();
            if (useReflective) {
                int maxDepth = StackFilteringFormatter.getStackTraceDepth(newThrowable);
                element = StackFilteringFormatter.getStackTraceElement(newThrowable, depth++);
                if (ignoreClassnames != null && !ignoreClassnames.isEmpty()) {
                    while (depth < maxDepth && element != null && ignoreClassnames.contains(element.getClassName())) {
                        element = StackFilteringFormatter.getStackTraceElement(newThrowable, depth++);
                    }
                }
            } else {
                StackTraceElement[] stackTrace = newThrowable.getStackTrace();
                int lastIdx = StackFilteringFormatter.firstIndexNot(stackTrace, ignoreClassnames, depth);
                if (lastIdx >= 0 && lastIdx < stackTrace.length) {
                    element = stackTrace[lastIdx];
                }
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CustomFormatter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CustomFormatter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(CustomFormatter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return element;
    }

    private static int firstIndexNot(StackTraceElement[] stackTrace, Set<String> declaringClasses, int fromIndex) {
        int idx = -1;
        if (declaringClasses != null && !declaringClasses.isEmpty() && stackTrace != null && fromIndex >= 0 && stackTrace.length > fromIndex) {
            for (int i = fromIndex; i < stackTrace.length; ++i) {
                if (declaringClasses.contains(stackTrace[i].getClassName())) continue;
                idx = i;
                break;
            }
        }
        return idx;
    }
}

