/*
 * Decompiled with CFR 0.152.
 */
package rma.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public final class StdoutConsoleHandler
extends Handler {
    private final WriterWrapper _writerWrapper = new WriterWrapper();
    private boolean _doneHeader;

    public StdoutConsoleHandler() {
        this.configure();
    }

    private void configure() {
        String cname = this.getClass().getName();
        this.setLevel(this.getLevelProperty(cname + ".level", Level.INFO));
        this.setFilter(this.getFilterProperty(cname + ".filter", null));
        this.setFormatter(this.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(LogManager.getLogManager().getProperty(cname + ".encoding"));
        }
        catch (UnsupportedEncodingException | RuntimeException ex) {
            this.reportError("Unable to instantiate encoding property: " + cname + ".encoding defaulting to: null", ex, 0);
        }
    }

    private Level getLevelProperty(String name, Level defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        Level l = Level.parse(val.trim());
        return l != null ? l : defaultValue;
    }

    private Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            this.reportError("Unable to instantiate formatter property: " + name + " defaulting to: " + defaultValue, ex, 0);
        }
        return defaultValue;
    }

    private Filter getFilterProperty(String name, Filter defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            this.reportError("Unable to instantiate filter property: " + name + " defaulting to: " + defaultValue, ex, 0);
        }
        return defaultValue;
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        String msg;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            msg = this.getFormatter().format(logRecord);
        }
        catch (RuntimeException ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            Writer writer = this._writerWrapper.getWriter();
            if (!this._doneHeader) {
                writer.write(this.getFormatter().getHead(this));
                this._doneHeader = true;
            }
            writer.write(msg);
        }
        catch (IOException | RuntimeException ex) {
            this.reportError(null, ex, 1);
        }
        this.flush();
    }

    @Override
    public synchronized void close() {
        this.flush();
    }

    @Override
    public synchronized void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        this._writerWrapper.updateOutputStream();
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        if (logRecord == null) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    @Override
    public synchronized void flush() {
        this._writerWrapper.flush();
    }

    private final class WriterWrapper {
        private OutputStream _output;
        private volatile Writer _writer;

        private WriterWrapper() {
            this.updateOutputStream();
        }

        private void flushAndClose() throws SecurityException {
            if (this._writer != null) {
                try {
                    if (!StdoutConsoleHandler.this._doneHeader) {
                        this._writer.write(StdoutConsoleHandler.this.getFormatter().getHead(StdoutConsoleHandler.this));
                        StdoutConsoleHandler.this._doneHeader = true;
                    }
                    this._writer.write(StdoutConsoleHandler.this.getFormatter().getTail(StdoutConsoleHandler.this));
                    this._writer.flush();
                }
                catch (IOException | RuntimeException ex) {
                    StdoutConsoleHandler.this.reportError(null, ex, 3);
                }
                this._writer = null;
                this._output = null;
            }
        }

        private Writer getWriter() {
            if (this._output != System.out) {
                this.updateOutputStream();
            }
            return this._writer;
        }

        private void updateOutputStream() throws SecurityException {
            this.flushAndClose();
            this._output = System.out;
            StdoutConsoleHandler.this._doneHeader = false;
            String encoding = StdoutConsoleHandler.this.getEncoding();
            if (encoding == null) {
                this._writer = new OutputStreamWriter(this._output);
            } else {
                try {
                    this._writer = new OutputStreamWriter(this._output, encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalStateException("Unexpected exception " + ex);
                }
            }
        }

        private void flush() {
            if (this._writer != null) {
                try {
                    this._writer.flush();
                }
                catch (IOException | RuntimeException ex) {
                    StdoutConsoleHandler.this.reportError(null, ex, 2);
                }
            }
        }
    }
}

