/*
 * Decompiled with CFR 0.152.
 */
package rma.util.postscript;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public abstract class PSGrBase
extends Graphics2D {
    public static final boolean DEBUG = true;
    protected static final int PAGEHEIGHT = 792;
    protected static final int PAGEWIDTH = 612;
    protected static final int XOFFSET = 30;
    protected static final int YOFFSET = 30;
    int offsetX = 0;
    int offsetY = 0;
    Stroke _stroke = null;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final int charsPerRow = 72;
    protected PrintWriter os;
    protected Color clr = Color.black;
    protected Color backClr = Color.white;
    protected Font font = new Font("Helvetica", 0, 12);
    protected Rectangle clippingRect = new Rectangle(0, 0, 612, 792);

    public PSGrBase() {
        this(new OutputStreamWriter(System.out), true);
    }

    public PSGrBase(Writer w) {
        this(w, true);
    }

    public PSGrBase(Writer w, boolean emitProlog) {
        this.setOutput(w);
        if (emitProlog) {
            this.emitProlog();
        }
    }

    @Override
    public Graphics create() {
        throw new RuntimeException("create() not implemented");
    }

    public void setOutput(Writer w) {
        this.os = !(w instanceof PrintWriter) ? new PrintWriter(w, true) : (PrintWriter)w;
    }

    @Override
    public void translate(int x, int y) {
        this.os.print(x);
        this.os.print(" ");
        this.os.print(-y);
        this.os.println(" translate");
    }

    @Override
    public void scale(double x, double y) {
        this.os.print(x);
        this.os.print(" ");
        this.os.print(y);
        this.os.println(" scale");
    }

    protected void lineto(int x, int y) {
        this.os.print(x);
        this.os.print(" ");
        this.os.print(y);
        this.os.println(" lineto");
    }

    protected void moveto(int x, int y) {
        this.os.print(x);
        this.os.print(" ");
        this.os.print(y);
        this.os.println(" moveto");
    }

    @Override
    public Color getColor() {
        this.diagnostic("getColor()");
        return this.clr;
    }

    @Override
    public void setBackground(Color c2) {
        this.diagnostic("setBackground(" + c2 + ")");
        this.backClr = c2;
    }

    @Override
    public void setColor(Color c2) {
        this.diagnostic("setColor(" + c2 + ")");
        if (c2 != null) {
            this.clr = c2;
        }
        this.os.print((double)this.clr.getRed() / 255.0);
        this.os.print(" ");
        this.os.print((double)this.clr.getGreen() / 255.0);
        this.os.print(" ");
        this.os.print((double)this.clr.getBlue() / 255.0);
        this.os.println(" setrgbcolor");
    }

    @Override
    public void setPaintMode() {
        this.diagnostic("setPaintMode()");
    }

    @Override
    public void setXORMode(Color c1) {
        this.diagnostic("setXORMode(" + c1 + ")");
    }

    @Override
    public Font getFont() {
        this.diagnostic("getFont()");
        return this.font;
    }

    @Override
    public void setFont(Font f) {
        this.diagnostic("setFont(" + f + ")");
        if (f != null) {
            this.font = f;
            Object fontName = this.font.getName();
            int fontStyle = this.font.getStyle();
            if (((String)fontName).startsWith("Times")) {
                switch (fontStyle) {
                    case 0: {
                        fontName = "Times-Roman";
                        break;
                    }
                    case 1: {
                        fontName = "Times-Bold";
                        break;
                    }
                    case 2: {
                        fontName = "Times-Italic";
                        break;
                    }
                    case 3: {
                        fontName = (String)fontName + "Times-BoldItalic";
                    }
                }
            } else {
                switch (fontStyle) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        fontName = (String)fontName + "-Bold";
                        break;
                    }
                    case 2: {
                        fontName = (String)fontName + "-Oblique";
                        break;
                    }
                    case 3: {
                        fontName = (String)fontName + "-BoldOblique";
                    }
                }
            }
            this.os.println("/" + (String)fontName + " findfont");
            this.os.print(this.font.getSize());
            this.os.println(" scalefont setfont");
        }
    }

    @Override
    public FontMetrics getFontMetrics() {
        this.diagnostic("getFontMetrics()");
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        this.diagnostic("getFontMetrics(" + f + ")");
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    @Deprecated
    public Rectangle getClipRect() {
        this.diagnostic("getClipRect()");
        return this.clippingRect;
    }

    @Override
    public Shape getClip() {
        this.diagnostic("getClip()");
        return this.clippingRect;
    }

    @Override
    public void setClip(Shape s) {
        this.diagnostic("setClip(" + s + ")");
        Rectangle r = s.getBounds();
        this.setClip(r.x, r.y, r.width, r.height);
    }

    @Override
    public Rectangle getClipBounds() {
        this.diagnostic("getClipBounds()");
        return this.clippingRect;
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.diagnostic("setClip(" + x + ", " + y + ", " + width + ", " + height + ")");
        y = this.transformY(y);
        this.clippingRect = new Rectangle(x, y, width, height);
        this.os.println("initclip");
        this.moveto(x, y);
        this.lineto(x + width, y);
        this.lineto(x + width, y - height);
        this.lineto(x, y - height);
        this.os.println("closepath eoclip newpath");
    }

    @Override
    @Deprecated
    public void clipRect(int x, int y, int width, int height) {
        this.diagnostic("clipRect(" + x + ", " + y + ", " + width + ", " + height + ")");
        this.setClip(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.diagnostic("copyArea(" + x + ", " + y + ", " + width + ", " + height + ", " + dx + ", " + dy + ")");
        throw new RuntimeException("copyArea not supported");
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.diagnostic("drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ")");
        y1 = this.transformY(y1);
        y2 = this.transformY(y2);
        this.moveto(x1, y1);
        this.lineto(x2, y2);
        this.stroke(false);
    }

    protected void doRect(int x, int y, int width, int height, boolean fill) {
        this.diagnostic("doRect(" + x + ", " + y + ", " + width + ", " + height + ", " + fill + ")");
        y = this.transformY(y);
        this.moveto(x, y);
        this.lineto(x + width, y);
        this.lineto(x + width, y - height);
        this.lineto(x, y - height);
        this.lineto(x, y);
        this.stroke(fill);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.diagnostic("fillRect(" + x + ", " + y + ", " + width + ", " + height + ")");
        this.doRect(x, y, width, height, true);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.diagnostic("drawRect(" + x + ", " + y + ", " + width + ", " + height + ")");
        this.doRect(x, y, width, height, false);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.diagnostic("clearRect(" + x + ", " + y + ", " + width + ", " + height + ")");
        this.gsave();
        Color c2 = this.getColor();
        this.setColor(this.backClr);
        this.doRect(x, y, width, height, true);
        this.setColor(c2);
        this.grestore();
    }

    protected void doRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean fill) {
        this.diagnostic("doRoundRect(" + x + ", " + y + ", " + width + ", " + height + arcWidth + ", " + arcHeight + ", " + fill + ")");
        y = this.transformY(y);
        this.gsave();
        int arcDim = arcHeight / 2;
        this.translate(x, y);
        if (arcHeight != arcWidth) {
            if (arcHeight > arcWidth) {
                double ratio = (double)arcHeight / (double)arcWidth;
                this.scale(1.0, ratio);
                height = (int)((double)height / ratio);
                arcDim = arcWidth / 2;
            } else {
                double ratio = (double)arcWidth / (double)arcHeight;
                this.scale(ratio, 1.0);
                width = (int)((double)width / ratio);
                arcDim = arcHeight / 2;
            }
        }
        this.os.println("0 setlinewidth");
        this.moveto(arcDim, 0);
        this.arcTo(width, 0, width, -height, arcDim);
        this.arcTo(width, -height, 0, -height, arcDim);
        this.arcTo(0, -height, 0, 0, arcDim);
        this.arcTo(0, 0, width, 0, arcDim);
        this.stroke(fill);
        this.os.println("1 setlinewidth");
        this.grestore();
    }

    protected void stroke(boolean fill) {
        if (fill) {
            this.gsave();
            this.os.println("eofill");
            this.grestore();
        }
        this.os.println("stroke");
    }

    protected void arcTo(int x1, int y1, int x2, int y2, int dim) {
        this.os.print(x1);
        this.os.print(" ");
        this.os.print(y1);
        this.os.print(" ");
        this.os.print(x2);
        this.os.print(" ");
        this.os.print(y2);
        this.os.print(" ");
        this.os.print(dim);
        this.os.println(" arcto");
        this.os.println("4 {pop} repeat");
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.diagnostic("drawRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ")");
        this.doRoundRect(x, y, width, height, arcWidth, arcHeight, false);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.diagnostic("fillRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ")");
        this.doRoundRect(x, y, width, height, arcWidth, arcHeight, true);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.diagnostic("draw3DRect(" + x + ", " + y + ", " + width + ", " + height + ", " + raised + ")");
        Color c2 = this.getColor();
        Color brighter = c2.brighter();
        Color darker = c2.darker();
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x, y + height);
        this.drawLine(x + 1, y, x + width - 1, y);
        this.setColor(raised ? darker : brighter);
        this.drawLine(x + 1, y + height, x + width, y + height);
        this.drawLine(x + width, y, x + width, y + height);
        this.setColor(c2);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.diagnostic("fill3DRect(" + x + ", " + y + ", " + width + ", " + height + ", " + raised + ")");
        Color c2 = this.getColor();
        Color brighter = c2.brighter();
        Color darker = c2.darker();
        if (!raised) {
            this.setColor(darker);
        }
        this.fillRect(x + 1, y + 1, width - 2, height - 2);
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x, y + height - 1);
        this.drawLine(x + 1, y, x + width - 2, y);
        this.setColor(raised ? darker : brighter);
        this.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        this.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        this.setColor(c2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.diagnostic("drawOval(" + x + ", " + y + ", " + width + ", " + height + ")");
        this.doArc(x, y, width, height, 0, 360, false);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.diagnostic("fillOval(" + x + ", " + y + ", " + width + ", " + height + ")");
        this.doArc(x, y, width, height, 0, 360, true);
    }

    protected void doArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
        this.diagnostic("doArc(" + x + ", " + y + ", " + width + ", " + height + startAngle + ", " + arcAngle + ", " + fill + ")");
        y = this.transformY(y);
        this.gsave();
        int cx = x + width / 2;
        int cy = y - height / 2;
        this.translate(cx, cy);
        float yscale = (float)height / (float)width;
        this.scale(1.0, yscale);
        if (fill) {
            this.moveto(0, 0);
        }
        this.os.println("0 setlinewidth");
        float endAngle = startAngle + arcAngle;
        this.os.print("0 0 ");
        this.os.print((double)width / 2.0);
        this.os.print(" ");
        this.os.print(startAngle);
        this.os.print(" ");
        this.os.print(endAngle);
        this.os.println(" arc");
        if (fill) {
            this.os.println("closepath");
        }
        this.stroke(fill);
        this.os.println("1 setlinewidth");
        this.grestore();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.diagnostic("drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ")");
        this.doArc(x, y, width, height, startAngle, arcAngle, false);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.diagnostic("fillArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ")");
        this.doArc(x, y, width, height, startAngle, arcAngle, true);
    }

    protected void doPoly(int[] xPoints, int[] yPoints, int nPoints, boolean fill, boolean close) {
        int i;
        this.diagnostic("doPoly(" + xPoints.length + ", " + yPoints.length + ", " + nPoints + ", " + fill + ", " + close + ")");
        if (nPoints < 2) {
            return;
        }
        int[] newYPoints = new int[nPoints];
        for (i = 0; i < nPoints; ++i) {
            newYPoints[i] = this.transformY(yPoints[i]);
        }
        this.moveto(xPoints[0], newYPoints[0]);
        for (i = 0; i < nPoints; ++i) {
            this.lineto(xPoints[i], newYPoints[i]);
        }
        this.stroke(fill);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.diagnostic("drawPolyline(" + xPoints.length + ", " + yPoints.length + ", " + nPoints + ")");
        this.doPoly(xPoints, yPoints, nPoints, false, false);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.diagnostic("drawPolygon(" + xPoints.length + ", " + yPoints.length + ", " + nPoints + ")");
        this.doPoly(xPoints, yPoints, nPoints, false, true);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.diagnostic("drawPolygon(" + p + ")");
        this.doPoly(p.xpoints, p.ypoints, p.npoints, false, true);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.diagnostic("fillPolygon(" + xPoints.length + ", " + yPoints.length + ", " + nPoints + ")");
        this.doPoly(xPoints, yPoints, nPoints, true, true);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.diagnostic("fillPolygon(" + p + ")");
        this.doPoly(p.xpoints, p.ypoints, p.npoints, true, true);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.diagnostic("drawString(" + str + ", " + x + ", " + y + ")");
        y = this.transformY(y);
        this.moveto(x, y);
        this.os.print(" (");
        this.os.print(str);
        this.os.println(") show stroke");
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.diagnostic("drawChars(" + data.length + ", " + offset + ", " + length + ", " + x + ", " + y + ")");
        this.drawString(new String(data, offset, length), x, y);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.diagnostic("drawBytes(" + data.length + ", " + offset + ", " + length + ", " + x + ", " + y + ")");
        this.drawString(new String(data, offset, length), x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doImage(Image img, int x, int y, int width, int height, int sx, int sy, int sw, int sh, ImageObserver observer, Color bgcolor) {
        this.diagnostic("doImage(" + img + ", " + x + ", " + y + ", " + width + ", " + height + ", " + sx + ", " + sy + ", " + sw + ", " + sh + ", " + observer + ", " + bgcolor + ")");
        int imgWidth = img.getWidth(observer);
        int imgHeight = img.getHeight(observer);
        y = this.transformY(y);
        int[] pix = new int[imgWidth * imgHeight];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, imgWidth, imgHeight, pix, 0, imgWidth);
        boolean result = false;
        try {
            result = pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            if (!result) {
                this.os.println("%warning: error on image grab");
                System.err.println("warning: error on image grab: " + pg.getStatus());
                return false;
            }
        }
        finally {
            if (!result) {
                this.os.println("%warning: error on image grab");
                System.err.println("warning: error on image grab: " + pg.getStatus());
                return false;
            }
        }
        if (height < 1 || width < 1) {
            height = imgHeight;
            width = imgWidth;
        }
        int iLower = sy == 0 ? 0 : sx;
        int iUpper = sh == 0 ? imgHeight : sy + sh;
        int jLower = sx == 0 ? 0 : sx;
        int jUpper = sw == 0 ? imgWidth : sx + sw;
        int numYPixels = iUpper - iLower;
        int numXPixels = jUpper - jLower;
        this.gsave();
        this.os.println("% build a temporary dictionary");
        this.os.println("20 dict begin");
        this.emitColorImageProlog(numXPixels);
        this.os.println("% lower left corner");
        this.translate(x, y);
        this.os.println("% size of image");
        this.scale(width, height);
        this.os.print(numXPixels);
        this.os.print(" ");
        this.os.print(numYPixels);
        this.os.println(" 8");
        this.os.print("[");
        this.os.print(numXPixels);
        this.os.print(" 0 0 -");
        this.os.print(numYPixels);
        this.os.print(" 0 ");
        this.os.print(0);
        this.os.println("]");
        this.os.println("{currentfile pix readhexstring pop}");
        this.os.println("false 3 colorimage");
        this.os.println("");
        int sleepyet = 0;
        char[] sb = new char[73];
        int bg = bgcolor == null ? -1 : bgcolor.getRGB();
        for (int i = iLower; i < iUpper; ++i) {
            int offset = 0;
            ++sleepyet;
            for (int j = jLower; j < jUpper; ++j) {
                int coord = i * imgWidth + j;
                int n = pix[coord];
                int alpha = n & 0xFF000000;
                if (alpha == 0) {
                    n = bg;
                }
                sb[offset++] = hd[(n & 0xF00000) >> 20];
                sb[offset++] = hd[(n & 0xF0000) >> 16];
                sb[offset++] = hd[(n & 0xF000) >> 12];
                sb[offset++] = hd[(n & 0xF00) >> 8];
                sb[offset++] = hd[(n & 0xF0) >> 4];
                sb[offset++] = hd[n & 0xF];
                if (offset < 72) continue;
                this.os.write(sb, 0, offset);
                this.os.println();
                if (sleepyet > 5) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    sleepyet = 0;
                }
                offset = 0;
            }
            if (offset == 0) continue;
            this.os.write(sb, 0, offset);
            this.os.println();
        }
        this.os.println();
        this.os.println("end");
        this.grestore();
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.diagnostic("drawImage(" + img + ", " + x + ", " + y + ", " + observer + ")");
        return this.doImage(img, x, y, 0, 0, 0, 0, 0, 0, observer, null);
    }

    @Override
    public boolean drawImage(Image img, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, ImageObserver observer) {
        this.diagnostic("drawImage(" + img + ", " + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ", " + x3 + ", " + y3 + ", " + x4 + ", " + y4 + ", " + observer + ")");
        return this.doImage(img, x1, y1, x2 - x1, y2 - y1, x3, y3, x4 - x3, y4 - y3, observer, null);
    }

    @Override
    public boolean drawImage(Image img, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, Color c2, ImageObserver observer) {
        this.diagnostic("drawImage(" + img + ", " + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ", " + x3 + ", " + y3 + ", " + x4 + ", " + y4 + ", " + c2 + ", " + observer + ")");
        return this.doImage(img, x1, y1, x2 - x1, y2 - y1, x3, y3, x4 - x3, y4 - y3, observer, c2);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.diagnostic("drawImage(" + img + "," + x + ", " + y + ", " + width + ", " + height + ", " + observer + ")");
        return this.doImage(img, x, y, width, height, 0, 0, 0, 0, observer, null);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.diagnostic("drawImage(" + img + ", " + x + ", " + y + ", " + bgcolor + ", " + observer + ")");
        return this.doImage(img, x, y, 0, 0, 0, 0, 0, 0, observer, bgcolor);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.diagnostic("drawImage(" + img + ", " + x + ", " + y + ", " + width + ", " + height + ", " + bgcolor + ", " + observer + ")");
        return this.doImage(img, x, y, width, height, 0, 0, 0, 0, observer, bgcolor);
    }

    @Override
    public void dispose() {
        this.diagnostic("dispose() ");
        this.os.flush();
    }

    @Override
    public void finalize() {
        this.diagnostic("finalize() ");
        super.finalize();
    }

    @Override
    public String toString() {
        this.diagnostic("toString() ");
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    protected int transformY(int y) {
        return 792 - y;
    }

    protected void emitProlog() {
        this.os.println("%!PS-Adobe-2.0 EPSF-1.2 Created by PSGr Java PostScript Context");
        this.os.println("% PSGr is (C) 1996 Ernest Friedman-Hill and Sandia National Labs");
        this.os.println("% Right to unrestricted personal and commerical use is granted");
        this.os.println("% if this acknowledgement is given on product or packing materials");
        this.os.println("% PSGr is being adapted to handle Java's Graphics2D capabilities, ");
        this.os.println("% Shannon Newbold, Resource Management Associates October 2000.");
        this.translate(30, -30);
        this.setFont(this.font);
    }

    protected void emitColorImageProlog(int xdim) {
        this.os.println("% Color picture stuff, lifted from XV's PS files");
        this.os.println("% define string to hold a scanline's worth of data");
        this.os.print("/pix ");
        this.os.print(xdim * 3);
        this.os.println(" string def");
        this.os.println("% define space for color conversions");
        this.os.print("/grays ");
        this.os.print(xdim);
        this.os.println(" string def  % space for gray scale line");
        this.os.println("/npixls 0 def");
        this.os.println("/rgbindx 0 def");
        this.os.println("% define 'colorimage' if it isn't defined");
        this.os.println("%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.os.println("%     via xgrab)");
        this.os.println("/colorimage where   % do we know about 'colorimage'?");
        this.os.println("{ pop }           % yes: pop off the 'dict' returned");
        this.os.println("{                 % no:  define one");
        this.os.println("/colortogray {  % define an RGB->I function");
        this.os.println("/rgbdata exch store    % call input 'rgbdata'");
        this.os.println("rgbdata length 3 idiv");
        this.os.println("/npixls exch store");
        this.os.println("/rgbindx 0 store");
        this.os.println("0 1 npixls 1 sub {");
        this.os.println("grays exch");
        this.os.println("rgbdata rgbindx       get 20 mul    % Red");
        this.os.println("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.os.println("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.os.println("add add 64 idiv      % I = .5G + .31R + .18B");
        this.os.println("put");
        this.os.println("/rgbindx rgbindx 3 add store");
        this.os.println("} for");
        this.os.println("grays 0 npixls getinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("% Utility procedure for colorimage operator.");
        this.os.println("% This procedure takes two procedures off the");
        this.os.println("% stack and merges them into a single procedure.");
        this.os.println("");
        this.os.println("/mergeprocs { % def");
        this.os.println("dup length");
        this.os.println("3 -1 roll");
        this.os.println("dup");
        this.os.println("length");
        this.os.println("dup");
        this.os.println("5 1 roll");
        this.os.println("3 -1 roll");
        this.os.println("add");
        this.os.println("array cvx");
        this.os.println("dup");
        this.os.println("3 -1 roll");
        this.os.println("0 exch");
        this.os.println("putinterval");
        this.os.println("dup");
        this.os.println("4 2 roll");
        this.os.println("putinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("/colorimage { % def");
        this.os.println("pop pop     % remove 'false 3' operands");
        this.os.println("{colortogray} mergeprocs");
        this.os.println("image");
        this.os.println("} bind def");
        this.os.println("} ifelse          % end of 'false' case");
    }

    public void gsave() {
        this.os.println("gsave");
    }

    public void grestore() {
        this.os.println("grestore");
    }

    public void emitThis(String s) {
        this.os.println(s);
    }

    protected void diagnostic(String s) {
        this.os.print("% PSGR-");
        this.os.print(this.hashCode());
        this.os.print(": ");
        this.os.println(s);
    }

    protected void setdash(float[] dashstyle, float dashphase) {
        StringBuffer strBuf = new StringBuffer("[");
        for (int i = 0; dashstyle != null && i < dashstyle.length; ++i) {
            strBuf.append(Float.toString(dashstyle[i]) + " ");
        }
        strBuf.append(']');
        strBuf.append(" " + Float.toString(dashphase) + " setdash");
        this.os.println(strBuf.toString());
    }

    @Override
    public void rotate(double theta) {
        throw new RuntimeException("rotate(double theta) Not a Supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void rotate(double theta, double x, double y) {
        throw new RuntimeException("rotate(double theta, double x, double y) Not a Supported Graphics2D Method in PSGrBase");
    }

    @Override
    public Composite getComposite() {
        throw new RuntimeException("getComposite() Not a Supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.drawString(s, (int)x, (int)y);
    }

    @Override
    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        throw new RuntimeException("drawRenderableImage(RenderableImage, AffinTransform) Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        throw new RuntimeException("rawRenderableImage(java.awt.image.RenderedImage img, java.awt.geom.AffineTransform xform) Not a Supported Graphics2D Method in PSGrBase");
    }

    public void addRenderingHints(Map map) {
        throw new RuntimeException("addRenderingHints(Map) Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        throw new RuntimeException("getRenderingHing(java.awt.RenderingHint.Key key) Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public RenderingHints getRenderingHints() {
        throw new RuntimeException("getRenderingHints()  Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void setRenderingHint(RenderingHints.Key kintKey, Object hintValue) {
        throw new RuntimeException("setRenderingHint(java.awt.RenderingHints.Ket kintKey, Object hintValue) Not a Supporte Graphics2D Method in PSGrBase");
    }

    public void setRenderingHints(Map hints) {
        throw new RuntimeException("setRenderingHint(Map hints) Not a Supporte Graphics2D Method in PSGrBase");
    }

    @Override
    public Paint getPaint() {
        throw new RuntimeException("getPaint() Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public boolean hit(Rectangle r, Shape s, boolean b) {
        throw new RuntimeException("hit(java.awt.Rectangle r, java.awt.Shape s, boolean b) Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void drawGlyphVector(GlyphVector vec, float x, float y) {
        throw new RuntimeException("drawGlyphVector(java.awt.font.GlyphVector vec, float x, float y) Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void setComposite(Composite c2) {
        throw new RuntimeException("setComposite(java.awt.Composite c) Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void draw(Shape s) {
        throw new RuntimeException("draw(java.awt.Shape s) Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        throw new RuntimeException("drawImage(BufferedImage, BufferedImageOp, int, int) Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public boolean drawImage(Image image, AffineTransform xform, ImageObserver observer) {
        throw new RuntimeException("drawImage(Image, AffineTransform, ImageObserver) Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void shear(double shx, double shy) {
        throw new RuntimeException("shear(double shx, double shy)  Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void clip(Shape s) {
        throw new RuntimeException("clip(java.awt.Shape s)  Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void fill(Shape s) {
        throw new RuntimeException("fill(java.awt.Shape s)  Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void transform(AffineTransform xform) {
        throw new RuntimeException("transform(java.awt.geom.AffinTransform xform)  Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        throw new RuntimeException("drawString(java.text.AttributedCharacterIterator, float, float) Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public AffineTransform getTransform() {
        throw new RuntimeException("getTransform() Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public void setTransform(AffineTransform xform) {
        throw new RuntimeException("setTransform(AffineTransform) Not a supported Graphics2D method in PSGrBase");
    }

    @Override
    public Color getBackground() {
        throw new RuntimeException("getBackground() Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        throw new RuntimeException("getDeviceConfiguration() Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        throw new RuntimeException("getFontRenderContext()  Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void setPaint(Paint paint) {
        throw new RuntimeException("setPaint(Paint) Not a supported Graphics2D Method in PSGrBase");
    }

    @Override
    public void translate(double x, double y) {
        this.translate((int)x, (int)y);
    }

    @Override
    public Stroke getStroke() {
        return this._stroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("null Stroke");
        }
        if (stroke instanceof BasicStroke) {
            this._stroke = stroke;
            BasicStroke bstroke = (BasicStroke)stroke;
            float lineWidth = bstroke.getLineWidth();
            float[] linePattern = bstroke.getDashArray();
            float dashphase = bstroke.getDashPhase();
            int linecap = bstroke.getEndCap();
            float miterlimit = bstroke.getMiterLimit();
            int linejoin = bstroke.getLineJoin();
            this.os.println(Integer.toString(linecap) + " setlinecap");
            this.os.println(Integer.toString(linejoin) + " setlinejoin");
            this.os.println(Float.toString(lineWidth) + " setlinewidth");
            this.setdash(linePattern, dashphase);
            return;
        }
        throw new IllegalArgumentException("Unrecognized Stroke int PSGrBase.setStroke().");
    }
}

