/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class rmaTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retTokens;

    public rmaTokenizer(String str, String delim, boolean returnTokens) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retTokens = returnTokens;
    }

    public rmaTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public rmaTokenizer(String str) {
        this(str, " \t\n\r", false);
    }

    private void skipDelimiters() {
        while (!this.retTokens && this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) >= 0) {
            ++this.currentPosition;
        }
    }

    public boolean hasMoreTokens() {
        this.skipDelimiters();
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() {
        this.skipDelimiters();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        while (this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) < 0) {
            ++this.currentPosition;
        }
        if (this.retTokens && start == this.currentPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) >= 0) {
            ++this.currentPosition;
        }
        return this.str.substring(start, this.currentPosition);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition) {
            while (!this.retTokens && currpos < this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) >= 0) {
                ++currpos;
            }
            if (currpos >= this.maxPosition) break;
            int start = currpos;
            while (currpos < this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) < 0) {
                ++currpos;
            }
            if (this.retTokens && start == currpos && this.delimiters.indexOf(this.str.charAt(currpos)) >= 0) {
                ++currpos;
            }
            ++count;
        }
        return count;
    }

    public String getElement(int element) {
        String str = new String();
        if (element < this.countTokens()) {
            return null;
        }
        for (int i = 0; i < element; ++i) {
            str = this.nextToken();
        }
        this.currentPosition = 0;
        return str;
    }
}

