/*
 * Decompiled with CFR 0.152.
 */
package rma.util.wmf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.swing.RmaTexturePaint;
import rma.util.wmf.WMF;
import rma.util.wmf.WMFGraphics;

public class WMFGraphics2D
extends Graphics2D {
    private static final Logger LOGGER = Logger.getLogger(WMFGraphics2D.class.getName());
    BufferedImage img;
    WMFGraphics wmfg;
    Graphics2D g2D;
    AffineTransform trans;
    Stroke stroke;
    Paint paint;
    Color color;
    Shape clip;
    boolean gdifontdrawing = true;
    boolean gdipendrawing = true;
    boolean gdipenwidthdrawing = true;
    double flatness = 0.1;
    int scaling = 1;
    Shape deviceclip = null;

    public WMFGraphics2D(WMF wmf, int width, int height) {
        this(wmf, width, height, Color.black, Color.white);
    }

    public WMFGraphics2D(WMF wmf, int width, int height, Color foreground, Color background) {
        if (foreground == null) {
            foreground = Color.black;
        }
        if (background == null) {
            background = Color.white;
        }
        this.wmfg = new WMFGraphics(wmf, width, height, foreground, background);
        this.img = new BufferedImage(1, 1, 2);
        this.g2D = (Graphics2D)this.img.getGraphics();
        this.trans = new AffineTransform();
        this.stroke = this.g2D.getStroke();
        this.paint = foreground;
        this.color = foreground;
        this.clip = null;
    }

    protected WMFGraphics2D(WMFGraphics2D g) {
        this.wmfg = (WMFGraphics)g.wmfg.create();
        this.trans = (AffineTransform)g.trans.clone();
        this.stroke = g.stroke;
        this.paint = g.paint;
        this.color = g.color;
        this.clip = g.clip;
        this.img = new BufferedImage(g.img.getWidth(), g.img.getHeight(), 2);
        this.flatness = this.flatness;
        this.gdifontdrawing = this.gdifontdrawing;
        this.gdipendrawing = this.gdipendrawing;
        this.gdipenwidthdrawing = this.gdipenwidthdrawing;
        this.scaling = this.scaling;
        this.deviceclip = g.deviceclip;
        this.g2D = (Graphics2D)g.img.getGraphics();
    }

    public void setGDIFontDrawing(boolean gdifontdrawing) {
        this.gdifontdrawing = gdifontdrawing;
    }

    public boolean isGDIFontDrawing() {
        return this.gdifontdrawing;
    }

    public void setGDIPenDrawing(boolean gdipendrawing) {
        this.gdipendrawing = gdipendrawing;
    }

    public boolean isGDIPenDrawing() {
        return this.gdipendrawing;
    }

    public void setGDIPenWidthDrawing(boolean gdipenwidthdrawing) {
        this.gdipenwidthdrawing = gdipenwidthdrawing;
    }

    public boolean isGDIPenWidthDrawing() {
        return this.gdipenwidthdrawing;
    }

    public void setFlatness(double flatness) {
        this.flatness = flatness;
    }

    public double getFlatness() {
        return this.flatness;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g2D.getRenderingHints();
    }

    @Override
    public Graphics create() {
        WMFGraphics2D g = new WMFGraphics2D(this);
        return g;
    }

    @Override
    public Font getFont() {
        return this.wmfg.getFont();
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void clip(Shape s) {
        if (this.clip != null) {
            Area area = new Area(this.clip);
            if (s != null) {
                area.intersect(new Area(s));
            }
            s = area;
        }
        this.setClip(s);
    }

    @Override
    public void setPaintMode() {
        this.wmfg.setPaintMode();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.g2D.setTransform(this.trans);
        this.g2D.setStroke(this.getStroke());
        this.g2D.setClip(this.getClip());
        return this.g2D.hit(rect, s, onStroke);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        Shape s = this.trans.createTransformedShape(bounds);
        Rectangle r = s.getBounds();
        try {
            Image transedimg = this.transformImage(img, bounds, r, observer, bgcolor);
            this.wmfg.setClip(null);
            this.wmfg.drawImage(transedimg, r.x, r.y, r.width, r.height, observer);
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.FINE, "Failed to draw image: ", ex);
        }
        return true;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        this.g2D.setTransform(this.trans);
        return this.g2D.getFontRenderContext();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2D.getDeviceConfiguration();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Composite getComposite() {
        return this.g2D.getComposite();
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage bimg = new BufferedImage(img.getColorModel(), img.getData().createCompatibleWritableRaster(), false, null);
        bimg.setData(img.getData());
        this.drawImage(bimg, xform, null);
    }

    @Override
    public void setClip(Shape clip) {
        this.clip = clip;
        this.deviceclip = this.trans.createTransformedShape(clip);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.trans = (AffineTransform)Tx.clone();
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void setBackground(Color color) {
        this.wmfg.background = color;
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void fillPolygon(int[] xpoints, int[] ypoints, int npoints) {
        this.fill(new Polygon(xpoints, ypoints, npoints));
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object hintValue) {
        this.g2D.setRenderingHint(key, hintValue);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int[] p = new int[]{dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2};
        Rectangle bounds = new Line2D.Float(dx1, dy1, dx2, dy2).getBounds();
        Shape s = this.trans.createTransformedShape(bounds);
        Rectangle r = s.getBounds();
        try {
            Image transedimg = this.transformImage(img, p, r, observer, bgcolor);
            this.wmfg.setClip(null);
            this.wmfg.drawImage(transedimg, r.x, r.y, r.width, r.height, observer);
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.FINE, "Failed to draw image: ", ex);
        }
        return true;
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void setFont(Font font) {
        this.wmfg.setFont(font);
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (paint instanceof Color) {
                this.color = (Color)paint;
            }
        }
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g2D.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    @Override
    public void drawPolygon(int[] xpoints, int[] ypoints, int npoints) {
        this.draw(new Polygon(xpoints, ypoints, npoints));
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawPolyline(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > 0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(xpoints[0], ypoints[0]);
            for (int i = 1; i < npoints; ++i) {
                path.lineTo(xpoints[i], ypoints[i]);
            }
            this.draw(path);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new GeneralPath(new Line2D.Float(x1, y1, x2, y2)));
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        this.draw(rect);
    }

    @Override
    public void dispose() {
        this.wmfg.dispose();
        this.g2D.dispose();
        this.img.flush();
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.trans.rotate(theta, x, y);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.trans.concatenate(Tx);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint oldpaint = this.paint;
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(oldpaint);
    }

    @Override
    public void setColor(Color c2) {
        this.setPaint(c2);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g2D.getRenderingHint(key);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    public void setRenderingHints(Map hints) {
        this.g2D.setRenderingHints(hints);
    }

    @Override
    public void translate(int x, int y) {
        this.wmfg.translate(x, y);
    }

    @Override
    public void setXORMode(Color color) {
        this.wmfg.setXORMode(color);
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip != null) {
            return this.clip.getBounds();
        }
        return null;
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        Paint oldpaint = this.getPaint();
        this.setColor(this.getColor());
        this.fill(layout.getOutline(AffineTransform.getTranslateInstance(x, y)));
        this.setPaint(this.paint);
    }

    public void addRenderingHints(Map hints) {
        this.g2D.addRenderingHints(hints);
    }

    @Override
    public Color getBackground() {
        return this.wmfg.background;
    }

    @Override
    public void translate(double tx, double ty) {
        this.trans.translate(tx, ty);
    }

    @Override
    public void fill(Shape s) {
        this.doFilling(s, false);
    }

    void doFilling(Shape s, boolean draw) {
        int oldHatch = this.wmfg.getBrushHatch();
        int oldFillStyle = this.wmfg.getBrushFillStyle();
        this.wmfg.setClip(null);
        Area clipped = new Area(s);
        if (this.getClip() != null) {
            clipped.intersect(new Area(this.getClip()));
        }
        if (!(this.getPaint() instanceof Color)) {
            if (this.paint instanceof RmaTexturePaint) {
                if (((RmaTexturePaint)this.paint).getFillType() != 0) {
                    this.wmfg.setBrushFillStyle(2);
                    this.wmfg.setBrushHatch(((RmaTexturePaint)this.paint).getFillType() - 1);
                } else {
                    this.wmfg.setBrushFillStyle(0);
                }
            } else {
                Rectangle devicebounds = this.trans.createTransformedShape(clipped).getBounds();
                PaintContext pc = this.paint.createContext(this.img.getColorModel(), devicebounds, clipped.getBounds(), this.trans, this.getRenderingHints());
                Raster r = pc.getRaster(devicebounds.x, devicebounds.y, devicebounds.width, devicebounds.height);
                BufferedImage bimg = new BufferedImage(pc.getColorModel(), r.createCompatibleWritableRaster(), false, null);
                bimg.setData(r);
                BufferedImage pattern = new BufferedImage(devicebounds.width, devicebounds.height, 2);
                Graphics2D g = (Graphics2D)pattern.getGraphics();
                g.addRenderingHints(this.getRenderingHints());
                g.setTransform(AffineTransform.getTranslateInstance(-devicebounds.x, -devicebounds.y));
                g.setClip(this.trans.createTransformedShape(clipped));
                g.drawImage((Image)bimg, devicebounds.x, devicebounds.y, null);
                this.wmfg.drawImage(pattern, devicebounds.x, devicebounds.y, devicebounds.width, devicebounds.height, null);
                return;
            }
        }
        AffineTransform trans1 = (AffineTransform)this.trans.clone();
        this.wmfg.wmf.scaleWindowExt(this.scaling, 1, this.scaling, 1);
        trans1.preConcatenate(AffineTransform.getScaleInstance(this.scaling, this.scaling));
        PathIterator path = clipped.getPathIterator(trans1, this.flatness);
        if (path.getWindingRule() == 0) {
            this.wmfg.wmf.setPolyFillMode(1);
        } else {
            this.wmfg.wmf.setPolyFillMode(2);
        }
        int penstyle = this.wmfg.getPenStyle();
        this.wmfg.setPenStyle(5);
        this.wmfg.setColor(this.getColor());
        float[] p = new float[6];
        Vector<Polygon> polys = new Vector<Polygon>();
        Polygon poly = null;
        while (!path.isDone()) {
            int style = path.currentSegment(p);
            switch (style) {
                case 0: {
                    if (poly != null) {
                        polys.add(poly);
                    }
                    poly = new Polygon();
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    break;
                }
                case 3: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[2] + 0.5), (int)((double)p[3] + 0.5));
                    break;
                }
                case 2: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[4] + 0.5), (int)((double)p[5] + 0.5));
                    break;
                }
                case 1: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    break;
                }
                case 4: {
                    if (poly == null) break;
                    polys.add(poly);
                    poly = null;
                }
            }
            path.next();
        }
        if (poly != null) {
            polys.add(poly);
        }
        Polygon[] polyarray = new Polygon[polys.size()];
        int i = 0;
        Iterator it = polys.iterator();
        while (it.hasNext()) {
            polyarray[i] = (Polygon)it.next();
            ++i;
        }
        boolean nopolypoly = false;
        if (s instanceof Arc2D) {
            nopolypoly = true;
        }
        if (!nopolypoly) {
            this.wmfg.GDIPolyPolygon(polyarray);
        } else {
            for (i = 0; i < polyarray.length; ++i) {
                this.wmfg.fillPolygon(polyarray[i]);
            }
        }
        this.wmfg.wmf.scaleWindowExt(1, this.scaling, 1, this.scaling);
        this.wmfg.setPenStyle(penstyle);
        this.wmfg.setBrushFillStyle(oldFillStyle);
        this.wmfg.setBrushHatch(oldHatch);
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    @Override
    public void setComposite(Composite comp) {
        this.g2D.setComposite(comp);
    }

    @Override
    public void scale(double sx, double sy) {
        this.trans.scale(sx, sy);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.wmfg.getFontMetrics(f);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform oldtrans = (AffineTransform)this.trans.clone();
        this.trans.concatenate(xform);
        this.drawImage(img, 0, 0, obs);
        this.trans = oldtrans;
        return true;
    }

    @Override
    public void rotate(double theta) {
        this.trans.rotate(theta);
    }

    @Override
    public void draw(Shape s) {
        boolean fill = true;
        if (this.gdipendrawing && this.getPaint() instanceof Color && this.stroke instanceof BasicStroke && (((BasicStroke)this.stroke).getDashArray() == null || ((BasicStroke)this.stroke).getDashArray().length == 0)) {
            fill = this.doDrawing(s, (int)((BasicStroke)this.stroke).getLineWidth());
        }
        if (fill) {
            s = this.stroke.createStrokedShape(s);
            this.doFilling(s, true);
        }
    }

    boolean doDrawing(Shape s, int linewidth) {
        Area clipped;
        boolean result = false;
        if (this.getClip() != null && !(clipped = new Area(this.getClip())).contains(s.getBounds())) {
            Area shape = new Area(s);
            result = shape.isEmpty();
            clipped.intersect(shape);
            s = clipped;
        }
        AffineTransform trans1 = (AffineTransform)this.trans.clone();
        PathIterator path = s.getPathIterator(trans1, this.flatness);
        float[] p = new float[6];
        Vector<Polygon> polys = new Vector<Polygon>();
        Polygon poly = null;
        float[] startp = new float[6];
        while (!path.isDone()) {
            int style = path.currentSegment(p);
            switch (style) {
                case 0: {
                    if (poly != null) {
                        polys.add(poly);
                    }
                    poly = new Polygon();
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    System.arraycopy(p, 0, startp, 0, p.length);
                    break;
                }
                case 3: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[2] + 0.5), (int)((double)p[3] + 0.5));
                    break;
                }
                case 2: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[4] + 0.5), (int)((double)p[5] + 0.5));
                    break;
                }
                case 1: {
                    if (poly == null) break;
                    poly.addPoint((int)((double)p[0] + 0.5), (int)((double)p[1] + 0.5));
                    break;
                }
                case 4: {
                    if (poly == null) break;
                    poly.addPoint((int)startp[0], (int)startp[1]);
                    polys.add(poly);
                    poly = null;
                }
            }
            path.next();
        }
        if (poly != null) {
            polys.add(poly);
        }
        Polygon[] polyarray = new Polygon[polys.size()];
        int i = 0;
        Iterator it = polys.iterator();
        while (it.hasNext()) {
            polyarray[i] = (Polygon)it.next();
            ++i;
        }
        int penstyle = this.wmfg.getPenStyle();
        int brush = this.wmfg.getBrushFillStyle();
        this.wmfg.setClip(null);
        this.wmfg.setColor(this.getColor());
        this.wmfg.setPenStyle(0);
        if (this.gdipenwidthdrawing) {
            this.wmfg.setPenWidth(linewidth);
        } else {
            this.wmfg.setPenWidth(0);
        }
        this.wmfg.setGDIHollowBrush();
        for (i = 0; i < polyarray.length; ++i) {
            this.wmfg.drawPolyline(polyarray[i].xpoints, polyarray[i].ypoints, polyarray[i].npoints);
        }
        this.wmfg.setBrushFillStyle(brush);
        this.wmfg.setPenStyle(penstyle);
        return result;
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (this.trans.isIdentity() && this.isGDIFontDrawing() && this.getClip() == null && this.getPaint() instanceof Color && this.getFont().getTransform().isIdentity()) {
            this.wmfg.setColor(this.getColor());
            this.wmfg.drawString(s, (int)x, (int)y);
        } else {
            if (this.isGDIFontDrawing() && this.getPaint() instanceof Color) {
                boolean bool;
                boolean bl = bool = this.deviceclip == null;
                if (!bool) {
                    GlyphVector glyphvector = this.getFont().createGlyphVector(this.getFontRenderContext(), s);
                    Rectangle2D rectangle2d = glyphvector.getOutline(x, y).getBounds2D();
                    bool = this.deviceclip.contains(this.trans.createTransformedShape(rectangle2d).getBounds2D());
                }
                if (bool) {
                    boolean bool_80_;
                    boolean bool_78_ = this.trans.isIdentity() && this.getFont().getTransform().isIdentity();
                    double d = 1.0;
                    double d_79_ = 0.0;
                    if (!bool_78_) {
                        AffineTransform affinetransform = this.getFont().getTransform();
                        affinetransform.preConcatenate(this.trans);
                        d = affinetransform.getScaleX();
                        boolean bl2 = bool_78_ = affinetransform.getShearX() == -affinetransform.getShearY() && affinetransform.getScaleX() == affinetransform.getScaleY();
                        if (bool_78_ && (affinetransform.getShearX() != 0.0 || affinetransform.getScaleX() < 0.0)) {
                            d = Math.sqrt(affinetransform.getScaleX() * affinetransform.getScaleX() + affinetransform.getShearX() * affinetransform.getShearX());
                            d_79_ = Math.acos(affinetransform.getScaleX() / d);
                            if (affinetransform.getShearX() > 0.0) {
                                d_79_ = -d_79_;
                            }
                        }
                    }
                    if (bool_78_ && (bool_80_ = true)) {
                        this.wmfg.setColor(this.getColor());
                        float f_81_ = (float)((double)this.getFont().getSize2D() * d);
                        Font font = this.getFont();
                        this.wmfg.setFont(this.getFont().deriveFont(f_81_));
                        if (d_79_ != 0.0) {
                            this.wmfg.setFontEscapement((int)(-d_79_ * 1800.0 / Math.PI));
                        }
                        Point2D.Double var_double = new Point2D.Double((double)x + this.getFont().getTransform().getTranslateX(), (double)y + this.getFont().getTransform().getTranslateY());
                        this.trans.transform(var_double, var_double);
                        this.wmfg.drawString(s, (int)var_double.getX(), (int)var_double.getY());
                        if (d_79_ != 0.0) {
                            this.wmfg.setFontEscapement(0);
                        }
                        this.wmfg.setFont(font);
                        return;
                    }
                }
            }
            this.drawGlyphVector(this.getFont().createGlyphVector(this.getFontRenderContext(), s), x, y);
        }
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.trans.clone();
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(img, null);
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void shear(double shx, double shy) {
        this.trans.shear(shx, shy);
    }

    Image transformImage(Image img, Rectangle bounds, Rectangle shape, ImageObserver obs, Color background) {
        if (this.trans.isIdentity() && this.getClip() == null && background == null) {
            return img;
        }
        if (this.getClip() != null) {
            Area clipped = new Area(this.getClip());
            clipped.intersect(new Area(bounds));
            shape.setBounds(this.getTransform().createTransformedShape(clipped).getBounds());
        }
        BufferedImage result = new BufferedImage(shape.width, shape.height, 2);
        Graphics2D gresult = (Graphics2D)result.getGraphics();
        gresult.addRenderingHints(this.getRenderingHints());
        gresult.translate(-shape.x, -shape.y);
        gresult.transform((AffineTransform)this.getTransform().clone());
        gresult.setClip(this.getClip());
        if (background != null) {
            gresult.drawImage(img, bounds.x, bounds.y, bounds.width, bounds.height, background, obs);
        } else {
            gresult.drawImage(img, bounds.x, bounds.y, bounds.width, bounds.height, obs);
        }
        gresult.dispose();
        return result;
    }

    Image transformImage(Image img, int[] points, Rectangle shape, ImageObserver obs, Color background) {
        BufferedImage result = new BufferedImage(shape.width, shape.height, 2);
        Graphics2D gresult = (Graphics2D)result.getGraphics();
        gresult.addRenderingHints(this.getRenderingHints());
        gresult.translate(-shape.x, -shape.y);
        gresult.transform((AffineTransform)this.getTransform().clone());
        gresult.setClip(this.getClip());
        if (background != null) {
            gresult.drawImage(img, points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7], background, obs);
        } else {
            gresult.drawImage(img, points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7], obs);
        }
        return result;
    }
}

