/*
 * Decompiled with CFR 0.152.
 */
package rma.xml.adapters;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import rma.util.ColorContour;
import rma.util.contour.ColorContourRecord;
import rma.util.contour.PieChartColorContourRecord;

public class XmlColorContourRecordAdapter
extends XmlAdapter<ContourRecordValueType, ColorContourRecord> {
    public ColorContourRecord unmarshal(ContourRecordValueType v) throws Exception {
        return new PieChartColorContourRecord(v.getContour(), v.getAlpha(), v.getTicInterval());
    }

    public ContourRecordValueType marshal(ColorContourRecord v) throws Exception {
        return new ContourRecordValueType(v.getColorContour(), v.getAlpha(), v.getTicInterval());
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ContourRecordValueType {
        private ColorContour _contour;
        private float _alpha;
        private double _ticInterval;

        public ContourRecordValueType() {
        }

        public ContourRecordValueType(ColorContour contour, float alpha, double ticInterval) {
            this._contour = contour;
            this._alpha = alpha;
            this._ticInterval = ticInterval;
        }

        public ColorContour getContour() {
            return this._contour;
        }

        public float getAlpha() {
            return this._alpha;
        }

        public double getTicInterval() {
            return this._ticInterval;
        }
    }
}

