/*
 * Decompiled with CFR 0.152.
 */
package rma.xml.adapters;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import rma.xml.adapters.XmlColorAdapter;

public class XmlDoubleColorNavMapAdapter
extends XmlAdapter<DoubleColorNavMapValueType, NavigableMap<Double, Color>> {
    public NavigableMap<Double, Color> unmarshal(DoubleColorNavMapValueType v) throws Exception {
        TreeMap<Double, Color> navMap = new TreeMap<Double, Color>();
        List<Double> keys = v.getKeys();
        List<XmlColorAdapter.ColorValueType> values = v.getValues();
        for (int i = 0; i < keys.size() && i < values.size(); ++i) {
            XmlColorAdapter.ColorValueType value = values.get(i);
            Color valueColor = new Color(value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
            navMap.put(keys.get(i), valueColor);
        }
        return navMap;
    }

    public DoubleColorNavMapValueType marshal(NavigableMap<Double, Color> v) throws Exception {
        return new DoubleColorNavMapValueType(v);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class DoubleColorNavMapValueType {
        private ArrayList<Double> _keys = new ArrayList();
        private ArrayList<XmlColorAdapter.ColorValueType> _values = new ArrayList();

        public DoubleColorNavMapValueType() {
        }

        public DoubleColorNavMapValueType(NavigableMap<Double, Color> navMap) {
            Set entrySet = navMap.entrySet();
            for (Map.Entry entry : entrySet) {
                this._keys.add((Double)entry.getKey());
                Color entryColor = (Color)entry.getValue();
                XmlColorAdapter.ColorValueType entryValue = new XmlColorAdapter.ColorValueType(entryColor.getRed(), entryColor.getGreen(), entryColor.getBlue(), entryColor.getAlpha());
                this._values.add(entryValue);
            }
        }

        public List<Double> getKeys() {
            return this._keys;
        }

        public List<XmlColorAdapter.ColorValueType> getValues() {
            return this._values;
        }
    }
}

