/*
 * Decompiled with CFR 0.152.
 */
package rma.xml.adapters;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XmlMapAdapter<K, V>
extends XmlAdapter<MapValueType<K, V>, Map<K, V>> {
    public Map<K, V> unmarshal(MapValueType<K, V> v) throws Exception {
        HashMap<K, V> navMap = new HashMap<K, V>();
        List<K> keys = v.getKeys();
        List<V> values = v.getValues();
        for (int i = 0; i < keys.size() && i < values.size(); ++i) {
            navMap.put(keys.get(i), values.get(i));
        }
        return navMap;
    }

    public MapValueType<K, V> marshal(Map<K, V> v) throws Exception {
        return new MapValueType<K, V>(v);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class MapValueType<K, V> {
        @XmlElementWrapper(name="keys")
        private ArrayList<K> _keys = new ArrayList();
        @XmlElementWrapper(name="values")
        private ArrayList<V> _values = new ArrayList();

        public MapValueType() {
        }

        public MapValueType(Map<K, V> navMap) {
            Set<Map.Entry<K, V>> entrySet = navMap.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                this._keys.add(entry.getKey());
                this._values.add(entry.getValue());
            }
        }

        public List<K> getKeys() {
            return this._keys;
        }

        public List<V> getValues() {
            return this._values;
        }
    }
}

