/*
 * Decompiled with CFR 0.152.
 */
package rma.xml.adapters;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class XmlNavigableMapAdapter<K, V>
extends XmlAdapter<NavigableMapValueType<K, V>, NavigableMap<K, V>> {
    public NavigableMap<K, V> unmarshal(NavigableMapValueType<K, V> v) throws Exception {
        TreeMap<K, V> navMap = new TreeMap<K, V>();
        List<K> keys = v.getKeys();
        List<V> values = v.getValues();
        for (int i = 0; i < keys.size() && i < values.size(); ++i) {
            navMap.put(keys.get(i), values.get(i));
        }
        return navMap;
    }

    public NavigableMapValueType<K, V> marshal(NavigableMap<K, V> v) throws Exception {
        return new NavigableMapValueType<K, V>(v);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class NavigableMapValueType<K, V> {
        private ArrayList<K> _keys = new ArrayList();
        private ArrayList<V> _values = new ArrayList();

        public NavigableMapValueType() {
        }

        public NavigableMapValueType(NavigableMap<K, V> navMap) {
            Set entrySet = navMap.entrySet();
            for (Map.Entry entry : entrySet) {
                this._keys.add(entry.getKey());
                this._values.add(entry.getValue());
            }
        }

        public List<K> getKeys() {
            return this._keys;
        }

        public List<V> getValues() {
            return this._values;
        }
    }
}

