/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4usage;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;

public abstract class Code4 {
    public static final byte DENY_NONE = 0;
    public static final byte DENY_RW = 1;
    public static final byte DENY_WRITE = 2;
    public static final byte AUTO_ALL = 1;
    public static final byte AUTO_OFF = 0;
    protected static final String DEFAULT_HOST = "localhost";
    protected static final int DEFAULT_PORT = 23165;
    protected static final String DEFAULT_USERNAME = "public";
    protected static final String DEFAULT_PASSWORD = "";

    static String dateToString(Date source) {
        Calendar cal = Calendar.getInstance();
        if (source == null) {
            throw new NullPointerException();
        }
        StringBuffer buffer = new StringBuffer(8);
        cal.setTime(source);
        int year = cal.get(1);
        String tempPart = year > 9999 ? "****" : Integer.toString(year);
        buffer.append(tempPart);
        tempPart = Integer.toString(cal.get(2) + 1);
        if (tempPart.length() == 1) {
            buffer.append('0');
        }
        buffer.append(tempPart);
        tempPart = Integer.toString(cal.get(5));
        if (tempPart.length() == 1) {
            buffer.append('0');
        }
        buffer.append(tempPart);
        tempPart = buffer.toString();
        return tempPart;
    }

    static Date stringToDate(String dateStr) throws Error4usage {
        if (dateStr == null) {
            throw new Error4usage("String is null.");
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.set(Integer.valueOf(dateStr.substring(0, 4)), Integer.valueOf(dateStr.substring(4, 6)) - 1, Integer.valueOf(dateStr.substring(6, 8)));
            return cal.getTime();
        }
        catch (NumberFormatException e) {
            throw new Error4usage("String is not in proper format.");
        }
        catch (IndexOutOfBoundsException e) {
            throw new Error4usage("String is not in proper format.");
        }
    }

    public abstract void close() throws IOException;

    protected synchronized void finalize() throws IOException, Throwable {
        this.close();
        super.finalize();
    }

    public abstract byte accessMode(byte var1) throws IOException, Error4usage;

    public abstract byte accessMode() throws Error4usage;

    public void connect() throws UnknownHostException, IOException, Error4unexpected, Error4usage, Error4message {
        this.connect(null, -1, null, null);
    }

    public void connect(String host) throws UnknownHostException, IOException, Error4unexpected, Error4usage, Error4message {
        this.connect(host, -1, null, null);
    }

    public void connect(String host, int port) throws UnknownHostException, IOException, Error4unexpected, Error4usage, Error4message {
        this.connect(host, port, null, null);
    }

    public abstract void connect(String var1, int var2, String var3, String var4) throws UnknownHostException, IOException, Error4unexpected, Error4usage, Error4message;

    public abstract byte defaultUnique(byte var1) throws IOException, Error4usage;

    public abstract byte defaultUnique() throws Error4usage;

    public abstract void lock() throws IOException, Error4usage, Error4unexpected, Error4locked;

    public abstract void lockClear() throws Error4usage;

    public abstract boolean readLock(boolean var1) throws IOException, Error4usage;

    public abstract boolean readLock() throws Error4usage;

    public abstract boolean readOnly(boolean var1) throws IOException, Error4usage;

    public abstract boolean readOnly() throws Error4usage;

    public abstract boolean safety(boolean var1) throws IOException, Error4usage;

    public abstract boolean safety() throws Error4usage;

    public abstract void unlock() throws IOException, Error4usage, Error4unexpected;

    public abstract byte unlockAuto(byte var1) throws IOException, Error4usage;

    public abstract byte unlockAuto() throws Error4usage;
}

