/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Code4;
import codebase.Error4locked;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Lock4;
import codebase.Message4;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Vector;

public final class Code4cs
extends Code4 {
    private Message4 commMessage = new Message4();
    private Vector dataLocks = new Vector();
    private byte accessModeSetting = 0;
    private byte defaultUniqueSetting = (byte)25;
    private boolean readLockSetting = false;
    private boolean readOnlySetting = false;
    private boolean safetySetting = true;
    private byte unlockAutoSetting = 1;

    @Override
    public synchronized void close() throws IOException {
        this.connectUndo();
    }

    public final void connectedCheck() throws Error4usage {
        if (!this.commMessage.connected()) {
            throw new Error4usage("Not connected to server");
        }
    }

    protected void addLock(Lock4 currentLock) throws Error4usage {
        this.connectedCheck();
        if (currentLock == null) {
            throw new NullPointerException("addLock passed a null pointer");
        }
        this.dataLocks.addElement(currentLock);
    }

    @Override
    public synchronized byte accessMode(byte newValue) throws IOException, Error4usage {
        this.connectedCheck();
        switch (newValue) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new Error4usage("newValue is not a valid value");
            }
        }
        this.commMessage.setAccessMode(newValue);
        byte oldValue = this.accessModeSetting;
        this.accessModeSetting = newValue;
        return oldValue;
    }

    @Override
    public byte accessMode() throws Error4usage {
        this.connectedCheck();
        return this.accessModeSetting;
    }

    @Override
    public void connect(String host, int port, String userName, String password) throws UnknownHostException, IOException, Error4unexpected, Error4usage {
        if (this.commMessage.connected()) {
            throw new Error4usage("Already connected");
        }
        if (host == null) {
            host = "localhost";
        }
        if (port < 0 || port > Short.MAX_VALUE) {
            port = 23165;
        }
        if (userName == null) {
            userName = "public";
        } else {
            userName.trim();
            if (userName.length() == 0) {
                userName = "public";
            }
        }
        if (password == null) {
            password = "";
        }
        this.commMessage.connect(host, (short)port, userName, password);
        short status = this.commMessage.statusCode();
        if (status != 0) {
            throw new Error4unexpected(status);
        }
    }

    public synchronized void connectUndo() throws IOException {
        if (this.commMessage.connected()) {
            this.commMessage.disconnect();
        }
    }

    @Override
    public synchronized byte defaultUnique(byte newValue) throws IOException, Error4usage {
        this.connectedCheck();
        switch (newValue) {
            case 20: 
            case 25: {
                break;
            }
            default: {
                throw new Error4usage("newValue is not a valid value");
            }
        }
        this.commMessage.setDefaultUnique(newValue);
        byte oldValue = this.defaultUniqueSetting;
        this.defaultUniqueSetting = newValue;
        return oldValue;
    }

    @Override
    public byte defaultUnique() throws Error4usage {
        this.connectedCheck();
        return this.defaultUniqueSetting;
    }

    protected Message4 getMessage4() throws Error4usage {
        this.connectedCheck();
        return this.commMessage;
    }

    @Override
    public synchronized void lock() throws IOException, Error4usage, Error4unexpected, Error4locked {
        this.connectedCheck();
        if (this.dataLocks.size() <= 0) {
            return;
        }
        this.commMessage.lock(this.dataLocks);
        short status = this.commMessage.statusCode();
        if (status != 0) {
            if (status == 50) {
                throw new Error4locked();
            }
            throw new Error4unexpected(status);
        }
        this.dataLocks.removeAllElements();
    }

    @Override
    public void lockClear() throws Error4usage {
        this.connectedCheck();
        this.dataLocks.removeAllElements();
    }

    @Override
    public boolean readLock(boolean newValue) throws IOException, Error4usage {
        this.connectedCheck();
        this.commMessage.setReadLock(newValue);
        boolean oldValue = this.readLockSetting;
        this.readLockSetting = newValue;
        return oldValue;
    }

    @Override
    public boolean readLock() throws Error4usage {
        this.connectedCheck();
        return this.readLockSetting;
    }

    @Override
    public synchronized boolean readOnly(boolean newValue) throws IOException, Error4usage {
        this.connectedCheck();
        this.commMessage.setReadOnly(newValue);
        boolean oldValue = this.readOnlySetting;
        this.readOnlySetting = newValue;
        return oldValue;
    }

    @Override
    public boolean readOnly() throws Error4usage {
        this.connectedCheck();
        return this.readOnlySetting;
    }

    @Override
    public boolean safety(boolean newValue) throws IOException, Error4usage {
        this.connectedCheck();
        this.commMessage.setSafety(newValue);
        boolean oldValue = this.safetySetting;
        this.safetySetting = newValue;
        return oldValue;
    }

    @Override
    public boolean safety() throws Error4usage {
        this.connectedCheck();
        return this.safetySetting;
    }

    @Override
    public void unlock() throws IOException, Error4usage, Error4unexpected {
        this.connectedCheck();
        this.commMessage.unlock();
        short status = this.commMessage.statusCode();
        if (status != 0) {
            throw new Error4unexpected(status);
        }
    }

    @Override
    public byte unlockAuto(byte newValue) throws IOException, Error4usage {
        this.connectedCheck();
        switch (newValue) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new Error4usage("newValue is not a valid value");
            }
        }
        this.commMessage.setUnlockAuto(newValue);
        byte oldValue = this.unlockAutoSetting;
        this.unlockAutoSetting = newValue;
        return oldValue;
    }

    @Override
    public byte unlockAuto() throws Error4usage {
        this.connectedCheck();
        return this.unlockAutoSetting;
    }

    protected synchronized byte ping(int sendAmt, int recAmt) throws Error4usage, IOException {
        this.connectedCheck();
        this.commMessage.ping(sendAmt, recAmt);
        return 0;
    }
}

