/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Code4;
import codebase.Error4locked;
import codebase.Error4unexpected;
import codebase.Error4usage;
import java.io.IOException;

public class Code4jni
extends Code4 {
    public static String libName = "cb";
    protected long CODE4;

    private native long code4init();

    private native byte c4setAccessMode(byte var1);

    private native byte c4getAccessMode();

    private native void c4setAutoOpen(boolean var1);

    private native boolean c4getAutoOpen();

    private native short code4connect(String var1, String var2, String var3, String var4);

    private native short code4initUndo();

    private native byte c4getErrDefaultUnique();

    private native byte c4setErrDefaultUnique(byte var1);

    private native short code4lock();

    private native void code4lockClear();

    private native boolean c4getReadLock();

    private native boolean c4setReadLock(boolean var1);

    private native boolean c4getReadOnly();

    private native boolean c4setReadOnly(boolean var1);

    private native boolean c4getSafety();

    private native boolean c4setSafety(boolean var1);

    private native short code4unlock();

    private native byte c4setUnlockAuto(byte var1);

    private native byte c4getUnlockAuto();

    private native boolean isClientServer();

    public native short getLastError();

    public Code4jni() throws IOException {
        System.loadLibrary(libName);
        this.CODE4 = this.code4init();
        if (this.CODE4 == 0L) {
            throw new IOException();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.code4initUndo();
        this.CODE4 = 0L;
    }

    @Override
    public synchronized byte accessMode(byte newValue) throws Error4usage {
        switch (newValue) {
            case 0: 
            case 1: 
            case 2: {
                return this.c4setAccessMode(newValue);
            }
        }
        throw new Error4usage("newValue is not a valid value");
    }

    @Override
    public synchronized byte accessMode() {
        return this.c4getAccessMode();
    }

    public synchronized void autoOpen(boolean newValue) throws Error4usage {
        this.c4setAutoOpen(newValue);
    }

    public synchronized boolean autoOpen() {
        return this.c4getAutoOpen();
    }

    @Override
    public synchronized void connect(String host, int port, String userName, String password) throws Error4unexpected, Error4usage {
    }

    @Override
    public synchronized byte defaultUnique(byte newValue) throws Error4usage {
        switch (newValue) {
            case 20: 
            case 25: {
                return this.c4setErrDefaultUnique(newValue);
            }
        }
        throw new Error4usage("newValue is not a valid value");
    }

    @Override
    public synchronized byte defaultUnique() {
        return this.c4getErrDefaultUnique();
    }

    public synchronized boolean isStandAlone() {
        return !this.isClientServer();
    }

    private native short lockAttempts(short var1);

    private native short lockAttempts();

    @Override
    public synchronized void lock() throws Error4unexpected, Error4locked {
        short status = this.code4lock();
        switch (status) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized void lockClear() {
        this.code4lockClear();
    }

    @Override
    public synchronized boolean readLock(boolean newValue) {
        return this.c4setReadLock(newValue);
    }

    @Override
    public synchronized boolean readLock() {
        return this.c4getReadLock();
    }

    @Override
    public synchronized boolean readOnly(boolean newValue) {
        return this.c4setReadOnly(newValue);
    }

    @Override
    public synchronized boolean readOnly() {
        return this.c4getReadOnly();
    }

    @Override
    public synchronized boolean safety(boolean newValue) {
        return this.c4setSafety(newValue);
    }

    @Override
    public synchronized boolean safety() {
        return this.c4getSafety();
    }

    @Override
    public synchronized void unlock() throws Error4unexpected {
        short status = this.code4unlock();
        if (status != 0) {
            throw new Error4unexpected(status);
        }
    }

    @Override
    public synchronized byte unlockAuto(byte newValue) throws Error4usage {
        switch (newValue) {
            case 0: 
            case 1: {
                return this.c4setUnlockAuto(newValue);
            }
        }
        throw new Error4usage("newValue is not a valid value");
    }

    @Override
    public synchronized byte unlockAuto() throws Error4usage {
        return this.c4getUnlockAuto();
    }
}

