/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Code4;
import codebase.Error4entry;
import codebase.Error4field;
import codebase.Error4file;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4contents;
import codebase.Field4define;
import codebase.Field4info;
import codebase.Tag4info;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public abstract class Data4 {
    protected boolean fieldsAreValid;
    protected Vector fields;
    protected String fileName;

    private Field4contents findField(short fieldNum) {
        if (this.fields == null) {
            return null;
        }
        int i = 0;
        int size = this.fields.size();
        while (i < size) {
            Field4contents fieldAt = (Field4contents)this.fields.elementAt(i);
            if (fieldAt.getNumber() == fieldNum) {
                return fieldAt;
            }
            ++i;
        }
        return null;
    }

    protected void addField() throws IOException, Error4field {
        Field4contents field = this.findField((short)-1);
        if (field == null) {
            this.fieldsAreValid = false;
            this.fields.addElement(new Field4contents(null));
        } else {
            field.add();
        }
    }

    protected Field4define addField(String fieldName, String validFieldTypes) throws IOException, Error4field {
        if (fieldName == null || validFieldTypes == null) {
            throw new NullPointerException();
        }
        Field4define fieldDef = this.getFieldInfo(fieldName);
        if (validFieldTypes.indexOf(fieldDef.getType()) == -1) {
            throw new Error4field("Cannot initialize to type '" + fieldDef.getType() + "'.");
        }
        Field4contents field = this.findField(fieldDef.getNumber());
        if (field == null) {
            this.fieldsAreValid = false;
            this.fields.addElement(new Field4contents(fieldDef));
        } else {
            field.add();
        }
        return fieldDef;
    }

    protected void deleteField(short fieldNum) {
        Field4contents field = this.findField(fieldNum);
        if (field == null) {
            throw new RuntimeException("field not found in record buffer");
        }
        if (field.delete() == 0) {
            this.fields.removeElement(field);
        }
    }

    protected void clearFields() {
        int i = 0;
        while (i < this.fields.size()) {
            ((Field4contents)this.fields.elementAt(i)).setBlank();
            ++i;
        }
    }

    protected Object getContents(short fieldNum) throws Error4message, IOException, Error4unexpected {
        Field4contents field;
        if (!this.fieldsAreValid) {
            this.refreshFieldList();
        }
        if ((field = this.findField(fieldNum)) == null) {
            throw new RuntimeException("field " + fieldNum + " not found in record buffer");
        }
        return field.contents;
    }

    protected void setContents(short fieldNum, Object newContents) throws Error4message, IOException, Error4unexpected {
        Field4contents field;
        if (!this.fieldsAreValid) {
            this.refreshFieldList();
        }
        if ((field = this.findField(fieldNum)) == null) {
            throw new RuntimeException("field " + fieldNum + " not found in record buffer");
        }
        field.contents = newContents;
    }

    public abstract Code4 getCode4();

    abstract void openedCheck() throws Error4usage;

    public abstract void append() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique, Error4message;

    public abstract void blank() throws IOException, Error4usage, Error4locked, Error4unique;

    public abstract int bottom() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4message;

    public abstract void close() throws IOException, Error4usage, Error4unexpected;

    public abstract void create(String var1, Field4info var2, Tag4info var3) throws IOException, Error4usage, Error4unexpected, Error4file;

    public void create(String dataFileName, Field4info dataFields) throws IOException, Error4usage, Error4unexpected, Error4file {
        this.create(dataFileName, dataFields, null);
    }

    public abstract void createIndex(String var1, Tag4info var2) throws IOException, Error4usage, Error4unexpected, Error4unique, Error4file;

    protected abstract Field4define getFieldInfo(String var1) throws IOException, Error4field;

    public abstract void go(int var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry;

    public abstract void lockAdd(int var1) throws Error4usage;

    public abstract void lockAddAll() throws Error4usage;

    public abstract void lockAddAppend() throws Error4usage;

    public abstract void lockAddFile() throws Error4usage;

    public abstract void open(String var1) throws IOException, Error4usage, Error4unexpected, Error4file, Error4message;

    public abstract void openIndex(String var1) throws IOException, Error4usage, Error4unexpected, Error4file;

    public abstract void pack() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique;

    public abstract double position() throws IOException, Error4usage, Error4unexpected, Error4locked;

    public abstract int position(double var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry;

    public int positionSet(double newPosition) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        return this.position(newPosition);
    }

    public abstract int recCount() throws IOException, Error4usage, Error4unexpected;

    public abstract int recNo() throws IOException, Error4usage, Error4unexpected;

    public abstract void refreshRecord();

    protected abstract void refreshFieldList() throws IOException, Error4message, Error4unexpected;

    public abstract void reindex() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique;

    public abstract int seek(double var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry;

    public abstract int seek(String var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry;

    public abstract int seek(byte[] var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry;

    public abstract int seek(Date var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry;

    public abstract int seekUnicode(String var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry;

    public abstract void select(String var1) throws IOException, Error4usage, Error4unexpected, Error4tagName;

    public abstract int skip(int var1) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked;

    public int skip() throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked {
        return this.skip(1);
    }

    public abstract int top() throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked;

    public String toString() {
        if (this.fileName == null) {
            return new String();
        }
        return new String(this.fileName);
    }

    public abstract void update() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique, Error4message;
}

