/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Code4;
import codebase.Code4cs;
import codebase.Data4;
import codebase.Error4entry;
import codebase.Error4field;
import codebase.Error4file;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4define;
import codebase.Field4info;
import codebase.Lock4;
import codebase.Message4;
import codebase.Tag4info;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public class Data4cs
extends Data4 {
    private static final int DATA_NOT_OPEN = -1;
    private Code4cs cb;
    private Message4 commMessage;
    protected int dataId;

    public Data4cs() {
    }

    public Data4cs(Code4cs code) {
        if (code == null) {
            throw new NullPointerException();
        }
        this.cb = code;
        this.dataId = -1;
    }

    public Data4cs(Code4cs code, String dataFileName) throws IOException, Error4usage, Error4unexpected, Error4file {
        this(code);
        this.open(dataFileName);
    }

    protected synchronized void finalize() throws IOException, Error4usage, Error4unexpected {
        if (this.dataId != -1) {
            this.close();
        }
    }

    @Override
    final void openedCheck() throws Error4usage {
        if (this.dataId == -1) {
            throw new Error4usage("Datafile not open");
        }
        this.cb.connectedCheck();
    }

    @Override
    public Code4 getCode4() {
        return this.cb;
    }

    @Override
    protected Field4define getFieldInfo(String fieldName) throws IOException, Error4field {
        this.commMessage.setCurrentData(this.dataId);
        return this.commMessage.getFieldInfo(fieldName);
    }

    @Override
    public synchronized void append() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique, Error4message {
        this.openedCheck();
        if (!this.fieldsAreValid) {
            this.refreshFieldList();
        }
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.append(this.fields);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: 
            case 20: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized void blank() throws IOException, Error4usage, Error4locked, Error4unique {
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.blank();
        this.clearFields();
    }

    @Override
    public synchronized int bottom() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4message {
        this.openedCheck();
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.bottom();
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
                break;
            }
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized void close() throws IOException, Error4usage, Error4unexpected {
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.close();
        short status = this.commMessage.statusCode();
        if (status != 0) {
            throw new Error4unexpected(status);
        }
        this.dataId = -1;
        this.fileName = null;
    }

    @Override
    public synchronized void create(String dataFileName, Field4info dataFields, Tag4info indexTags) throws IOException, Error4usage, Error4unexpected, Error4file {
        int[] dataIdReturn = new int[1];
        if (this.dataId != -1) {
            throw new Error4usage("Data4 has a file open");
        }
        if (dataFileName == null) {
            throw new NullPointerException("dataFileName is null");
        }
        if (dataFields == null) {
            throw new NullPointerException("dataFields is null");
        }
        this.fieldsAreValid = false;
        this.commMessage = this.cb.getMessage4();
        short status = this.commMessage.create(dataFileName, dataFields, indexTags, dataIdReturn);
        switch (status) {
            case 0: {
                this.fileName = new String(dataFileName);
                break;
            }
            case -20: {
                throw new Error4file("Error creating " + dataFileName);
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        this.fields = new Vector();
        this.dataId = dataIdReturn[0];
    }

    @Override
    public synchronized void createIndex(String indexFileName, Tag4info indexTags) throws IOException, Error4usage, Error4unexpected, Error4unique, Error4file {
        this.openedCheck();
        if (indexTags == null) {
            throw new NullPointerException("indexTags is null");
        }
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.createIndex(indexFileName, indexTags);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case -20: {
                if (indexFileName == null) {
                    throw new Error4file("Error creating production index file");
                }
                throw new Error4file("Error creating " + indexFileName);
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized void go(int recordNumber) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (recordNumber < 1) {
            throw new Error4usage("recordNumber is less than 1");
        }
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.go(recordNumber);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized void lockAdd(int recordNumber) throws Error4usage {
        this.openedCheck();
        if (recordNumber < 1) {
            throw new Error4usage("recordNumber is less than 1");
        }
        this.cb.addLock(new Lock4(this.dataId, recordNumber));
    }

    @Override
    public synchronized void lockAddAll() throws Error4usage {
        this.openedCheck();
        this.cb.addLock(new Lock4(this.dataId, -2));
    }

    @Override
    public synchronized void lockAddAppend() throws Error4usage {
        this.openedCheck();
        this.cb.addLock(new Lock4(this.dataId, 0));
    }

    @Override
    public synchronized void lockAddFile() throws Error4usage {
        this.openedCheck();
        this.cb.addLock(new Lock4(this.dataId, -1));
    }

    @Override
    public synchronized void open(String dataFileName) throws IOException, Error4usage, Error4unexpected, Error4file {
        int[] dataIdReturn = new int[1];
        if (this.dataId != -1) {
            throw new Error4usage("Data4cs already has a file open");
        }
        if (dataFileName == null) {
            throw new NullPointerException();
        }
        this.fieldsAreValid = false;
        this.cb.connectedCheck();
        this.commMessage = this.cb.getMessage4();
        short status = this.commMessage.open(dataFileName, dataIdReturn);
        switch (status) {
            case 0: {
                this.fileName = new String(dataFileName);
                break;
            }
            case -64: 
            case -60: {
                throw new Error4file("Error opening " + dataFileName);
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        this.fields = new Vector();
        this.dataId = dataIdReturn[0];
        this.fileName = new String(dataFileName);
    }

    @Override
    public synchronized void openIndex(String indexFileName) throws IOException, Error4usage, Error4unexpected, Error4file {
        this.openedCheck();
        if (indexFileName == null) {
            throw new NullPointerException();
        }
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.openIndex(indexFileName);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case -60: {
                throw new Error4file("Error opening " + indexFileName);
            }
            case -61: {
                throw new Error4file("Permission error:Error opening " + indexFileName);
            }
            case -62: {
                throw new Error4file("Access error:Error opening " + indexFileName);
            }
            case -64: {
                throw new Error4file("File find error:Error opening " + indexFileName);
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized void pack() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique {
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.pack();
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized double position() throws IOException, Error4usage, Error4unexpected, Error4locked {
        double[] currentPosition = new double[1];
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        short status = this.commMessage.position(currentPosition);
        switch (status) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return currentPosition[0];
    }

    @Override
    public synchronized int position(double newPosition) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.positionSet(newPosition);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: {
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized int recCount() throws IOException, Error4usage, Error4unexpected {
        int[] recCountReturn = new int[1];
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        short status = this.commMessage.recCount(recCountReturn);
        switch (status) {
            case 0: {
                break;
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return recCountReturn[0];
    }

    @Override
    public synchronized int recNo() throws IOException, Error4usage, Error4unexpected {
        int[] recNoReturn = new int[1];
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        short status = this.commMessage.recNo(recNoReturn);
        switch (status) {
            case 0: {
                break;
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return recNoReturn[0];
    }

    @Override
    protected void refreshFieldList() throws IOException, Error4message, Error4unexpected {
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.refreshFields(this.fields);
        this.fieldsAreValid = true;
    }

    @Override
    public void refreshRecord() {
        this.fieldsAreValid = false;
    }

    @Override
    public synchronized void reindex() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique {
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.reindex();
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized int seek(double seekValue) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.seek(seekValue);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 2: {
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized int seek(String seekValue) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (seekValue == null) {
            throw new NullPointerException();
        }
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.seek(seekValue);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 2: {
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized int seek(byte[] seekValue) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (seekValue == null) {
            throw new NullPointerException();
        }
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.seek(seekValue);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 2: {
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized int seek(Date seekValue) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (seekValue == null) {
            throw new NullPointerException();
        }
        return this.seek(Code4cs.dateToString(seekValue));
    }

    @Override
    public synchronized int seekUnicode(String seekValue) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (seekValue == null) {
            throw new NullPointerException();
        }
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.seekUnicode(seekValue);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 2: {
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized void select(String tagName) throws IOException, Error4usage, Error4unexpected, Error4tagName {
        this.openedCheck();
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.select(tagName);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case -330: {
                throw new Error4tagName();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }

    @Override
    public synchronized int skip(int numberRecords) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked {
        this.openedCheck();
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.skip(numberRecords);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 4: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized int top() throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked {
        this.openedCheck();
        this.fieldsAreValid = false;
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.top();
        short status = this.commMessage.statusCode();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public synchronized void update() throws IOException, Error4usage, Error4unexpected, Error4locked, Error4unique, Error4message {
        this.openedCheck();
        if (!this.fieldsAreValid) {
            this.refreshFieldList();
        }
        this.commMessage.setCurrentData(this.dataId);
        this.commMessage.update(this.fields);
        short status = this.commMessage.statusCode();
        switch (status) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
    }
}

