/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Code4;
import codebase.Code4jni;
import codebase.Data4;
import codebase.Error4;
import codebase.Error4entry;
import codebase.Error4field;
import codebase.Error4file;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4contents;
import codebase.Field4define;
import codebase.Field4info;
import codebase.Tag4define;
import codebase.Tag4info;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public class Data4jni
extends Data4 {
    private Code4jni cb;
    private long DATA4;
    private static final int LOCKALL = -1;
    private static final int LOCKAPPEND = -2;
    private static final int LOCKFILE = -3;

    public Data4jni() {
    }

    public Data4jni(Code4jni code) throws Error4usage {
        if (code == null) {
            throw new NullPointerException("Code4jni is null");
        }
        if (!(code instanceof Code4jni)) {
            throw new Error4usage("Data4jni must be initialized with a Code4jni type.");
        }
        this.cb = code;
    }

    public Data4jni(Code4jni code, String dataFileName) throws IOException, Error4usage, Error4unexpected, Error4file, Error4message {
        this(code);
        if (dataFileName == null) {
            throw new NullPointerException("dataFileName is null");
        }
        this.open(dataFileName);
    }

    protected synchronized void finalize() throws IOException, Error4usage, Error4unexpected {
        if (this.DATA4 != 0L) {
            this.close();
        }
    }

    @Override
    public Code4 getCode4() {
        return this.cb;
    }

    @Override
    protected void refreshFieldList() throws IOException, Error4message, Error4unexpected {
        int size = this.fields.size();
        int i = 0;
        while (i < size) {
            Field4contents field = (Field4contents)this.fields.elementAt(i);
            Object contentsType = field.getType();
            if (contentsType instanceof byte[]) {
                this.getByteArray(field);
            } else if (contentsType instanceof Double) {
                this.getDouble(field);
            } else {
                throw new RuntimeException("unrecognized field type \"" + field.definition.getName() + "\"");
            }
            ++i;
        }
        this.fieldsAreValid = true;
    }

    @Override
    final void openedCheck() throws Error4usage {
        if (this.DATA4 == 0L) {
            throw new Error4usage("Database not open");
        }
    }

    private native byte fieldType(String var1);

    private native short fieldNumber(String var1);

    private native int fieldLength(String var1);

    private native int fieldDecimals(String var1);

    @Override
    protected Field4define getFieldInfo(String fieldName) throws Error4field {
        Field4define definition;
        int length;
        char type = (char)this.fieldType(fieldName);
        switch (type) {
            case '\u0000': {
                throw new Error4field(fieldName);
            }
            case 'B': 
            case 'G': 
            case 'M': {
                length = 0;
                break;
            }
            default: {
                length = this.fieldLength(fieldName);
            }
        }
        try {
            definition = new Field4define(fieldName, type, length, this.fieldDecimals(fieldName), false);
        }
        catch (Error4usage e) {
            throw new RuntimeException(e.toString());
        }
        definition.setNumber(this.fieldNumber(fieldName));
        return definition;
    }

    private native void aliasJ(String var1);

    public synchronized void alias(String newAlias) throws Error4usage {
        this.openedCheck();
        this.aliasJ(newAlias);
    }

    private native String aliasJ();

    public synchronized String alias() throws Error4usage {
        this.openedCheck();
        return this.aliasJ();
    }

    private native short appendJ();

    private native short appendStartJ(boolean var1);

    @Override
    public synchronized void append() throws Error4unexpected, Error4usage, Error4locked, Error4unique, Error4message, IOException {
        this.openedCheck();
        if (!this.fieldsAreValid) {
            this.refreshFieldList();
        }
        this.appendStartJ(true);
        int size = this.fields.size();
        int i = 0;
        while (i < size) {
            Field4contents field = (Field4contents)this.fields.elementAt(i);
            if (field.contents instanceof byte[]) {
                this.putByteArray(field);
            } else if (field.contents instanceof Double) {
                this.putDouble(field);
            } else {
                throw new RuntimeException("unrecognized field type \"" + field.definition.getName() + "\"");
            }
            ++i;
        }
        switch (this.appendJ()) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: 
            case 20: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    @Override
    public synchronized void blank() throws IOException, Error4usage, Error4locked, Error4unique {
        this.openedCheck();
        this.clearFields();
    }

    private native short bottomJ();

    @Override
    public synchronized int bottom() throws Error4usage, Error4unexpected, Error4locked, Error4message {
        this.openedCheck();
        short status = this.bottomJ();
        switch (status) {
            case 3: {
                this.clearFields();
                break;
            }
            case 0: {
                this.fieldsAreValid = false;
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    private native short closeJ();

    @Override
    public synchronized void close() throws Error4usage, Error4unexpected {
        this.openedCheck();
        short status = this.closeJ();
        this.DATA4 = 0L;
        this.clearFields();
        this.fields = null;
        this.fileName = null;
        if (status != 0) {
            throw new Error4unexpected(status);
        }
    }

    private native long createJ(String var1, Field4define[] var2, Tag4define[] var3);

    @Override
    public synchronized void create(String dataFileName, Field4info dataFields, Tag4info indexTags) throws Error4usage, Error4unexpected, Error4file {
        if (dataFileName == null) {
            throw new NullPointerException("dataFileName is null");
        }
        if (dataFields == null) {
            throw new NullPointerException("dataFields is null");
        }
        int numFields = dataFields.getFields().size();
        Field4define[] fieldArray = new Field4define[numFields];
        int i = 0;
        while (i < numFields) {
            fieldArray[i] = (Field4define)dataFields.getFields().elementAt(i);
            ++i;
        }
        Tag4define[] tagArray = indexTags == null ? (Tag4define[])null : indexTags.getTagArray();
        long tempData = this.createJ(dataFileName, fieldArray, tagArray);
        switch (this.cb.getLastError()) {
            case 0: {
                try {
                    if (this.DATA4 != 0L) {
                        this.close();
                    }
                }
                catch (Error4 error4) {
                    // empty catch block
                }
                this.DATA4 = tempData;
                this.fields = new Vector();
                this.fileName = new String(dataFileName);
                this.clearFields();
                break;
            }
            case -20: {
                throw new Error4file("Error creating " + dataFileName);
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
        this.fields = new Vector();
    }

    private native short i4create(String var1, Tag4define[] var2);

    @Override
    public synchronized void createIndex(String indexFileName, Tag4info indexTags) throws Error4usage, Error4unexpected, Error4unique, Error4file {
        this.openedCheck();
        if (indexTags == null) {
            throw new NullPointerException("indexTags is null");
        }
        switch (this.i4create(indexFileName, indexTags.getTagArray())) {
            case 0: {
                break;
            }
            case -20: {
                if (indexFileName == null) {
                    throw new Error4file("Error creating production index file");
                }
                throw new Error4file("Error creating " + indexFileName);
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native short goJ(int var1);

    @Override
    public synchronized void go(int recordNumber) throws Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (recordNumber < 1) {
            throw new Error4usage("recordNumber is less than 1");
        }
        this.fieldsAreValid = false;
        switch (this.goJ(recordNumber)) {
            case 0: {
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native short lockAddJ(int var1);

    @Override
    public synchronized void lockAdd(int recordNumber) throws Error4usage {
        this.openedCheck();
        if (recordNumber < 1) {
            throw new Error4usage("recordNumber is less than 1.");
        }
        this.lockAddJ(recordNumber);
    }

    @Override
    public synchronized void lockAddAll() throws Error4usage {
        this.openedCheck();
        this.lockAddJ(-1);
    }

    @Override
    public synchronized void lockAddAppend() throws Error4usage {
        this.openedCheck();
        this.lockAddJ(-2);
    }

    @Override
    public synchronized void lockAddFile() throws Error4usage {
        this.openedCheck();
        this.lockAddJ(-3);
    }

    private native short memoCompressJ();

    public synchronized void memoCompress() throws Error4usage, Error4locked, Error4unexpected {
        this.openedCheck();
        switch (this.memoCompressJ()) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native long openJ(String var1);

    @Override
    public synchronized void open(String dataFileName) throws IOException, Error4usage, Error4unexpected, Error4file, Error4message {
        if (dataFileName == null) {
            throw new NullPointerException();
        }
        long tempData = this.openJ(dataFileName);
        if (tempData != 0L) {
            this.fieldsAreValid = false;
            if (this.DATA4 != 0L) {
                this.close();
            }
        } else {
            if (this.cb.getLastError() / 10 == -6) {
                throw new Error4file("Error opening " + dataFileName);
            }
            throw new Error4unexpected(this.cb.getLastError());
        }
        this.DATA4 = tempData;
        this.fields = new Vector();
        this.fileName = new String(dataFileName);
    }

    private native short openIndexJ(String var1);

    @Override
    public synchronized void openIndex(String indexFileName) throws Error4usage, Error4unexpected, Error4file, FileNotFoundException {
        this.openedCheck();
        switch (this.openIndexJ(indexFileName)) {
            case 0: {
                break;
            }
            case -60: {
                throw new Error4file("Error opening " + indexFileName);
            }
            case -61: {
                throw new Error4file("Permission error opening " + indexFileName);
            }
            case -62: {
                throw new Error4file("Access error opening " + indexFileName);
            }
            case -69: {
                throw new Error4file(String.valueOf(indexFileName) + " is already open");
            }
            case -64: {
                throw new FileNotFoundException(indexFileName);
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native short packJ();

    @Override
    public synchronized void pack() throws Error4usage, Error4unexpected, Error4locked, Error4unique {
        this.openedCheck();
        switch (this.packJ()) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native double positionJ();

    @Override
    public synchronized double position() throws Error4usage, Error4unexpected, Error4locked {
        double currentPosition = this.positionJ();
        if (currentPosition < 0.0 || currentPosition >= 2.0) {
            switch ((short)currentPosition) {
                case 0: {
                    break;
                }
                case 50: {
                    throw new Error4locked();
                }
                default: {
                    throw new Error4unexpected((short)currentPosition);
                }
            }
        }
        return currentPosition;
    }

    private native int positionJ(double var1);

    @Override
    public synchronized int position(double newPosition) throws Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        int status = this.positionJ(newPosition);
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: {
                this.fieldsAreValid = false;
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected((short)status);
            }
        }
        return status;
    }

    private native int recCountJ();

    @Override
    public synchronized int recCount() throws Error4usage {
        this.openedCheck();
        return this.recCountJ();
    }

    private native int recNoJ();

    @Override
    public synchronized int recNo() throws Error4usage {
        this.openedCheck();
        return this.recNoJ();
    }

    private native short refreshRecordJ();

    @Override
    public void refreshRecord() {
        this.fieldsAreValid = false;
        this.refreshRecordJ();
    }

    private native short reindexJ();

    @Override
    public synchronized void reindex() throws Error4usage, Error4unexpected, Error4locked, Error4unique {
        this.openedCheck();
        switch (this.reindexJ()) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native short seekJ(double var1);

    @Override
    public synchronized int seek(double seekValue) throws Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        short status = this.seekJ(seekValue);
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 2: {
                this.fieldsAreValid = false;
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    private native short seekJ(String var1);

    @Override
    public int seek(String seekValue) throws Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        return this.seek(seekValue.getBytes());
    }

    private native short seekJ(byte[] var1);

    @Override
    public synchronized int seek(byte[] seekValue) throws Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (seekValue == null) {
            throw new NullPointerException();
        }
        short status = this.seekJ(seekValue);
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 2: {
                this.fieldsAreValid = false;
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    @Override
    public int seek(Date seekValue) throws IOException, Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        if (seekValue == null) {
            throw new NullPointerException();
        }
        return this.seek(Code4jni.dateToString(seekValue));
    }

    private native short seekUnicodeJ(String var1);

    @Override
    public synchronized int seekUnicode(String seekValue) throws Error4usage, Error4unexpected, Error4message, Error4locked, Error4entry {
        this.openedCheck();
        if (seekValue == null) {
            throw new NullPointerException();
        }
        short status = this.seekUnicodeJ(seekValue);
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 2: {
                this.fieldsAreValid = false;
                break;
            }
            case -300: {
                throw new Error4entry();
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    private native short selectJ(String var1);

    @Override
    public synchronized void select(String tagName) throws Error4usage, Error4unexpected, Error4tagName {
        this.openedCheck();
        switch (this.selectJ(tagName)) {
            case 0: {
                break;
            }
            case -330: {
                throw new Error4tagName();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native short skipJ(int var1);

    @Override
    public synchronized int skip(int numberRecords) throws Error4usage, Error4unexpected, Error4message, Error4locked {
        this.openedCheck();
        short status = this.skipJ(numberRecords);
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: 
            case 4: {
                this.fieldsAreValid = false;
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    public synchronized native void tagRemove(String var1) throws Error4tagName;

    private native short topJ();

    @Override
    public synchronized int top() throws Error4usage, Error4unexpected, Error4message, Error4locked {
        this.openedCheck();
        short status = this.topJ();
        switch (status) {
            case 3: {
                this.clearFields();
            }
            case 0: {
                this.fieldsAreValid = false;
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            default: {
                throw new Error4unexpected(status);
            }
        }
        return status;
    }

    private native short flushJ();

    @Override
    public synchronized void update() throws Error4usage, Error4unexpected, Error4locked, Error4unique, Error4message, IOException {
        this.openedCheck();
        if (!this.fieldsAreValid) {
            this.refreshFieldList();
        }
        int size = this.fields.size();
        int i = 0;
        while (i < size) {
            Field4contents field = (Field4contents)this.fields.elementAt(i);
            if (field.contents instanceof byte[]) {
                this.putByteArray(field);
            } else if (field.contents instanceof Double) {
                this.putDouble(field);
            } else {
                throw new RuntimeException("unrecognized field type \"" + field.definition.getName() + "\"");
            }
            ++i;
        }
        switch (this.flushJ()) {
            case 0: {
                break;
            }
            case 50: {
                throw new Error4locked();
            }
            case -340: {
                throw new Error4unique();
            }
            default: {
                throw new Error4unexpected(this.cb.getLastError());
            }
        }
    }

    private native boolean f4null(String var1);

    private native void f4assignNull(String var1);

    private native byte[] f4binary(String var1);

    private native boolean deleteJ();

    protected void getByteArray(Field4contents f) {
        f.contents = f.definition == null ? (this.deleteJ() ? (Object)new byte[]{42} : (Object)new byte[]{32}) : (this.f4null(f.definition.getName()) ? null : (Object)this.f4binary(f.definition.getName()));
    }

    private native short f4assign(String var1, byte[] var2);

    private native short deleteJ(boolean var1);

    protected void putByteArray(Field4contents f) {
        if (f.definition == null) {
            if (((byte[])f.contents)[0] == 32) {
                this.deleteJ(false);
            } else {
                this.deleteJ(true);
            }
        } else if (f.contents == null) {
            this.f4assignNull(f.definition.getName());
        } else {
            this.f4assign(f.definition.getName(), (byte[])f.contents);
        }
    }

    private native double f4double(String var1);

    protected void getDouble(Field4contents f) {
        f.contents = this.f4null(f.definition.getName()) ? null : new Double(this.f4double(f.definition.getName()));
    }

    private native short f4assign(String var1, double var2);

    protected void putDouble(Field4contents f) {
        if (f.contents == null) {
            this.f4assignNull(f.definition.getName());
        } else {
            this.f4assign(f.definition.getName(), (Double)f.contents);
        }
    }

    private native boolean f4boolean(String var1);

    private native short f4assign(String var1, boolean var2);

    private native String f4str(String var1);

    private native short f4assign(String var1, String var2);

    private native String f4strUnicode(String var1);

    private native short f4assignUnicode(String var1, String var2);
}

