/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Data4;
import codebase.Error4field;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Field4define;
import java.io.IOException;

public abstract class Field4 {
    static final byte NULL_VALUE = 0;
    protected Data4 d4;
    protected Field4define definition;

    protected Field4(Data4 data) throws IOException, Error4usage, Error4unexpected, Error4field, Error4message {
        this.d4 = data;
        data.addField();
    }

    protected Field4(Data4 data, String fieldName, String validFieldTypes) throws IOException, Error4usage, Error4unexpected, Error4field, Error4message {
        if (data == null || fieldName == null || validFieldTypes == null) {
            throw new NullPointerException();
        }
        Field4define newField = new Field4define();
        this.d4 = data;
        this.definition = data.addField(fieldName, validFieldTypes);
    }

    public abstract void setBlank() throws IOException, Error4unexpected, Error4message;

    public final int decimals() {
        return this.definition.getDecimals();
    }

    public final int length() {
        return this.definition.getLength();
    }

    protected final short number() {
        return this.definition.getNumber();
    }

    public final String name() {
        return new String(this.definition.getName());
    }

    public char type() {
        return this.definition.getType();
    }
}

