/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Data4;
import codebase.Error4field;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Field4;
import java.io.IOException;

public class Field4boolean
extends Field4 {
    protected static final char TRUE_FLAG = 'T';
    protected static final char TRUE_FLAG_LOWER = 't';
    protected static final char YES_FLAG = 'Y';
    protected static final char YES_FLAG_LOWER = 'y';
    protected static final char FALSE_FLAG = 'F';
    protected static byte[] trueValue = new byte[1];
    protected static byte[] falseValue;

    static {
        Field4boolean.trueValue[0] = 84;
        falseValue = new byte[1];
        Field4boolean.falseValue[0] = 70;
    }

    public Field4boolean(Data4 data, String fieldName) throws IOException, Error4usage, Error4unexpected, Error4field, Error4message {
        super(data, fieldName, "CLW");
    }

    @Override
    public void setBlank() throws IOException, Error4unexpected, Error4message {
        this.set(new Boolean(false));
    }

    public Boolean get() throws IOException, Error4message, Error4unexpected {
        byte[] contents = (byte[])this.d4.getContents(this.definition.getNumber());
        if (contents == null) {
            return null;
        }
        char firstChar = this.type() == 'W' ? (char)(contents[0] << 8 | contents[1]) : (char)contents[0];
        switch (firstChar) {
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return new Boolean(true);
            }
        }
        return new Boolean(false);
    }

    public void set(Boolean newContents) throws IOException, Error4unexpected, Error4message {
        if (newContents == null) {
            this.d4.setContents(this.definition.getNumber(), null);
        }
        if (newContents.booleanValue()) {
            this.d4.setContents(this.definition.getNumber(), new byte[]{84});
        } else {
            this.d4.setContents(this.definition.getNumber(), new byte[]{70});
        }
    }

    public String toString() {
        try {
            return this.get().toString();
        }
        catch (Exception e) {
            return new String();
        }
    }
}

