/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Code4;
import codebase.Data4;
import codebase.Error4field;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Field4;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class Field4date
extends Field4 {
    protected static final short CENTURY_START = 0;
    protected static final short YEAR_START = 2;
    protected static final short YEAR_END = 4;
    protected static final short MONTH_START = 4;
    protected static final short MONTH_END = 6;
    protected static final short DAY_START = 6;
    protected static final short DAY_END = 8;
    protected static final int OLD_DAY = 1;
    protected static final int OLD_MONTH = 0;
    protected static final int OLD_YEAR = 70;
    protected static final int BLANK_DAY = 2;
    protected static final int BLANK_MONTH = 0;
    protected static final int BLANK_YEAR = 70;
    protected static Calendar OLD_CAL = Calendar.getInstance();
    protected static Calendar BLANK_CAL = Calendar.getInstance();
    protected static Date OLD_DATE;
    protected static Date BLANK_DATE;

    public Field4date(Data4 data, String fieldName) throws IOException, Error4usage, Error4unexpected, Error4field, Error4message {
        super(data, fieldName, "CD");
        OLD_CAL.set(1970, 0, 1);
        OLD_DATE = OLD_CAL.getTime();
        BLANK_CAL.set(1970, 0, 2);
        BLANK_DATE = BLANK_CAL.getTime();
    }

    @Override
    public void setBlank() throws IOException, Error4unexpected, Error4message {
        this.set(OLD_CAL.getTime());
    }

    public Date get() throws IOException, Error4message, Error4unexpected {
        byte[] contents = (byte[])this.d4.getContents(this.definition.getNumber());
        if (contents == null || contents.length < 1) {
            return null;
        }
        try {
            return Code4.stringToDate(new String(contents));
        }
        catch (Error4usage e) {
            return null;
        }
    }

    public void set(Date newContents) throws IOException, Error4message, Error4unexpected {
        if (newContents == null) {
            this.d4.setContents(this.definition.getNumber(), null);
        } else {
            this.d4.setContents(this.definition.getNumber(), Code4.dateToString(newContents).getBytes());
        }
    }

    public boolean isBlank() throws IOException, Error4unexpected, Error4message {
        return this.get().equals(BLANK_DATE);
    }

    public boolean isOld() throws IOException, Error4unexpected, Error4message {
        return this.get().equals(OLD_DATE);
    }

    public boolean isValid() throws IOException, Error4unexpected, Error4message {
        Date temp = this.get();
        return !temp.before(BLANK_DATE) && !temp.equals(BLANK_DATE);
    }

    public String toString() {
        try {
            return this.get().toString();
        }
        catch (Exception e) {
            return new String();
        }
    }
}

