/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Error4usage;

final class Field4define {
    private String name;
    private char type;
    private int length;
    private int decimals;
    private boolean allowNulls;
    private short number;

    Field4define() {
    }

    Field4define(String fieldName, char fieldType, int fieldLength, int fieldDecimals, boolean fieldAllowNulls) throws Error4usage {
        if (fieldName == null) {
            throw new NullPointerException();
        }
        if (fieldName.length() == 0) {
            throw new Error4usage("fieldName is empty");
        }
        if (fieldName.length() > 10) {
            throw new Error4usage("fieldName is too large; maximum is 10 characters");
        }
        this.name = new String(fieldName);
        switch (fieldType) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'G': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': 
            case 'W': {
                break;
            }
            default: {
                throw new Error4usage("Invalid field type");
            }
        }
        this.type = fieldType;
        switch (fieldType) {
            case 'B': 
            case 'G': 
            case 'M': {
                break;
            }
            case 'D': {
                this.length = 8;
                break;
            }
            case 'L': {
                this.length = 1;
                break;
            }
            case 'F': 
            case 'N': {
                if (fieldDecimals < 0) {
                    throw new Error4usage("Number of decimal places cannot be less than 0.");
                }
                this.decimals = fieldDecimals;
            }
            case 'C': 
            case 'W': {
                if (fieldLength < 1) {
                    throw new Error4usage("Field length cannot be less than 1.");
                }
                this.length = fieldLength;
            }
        }
        this.allowNulls = fieldAllowNulls;
    }

    final String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        this.name = new String(newName);
    }

    final char getType() {
        return this.type;
    }

    void setType(char newType) {
        this.type = newType;
    }

    final int getLength() {
        return this.length;
    }

    void setLength(int newLength) {
        this.length = newLength;
    }

    final int getDecimals() {
        return this.decimals;
    }

    void setDecimals(int newDecimals) {
        this.decimals = newDecimals;
    }

    final boolean getNulls() {
        return this.allowNulls;
    }

    final short getNumber() {
        return this.number;
    }

    void setNumber(short newNumber) {
        this.number = newNumber;
    }
}

