/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Data4;
import codebase.Error4field;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Field4stringBuffer;
import java.io.IOException;

public class Field4stringBufferUnicode
extends Field4stringBuffer {
    public Field4stringBufferUnicode(Data4 data, String fieldName) throws IOException, Error4usage, Error4unexpected, Error4field, Error4message {
        super(data, fieldName, "CBGML");
    }

    @Override
    public StringBuffer get() throws IOException, Error4message, Error4unexpected {
        byte[] contents = (byte[])this.d4.getContents(this.definition.getNumber());
        if (contents == null) {
            return null;
        }
        if (contents.length < 1) {
            return new StringBuffer();
        }
        int tempLength = contents.length / 2;
        StringBuffer temp = new StringBuffer(tempLength);
        int i = 0;
        while (i < 2 * tempLength) {
            if (contents[i] == 0 && contents[i + 1] == 0) break;
            temp.append((char)(contents[i] << 8 | contents[++i]));
            ++i;
        }
        return temp;
    }

    @Override
    public void set(StringBuffer newContents) throws IOException, Error4message, Error4unexpected {
        if (newContents == null) {
            this.d4.setContents(this.definition.getNumber(), null);
        } else if (newContents.length() < 1) {
            this.d4.setContents(this.definition.getNumber(), new byte[0]);
        } else {
            int numBytes = newContents.length() * 2;
            if (numBytes < this.length()) {
                numBytes = this.length();
            }
            char[] fieldBuffer = new char[newContents.length()];
            newContents.getChars(0, newContents.length(), fieldBuffer, 0);
            byte[] messageBuffer = new byte[numBytes];
            int i = 0;
            while (i < newContents.length()) {
                messageBuffer[2 * i] = (byte)(fieldBuffer[i] >>> 8 & 0xFF);
                messageBuffer[2 * i + 1] = (byte)(fieldBuffer[i] & 0xFF);
                ++i;
            }
            i *= 2;
            while (i < numBytes) {
                messageBuffer[i++] = 0;
            }
            this.d4.setContents(this.definition.getNumber(), messageBuffer);
        }
    }

    @Override
    public String toString() {
        try {
            return this.get().toString();
        }
        catch (Exception e) {
            return new String();
        }
    }
}

