/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Error4field;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Field4contents;
import codebase.Field4define;
import codebase.Field4info;
import codebase.Lock4;
import codebase.Socket4;
import codebase.Tag4define;
import codebase.Tag4info;
import java.io.IOException;
import java.util.Vector;

final class Message4 {
    private static final short STREAM4PING = 10050;
    private static final short JAVA4LOCK = 20100;
    private static final short JAVA4UNLOCK = 20200;
    private static final short JAVA4WRITE2 = 20350;
    private static final short JAVA4GO = 20400;
    private static final short JAVA4SKIP = 20500;
    private static final short JAVA4SEEK_N = 20600;
    private static final short JAVA4SEEK_DBL = 20650;
    private static final short JAVA4OPEN = 21100;
    private static final short JAVA4CLOSE = 21200;
    private static final short JAVA4REC_COUNT = 21300;
    public static final short JAVA4CONNECT = 21700;
    private static final short JAVA4DISCONNECT = 21800;
    private static final short JAVA4CREATE = 22200;
    private static final short JAVA4INDEX_CREATE = 23300;
    private static final short JAVA4INDEX_OPEN = 23400;
    private static final short JAVA4POSITION = 23600;
    private static final short JAVA4POSITION_SET = 23700;
    private static final short JAVA4TOP = 24000;
    private static final short JAVA4BOTTOM = 24100;
    private static final short JAVA4APPEND2 = 24250;
    private static final short JAVA4PACK = 22000;
    private static final short JAVA4REINDEX = 23800;
    private static final short JAVA4ACCESS_MODE = 28000;
    private static final short JAVA4BLANK = 28100;
    private static final short JAVA4DEFAULT_UNIQUE = 28200;
    private static final short JAVA4READ_LOCK = 28300;
    private static final short JAVA4READ_ONLY = 28400;
    private static final short JAVA4REC_NO = 28500;
    private static final short JAVA4REGISTER_FIELD = 28600;
    private static final short JAVA4SAFETY = 28700;
    private static final short JAVA4SELECT_DATA = 28800;
    private static final short JAVA4SELECT_TAG = 28900;
    private static final short JAVA4STATUS_CODE = 29000;
    private static final short JAVA4STATUS_FIELDS = 29100;
    private static final short JAVA4UNLOCK_AUTO = 29200;
    private static final short JAVA4GET_FIELD_INFO = 29300;
    private static final short JAVA4REFRESH = 29400;
    private static final byte CON4ACK_1 = 12;
    private static final byte CON4ACK_2 = 23;
    private static final byte PACKET4SIZE = 42;
    public static final short VERSION = 6501;
    private static final byte EMPTY_VALUE = 0;
    private static final byte NULL_VALUE = -1;
    private static final byte FULL_VALUE = -2;
    private static final byte SHORT_VALUE = -3;
    private static final byte INT_VALUE = -4;
    private static final byte UNCHANGED_VALUE = -5;
    private static final byte DOUBLE_VALUE = -6;
    private Socket4 commSocket = null;
    private int currentDataID;
    String errorMessage;
    byte[] errorBytes;

    Message4() {
    }

    protected synchronized void finalize() {
        if (this.commSocket != null) {
            this.commSocket = null;
        }
        if (this.commSocket != null) {
            this.commSocket = null;
        }
    }

    private synchronized short getStatus() throws IOException {
        this.commSocket.flush();
        short status = this.commSocket.readShort();
        if (status < 0) {
            short length = this.commSocket.readShort();
            this.errorBytes = new byte[length];
            if (length != 0) {
                this.commSocket.readBuffer(this.errorBytes);
                this.errorMessage = new String(this.errorBytes);
            }
        } else {
            this.errorMessage = new String();
        }
        return status;
    }

    private synchronized void sendFieldDefinitions(Vector fields) throws IOException {
        int numberFields = fields.size();
        this.commSocket.writeShort((short)numberFields);
        int i = 0;
        while (i < numberFields) {
            Field4define currentField = (Field4define)fields.elementAt(i);
            String temp = currentField.getName();
            this.commSocket.writeByte((byte)temp.length());
            this.commSocket.writeString(temp);
            this.commSocket.writeByte((byte)currentField.getType());
            this.commSocket.writeShort((short)currentField.getLength());
            this.commSocket.writeByte((byte)currentField.getDecimals());
            this.commSocket.writeByte((byte)(currentField.getNulls() ? 1 : 0));
            ++i;
        }
    }

    private synchronized void sendTags(Vector tags) throws IOException {
        int numberTags = tags == null ? 0 : tags.size();
        this.commSocket.writeShort((short)numberTags);
        int i = 0;
        while (i < numberTags) {
            Tag4define currentTag = (Tag4define)tags.elementAt(i);
            String temp = currentTag.getName();
            this.commSocket.writeByte((byte)temp.length());
            this.commSocket.writeString(temp);
            temp = currentTag.getExpression();
            this.commSocket.writeShort((short)temp.length());
            this.commSocket.writeString(temp);
            temp = currentTag.getFilter();
            if (temp == null) {
                this.commSocket.writeShort((short)0);
            } else {
                this.commSocket.writeShort((short)temp.length());
                this.commSocket.writeString(temp);
            }
            this.commSocket.writeShort(currentTag.getUnique());
            this.commSocket.writeShort(currentTag.getDescending());
            ++i;
        }
    }

    synchronized void ping(int sendAmount, int receiveAmount) throws IOException {
        this.commSocket.writeShort((short)10050);
        this.commSocket.writeInt(sendAmount);
        this.commSocket.writeInt(receiveAmount);
        if (sendAmount > 10) {
            byte[] b = new byte[sendAmount - 10];
            this.commSocket.writeBuffer(b);
        }
        if (receiveAmount > 0) {
            byte[] b2 = new byte[receiveAmount];
            this.commSocket.readBuffer(b2);
        }
    }

    synchronized void append(Vector activeFields) throws IOException {
        this.commSocket.writeShort((short)24250);
        int numberFields = activeFields.size();
        this.commSocket.writeShort((short)numberFields);
        int i = 0;
        while (i < numberFields) {
            Field4contents currentField = (Field4contents)activeFields.elementAt(i);
            this.commSocket.writeShort(currentField.getNumber());
            Object type = currentField.getType();
            if (type instanceof byte[]) {
                if (currentField.definition == null) {
                    this.sendField((byte[])currentField.contents, 1);
                } else {
                    this.sendField((byte[])currentField.contents, currentField.definition.getLength());
                }
            } else if (type instanceof Double) {
                this.sendFieldDouble((Double)currentField.contents);
            } else {
                throw new RuntimeException("unrecognized contents type");
            }
            ++i;
        }
    }

    synchronized void blank() throws IOException {
        this.commSocket.writeShort((short)28100);
    }

    synchronized void bottom() throws IOException {
        this.commSocket.writeShort((short)24100);
    }

    synchronized void close() throws IOException {
        this.commSocket.writeShort((short)21200);
    }

    synchronized void connect(String host, short port, String userName, String password) throws IOException, Error4unexpected {
        this.commSocket = new Socket4(host, port, userName, password);
    }

    synchronized short create(String dataFileName, Field4info dataFields, Tag4info indexTags, int[] dataIdReturn) throws IOException {
        this.commSocket.writeShort((short)22200);
        this.commSocket.writeShort((short)dataFileName.length());
        this.commSocket.writeString(dataFileName);
        this.sendFieldDefinitions(dataFields.getFields());
        if (indexTags != null) {
            this.sendTags(indexTags.getTags());
        } else {
            this.sendTags(null);
        }
        short status = this.getStatus();
        if (status == 0) {
            this.currentDataID = dataIdReturn[0] = this.commSocket.readInt();
        }
        return status;
    }

    synchronized boolean connected() {
        return this.commSocket != null;
    }

    synchronized void createIndex(String indexFileName, Tag4info indexTags) throws IOException {
        this.commSocket.writeShort((short)23300);
        if (indexFileName == null) {
            this.commSocket.writeShort((short)0);
        } else {
            this.commSocket.writeShort((short)indexFileName.length());
            this.commSocket.writeString(indexFileName);
        }
        this.sendTags(indexTags.getTags());
    }

    synchronized void disconnect() throws IOException {
        this.commSocket.writeShort((short)21800);
        this.commSocket.close();
        this.commSocket = null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized Field4define getFieldInfo(String fieldName) throws IOException, Error4field {
        short number;
        char type;
        byte decimals;
        short length;
        block7: {
            short s;
            short len;
            block6: {
                if (fieldName == null) {
                    throw new NullPointerException();
                }
                this.commSocket.writeShort((short)29300);
                this.commSocket.writeByte((byte)fieldName.length());
                this.commSocket.writeString(fieldName);
                short status = this.getStatus();
                if (status != 0) {
                    throw new Error4field(fieldName);
                }
                len = this.commSocket.readShort();
                length = this.commSocket.readShort();
                decimals = this.commSocket.readByte();
                type = (char)this.commSocket.readByte();
                number = this.commSocket.readShort();
                len = (short)(len - 6);
                if (!true) break block6;
                s = len;
                len = (short)(s - 1);
                if (s <= 0) break block7;
            }
            do {
                this.commSocket.readByte();
                s = len;
                len = (short)(s - 1);
            } while (s > 0);
        }
        try {
            Field4define def = new Field4define(fieldName, type, length, decimals, false);
            def.setNumber(number);
            return def;
        }
        catch (Error4usage e) {
            throw new RuntimeException("Error4usage thrown: " + e.toString());
        }
    }

    synchronized void go(int recordNumber) throws IOException {
        this.commSocket.writeShort((short)20400);
        this.commSocket.writeInt(recordNumber);
    }

    synchronized void lock(Vector dataLocks) throws IOException {
        this.commSocket.writeShort((short)20100);
        short numberLocks = (short)dataLocks.size();
        this.commSocket.writeShort(numberLocks);
        short i = 0;
        while (i < numberLocks) {
            Lock4 currentLock = (Lock4)dataLocks.elementAt(i);
            this.commSocket.writeInt(currentLock.getDataId());
            this.commSocket.writeInt(currentLock.getLockCode());
            i = (short)(i + 1);
        }
    }

    synchronized short open(String dataFileName, int[] dataIdReturn) throws IOException {
        this.commSocket.writeShort((short)21100);
        this.commSocket.writeShort((short)dataFileName.length());
        this.commSocket.writeString(dataFileName);
        short status = this.getStatus();
        if (status == 0) {
            this.currentDataID = dataIdReturn[0] = this.commSocket.readInt();
        }
        return status;
    }

    synchronized void openIndex(String indexFileName) throws IOException {
        this.commSocket.writeShort((short)23400);
        this.commSocket.writeShort((short)indexFileName.length());
        this.commSocket.writeString(indexFileName);
    }

    synchronized void pack() throws IOException {
        this.commSocket.writeShort((short)22000);
    }

    synchronized short position(double[] currentPosition) throws IOException {
        this.commSocket.writeShort((short)23600);
        short status = this.getStatus();
        if (status == 0) {
            currentPosition[0] = this.commSocket.readDouble();
        }
        return status;
    }

    synchronized void positionSet(double newPosition) throws IOException {
        this.commSocket.writeShort((short)23700);
        this.commSocket.writeDouble(newPosition);
    }

    synchronized short recCount(int[] recCountReturn) throws IOException {
        this.commSocket.writeShort((short)21300);
        short status = this.getStatus();
        if (status == 0) {
            recCountReturn[0] = this.commSocket.readInt();
        }
        return status;
    }

    synchronized byte[] receiveField(int fieldLength) throws IOException, Error4message {
        int length;
        byte lengthCode = this.commSocket.readByte();
        switch (lengthCode) {
            case -4: {
                length = this.commSocket.readInt();
                break;
            }
            case -3: {
                length = this.commSocket.readShort();
                break;
            }
            case -2: {
                length = fieldLength;
                if (length != 0) break;
                throw new Error4message("Field length encoding for variable length field");
            }
            case -1: {
                return null;
            }
            case 0: {
                return new byte[0];
            }
            default: {
                if (lengthCode > 0) {
                    length = lengthCode;
                    break;
                }
                throw new Error4message("Negative field length encoding");
            }
        }
        byte[] fieldValue = new byte[length];
        this.commSocket.readBuffer(fieldValue);
        return fieldValue;
    }

    synchronized short recNo(int[] recNoReturn) throws IOException {
        this.commSocket.writeShort((short)28500);
        short status = this.getStatus();
        if (status == 0) {
            recNoReturn[0] = this.commSocket.readInt();
        }
        return status;
    }

    synchronized void refreshFields(Vector activeFields) throws IOException, Error4unexpected, Error4message {
        Field4contents currentField;
        this.commSocket.writeShort((short)29400);
        int numberFields = activeFields.size();
        this.commSocket.writeInt(numberFields);
        int i = 0;
        while (i < numberFields) {
            currentField = (Field4contents)activeFields.elementAt(i);
            this.commSocket.writeShort(currentField.getNumber());
            ++i;
        }
        i = 0;
        while (i < numberFields) {
            currentField = (Field4contents)activeFields.elementAt(i);
            int length = currentField.definition == null ? 1 : currentField.definition.getLength();
            currentField.parseByteArray(this.receiveField(length));
            ++i;
        }
    }

    synchronized void reindex() throws IOException {
        this.commSocket.writeShort((short)23800);
    }

    synchronized void seek(double seekValue) throws IOException {
        this.commSocket.writeShort((short)20650);
        this.commSocket.writeDouble(seekValue);
    }

    synchronized void seek(String seekValue) throws IOException {
        this.commSocket.writeShort((short)20600);
        this.commSocket.writeShort((short)seekValue.length());
        this.commSocket.writeString(seekValue);
    }

    synchronized void seek(byte[] seekValue) throws IOException {
        this.commSocket.writeShort((short)20600);
        this.commSocket.writeShort((short)seekValue.length);
        this.commSocket.writeBuffer(seekValue);
    }

    synchronized void seekUnicode(String seekValue) throws IOException {
        this.commSocket.writeShort((short)20600);
        this.commSocket.writeShort((short)seekValue.length());
        this.commSocket.writeStringUnicode(seekValue);
    }

    synchronized void select(String tagName) throws IOException {
        this.commSocket.writeShort((short)28900);
        if (tagName == null) {
            this.commSocket.writeShort((short)0);
        } else {
            this.commSocket.writeShort((short)tagName.length());
            this.commSocket.writeString(tagName);
        }
    }

    synchronized void sendField(byte[] fieldValue, int fieldLength) throws IOException {
        if (fieldValue == null) {
            if (fieldLength == 0) {
                this.commSocket.writeByte((byte)-1);
            } else {
                this.commSocket.writeByte((byte)-5);
            }
            return;
        }
        if (fieldValue.length < 1) {
            this.commSocket.writeByte((byte)0);
            return;
        }
        if (fieldValue.length == fieldLength) {
            this.commSocket.writeByte((byte)-2);
        } else if (fieldValue.length < 128) {
            this.commSocket.writeByte((byte)fieldValue.length);
        } else if (fieldValue.length < 32768) {
            this.commSocket.writeByte((byte)-3);
            this.commSocket.writeShort((short)fieldValue.length);
        } else {
            this.commSocket.writeByte((byte)-4);
            this.commSocket.writeInt(fieldValue.length);
        }
        this.commSocket.writeBuffer(fieldValue);
    }

    synchronized void sendFieldDouble(Double fieldValue) throws IOException {
        if (fieldValue == null) {
            this.commSocket.writeByte((byte)-1);
        } else {
            this.commSocket.writeByte((byte)-6);
            this.commSocket.writeDouble(fieldValue);
        }
    }

    synchronized void setCurrentData(int dataID) throws IOException {
        if (this.currentDataID != dataID) {
            this.currentDataID = dataID;
            this.commSocket.writeShort((short)28800);
            this.commSocket.writeInt(dataID);
        }
    }

    synchronized void setAccessMode(byte newValue) throws IOException {
        this.commSocket.writeShort((short)28000);
        this.commSocket.writeByte(newValue);
    }

    synchronized void setDefaultUnique(byte newValue) throws IOException {
        this.commSocket.writeShort((short)28200);
        this.commSocket.writeByte(newValue);
    }

    synchronized void setReadLock(boolean newValue) throws IOException {
        this.commSocket.writeShort((short)28300);
        this.commSocket.writeByte((byte)(newValue ? 1 : 0));
    }

    synchronized void setReadOnly(boolean newValue) throws IOException {
        this.commSocket.writeShort((short)28400);
        this.commSocket.writeByte((byte)(newValue ? 1 : 0));
    }

    synchronized void setSafety(boolean newValue) throws IOException {
        this.commSocket.writeShort((short)28700);
        this.commSocket.writeByte((byte)(newValue ? 1 : 0));
    }

    synchronized void setUnlockAuto(byte newValue) throws IOException {
        this.commSocket.writeShort((short)29200);
        this.commSocket.writeByte(newValue);
    }

    synchronized void skip(int numberRecords) throws IOException {
        this.commSocket.writeShort((short)20500);
        this.commSocket.writeInt(numberRecords);
    }

    synchronized short statusCode() throws IOException {
        this.commSocket.writeShort((short)29000);
        return this.getStatus();
    }

    synchronized void top() throws IOException {
        this.commSocket.writeShort((short)24000);
    }

    synchronized void unlock() throws IOException {
        this.commSocket.writeShort((short)20200);
    }

    synchronized void update(Vector activeFields) throws IOException {
        this.commSocket.writeShort((short)20350);
        int numberFields = activeFields.size();
        this.commSocket.writeShort((short)numberFields);
        int i = 0;
        while (i < numberFields) {
            Field4contents currentField = (Field4contents)activeFields.elementAt(i);
            this.commSocket.writeShort(currentField.getNumber());
            Object type = currentField.getType();
            if (type instanceof byte[]) {
                int length = currentField.definition == null ? 1 : currentField.definition.getLength();
                this.sendField((byte[])currentField.contents, length);
            } else if (type instanceof Double) {
                this.sendFieldDouble((Double)currentField.contents);
            } else {
                throw new RuntimeException("unrecognized contents type");
            }
            ++i;
        }
    }
}

