/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Code4jni;
import codebase.Data4;
import codebase.Data4jni;
import codebase.Error4message;
import codebase.Error4relateMatch;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Relate4;
import java.util.Vector;

public class Relate4jni
extends Relate4 {
    private long RELATE4;

    private native long init(Data4 var1);

    public Relate4jni(Data4jni masterTable) throws Error4unexpected, NullPointerException {
        if (masterTable == null) {
            throw new NullPointerException();
        }
        this.RELATE4 = this.init(masterTable);
        if (this.RELATE4 == 0L) {
            throw new Error4unexpected(((Code4jni)masterTable.getCode4()).getLastError());
        }
        this.data = masterTable;
        this.master = null;
        this.topMaster = this;
        this.slaves = null;
    }

    private native long createSlave(Relate4jni var1, Data4jni var2, String var3, String var4);

    public Relate4jni(Relate4jni masterRel, Data4jni slaveTable, String masterExpr, String slaveTagName) throws Error4unexpected, Error4usage, Error4tagName, NullPointerException {
        if (masterRel == null) {
            throw new NullPointerException("masterRel is null");
        }
        if (slaveTable == null) {
            throw new NullPointerException("slaveTable is null");
        }
        slaveTable.openedCheck();
        if (masterExpr == null) {
            throw new NullPointerException("masterExpr is null");
        }
        if (slaveTagName == null) {
            throw new NullPointerException("slaveTagName is null");
        }
        this.RELATE4 = this.createSlave(masterRel, slaveTable, masterExpr, slaveTagName);
        if (this.RELATE4 == 0L) {
            short err = ((Code4jni)slaveTable.getCode4()).getLastError();
            if (err == -330) {
                throw new Error4tagName(slaveTagName);
            }
            throw new Error4unexpected(err);
        }
        this.data = slaveTable;
        this.master = masterRel;
        this.topMaster = masterRel.topMaster;
        this.slaves = null;
        if (this.master.slaves == null) {
            this.master.slaves = new Vector();
        }
        this.master.slaves.addElement(this);
    }

    @Override
    public synchronized native short bottom() throws Error4relateMatch;

    @Override
    public synchronized native void changed();

    @Override
    public synchronized native void doAll() throws Error4relateMatch;

    @Override
    public synchronized native void doOne() throws Error4relateMatch;

    @Override
    public synchronized native boolean eof();

    @Override
    public synchronized native void errorAction(short var1);

    private synchronized native short freeJ(long var1);

    @Override
    public void free() {
        if (this.topMaster != null) {
            this.freeJ(((Relate4jni)this.topMaster).RELATE4);
            Relate4jni.freeSlaves((Relate4jni)this.topMaster);
        }
    }

    protected static void freeSlaves(Relate4jni master) {
        if (master.slaves != null) {
            int i = master.slaves.size() - 1;
            while (i != 0) {
                Relate4jni.freeSlaves((Relate4jni)master.slaves.elementAt(i));
                --i;
            }
        }
        master.slaves = null;
        master.topMaster = null;
        master.master = null;
        master.RELATE4 = 0L;
    }

    @Override
    public synchronized native void lockAdd();

    @Override
    public synchronized native void matchLen(int var1);

    @Override
    public synchronized native boolean optimizeable();

    @Override
    public synchronized native void querySet(String var1);

    @Override
    public synchronized native short skip(int var1) throws Error4relateMatch;

    @Override
    public synchronized native void skipEnable();

    @Override
    public synchronized native void sortSet(String var1);

    @Override
    public synchronized native short top() throws Error4relateMatch;

    @Override
    public synchronized native void type(short var1);

    public void updateFields() throws Error4usage, Error4message {
        Relate4jni.updateSlaves(this.topMaster);
    }

    private static void updateSlaves(Relate4 rel) throws Error4usage, Error4message {
        rel.getData4().fieldsAreValid = false;
        if (rel.slaves != null) {
            int i = rel.slaves.size() - 1;
            while (i >= 0) {
                Relate4jni.updateSlaves((Relate4jni)rel.slaves.elementAt(i));
                --i;
            }
        }
    }
}

