/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Error4unexpected;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

final class Socket4 {
    private static final boolean S4HALFJAVA = true;
    private Socket read;
    private Socket write;
    private DataInputStream dataInStream;
    private DataOutputStream dataOutStream;
    private ServerSocket ss;

    Socket4(String host, int port, String userName, String password) throws UnknownHostException, IOException, Error4unexpected {
        this.write = new Socket(host, port);
        this.write.setTcpNoDelay(true);
        this.dataOutStream = new DataOutputStream(this.write.getOutputStream());
        this.writeInt(0);
        this.writeShort((short)21700);
        this.writeShort((short)this.write.getLocalPort());
        this.writeShort((short)6501);
        this.writeByte((byte)userName.length());
        this.writeString(userName);
        this.writeByte((byte)password.length());
        this.writeString(password);
        this.read = new Socket(host, port);
        DataOutputStream tempOut = new DataOutputStream(this.read.getOutputStream());
        tempOut.writeInt(-1);
        tempOut.writeShort((short)this.write.getLocalPort());
        this.read.setTcpNoDelay(true);
        this.dataInStream = new DataInputStream(this.read.getInputStream());
        short rc = this.readShort();
        if (rc != 0) {
            throw new Error4unexpected(rc);
        }
    }

    protected synchronized void finalize() throws IOException {
        this.close();
    }

    synchronized void close() throws IOException {
        if (this.dataOutStream != null) {
            this.dataOutStream.close();
            this.dataOutStream = null;
        }
        if (this.dataInStream != null) {
            this.dataInStream.close();
            this.dataInStream = null;
        }
        if (this.write != null) {
            this.write.close();
            this.write = null;
        }
        if (this.read != null) {
            this.read.close();
            this.read = null;
        }
    }

    void flush() {
    }

    synchronized void readBuffer(byte[] b) throws IOException, EOFException {
        this.dataInStream.readFully(b);
    }

    synchronized void writeBuffer(byte[] b) throws IOException, EOFException {
        this.dataOutStream.write(b, 0, b.length);
    }

    synchronized byte readByte() throws IOException {
        return this.dataInStream.readByte();
    }

    synchronized void writeByte(byte b) throws IOException {
        this.dataOutStream.writeByte(b);
    }

    synchronized double readDouble() throws IOException {
        return this.dataInStream.readDouble();
    }

    synchronized void writeDouble(double d) throws IOException {
        this.dataOutStream.writeDouble(d);
    }

    synchronized int readInt() throws IOException {
        return this.dataInStream.readInt();
    }

    synchronized void writeInt(int i) throws IOException {
        this.dataOutStream.writeInt(i);
    }

    synchronized short readShort() throws IOException {
        return this.dataInStream.readShort();
    }

    synchronized void writeShort(short s) throws IOException {
        this.dataOutStream.writeShort(s);
    }

    synchronized void writeString(String str) throws IOException {
        this.dataOutStream.writeBytes(str);
    }

    synchronized void writeStringUnicode(String str) throws IOException {
        this.dataOutStream.writeChars(str);
    }

    String getAddress() throws IOException {
        this.write.getInetAddress();
        return InetAddress.getLocalHost().getHostName();
    }
}

