/*
 * Decompiled with CFR 0.152.
 */
package codebase;

import codebase.Error4usage;

final class Tag4define {
    private String name;
    private String expression;
    private String filter;
    private byte unique;
    private byte descending;

    Tag4define(String tagName, String tagExpression, String tagFilter, byte tagUnique, boolean tagDescending) throws Error4usage {
        if (tagName == null) {
            throw new NullPointerException();
        }
        if (tagName.length() == 0) {
            throw new Error4usage("tagName is empty");
        }
        if (tagName.length() > 10) {
            throw new Error4usage("tagName is too large; maximum is 10 characters");
        }
        this.name = new String(tagName);
        if (tagExpression == null) {
            throw new NullPointerException();
        }
        if (tagExpression.length() == 0) {
            throw new Error4usage("tagExpression is empty");
        }
        this.expression = new String(tagExpression);
        if (tagFilter != null && tagFilter.length() > 0) {
            this.filter = new String(tagFilter);
        }
        switch (tagUnique) {
            case 0: 
            case 15: 
            case 20: 
            case 25: {
                break;
            }
            default: {
                throw new Error4usage("Invalid tag unique setting");
            }
        }
        this.unique = tagUnique;
        this.descending = tagDescending ? (byte)10 : (byte)0;
    }

    String getName() {
        return this.name;
    }

    String getExpression() {
        return this.expression;
    }

    String getFilter() {
        return this.filter;
    }

    byte getUnique() {
        return this.unique;
    }

    byte getDescending() {
        return this.descending;
    }
}

