/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.RatingException;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.data.cwmsRating.ICwmsRating;
import hec.data.cwmsRating.RatingSpec;
import hec.data.cwmsRating.RatingValue;
import hec.data.cwmsRating.TimeSeriesRater;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingJdbcCompatUtil;
import hec.data.cwmsRating.io.RatingXmlCompatUtil;
import hec.data.rating.IRatingSpecification;
import hec.data.rating.IRatingTemplate;
import hec.data.rating.JDomRatingSpecification;
import hec.hecmath.TimeSeriesMath;
import hec.io.TimeSeriesContainer;
import hec.util.TextUtil;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import rma.lang.Modifiable;

public abstract class AbstractRating
implements Observer,
ICwmsRating,
VerticalDatum,
Modifiable {
    protected static final Logger logger = Logger.getLogger(AbstractRating.class.getPackage().getName());
    protected hec.lang.Observable observationTarget = null;
    protected String officeId = null;
    protected RatingSpec ratingSpec = null;
    protected String ratingSpecId = null;
    protected String[] ratingParameters = null;
    protected String ratingUnitsId = null;
    protected String[] ratingUnits = null;
    protected String dataUnitsId = null;
    protected String[] dataUnits = null;
    protected long effectiveDate = Long.MIN_VALUE;
    protected long transitionStartDate = Long.MIN_VALUE;
    protected long createDate = Long.MIN_VALUE;
    protected boolean active = false;
    protected String description = null;
    protected VerticalDatumContainer vdc = null;
    protected long defaultValueTime = Long.MIN_VALUE;
    protected long ratingTime = Long.MAX_VALUE;
    protected boolean allowUnsafe = true;
    protected boolean warnUnsafe = true;
    protected TimeSeriesRater tsRater = null;
    private boolean modified = false;

    @Deprecated
    public static AbstractRating fromXml(String xmlText) throws RatingException {
        return RatingXmlCompatUtil.getInstance().fromXml(xmlText);
    }

    @Deprecated
    public static AbstractRating fromDatabase(Connection conn, String officeId, String ratingSpecId, Long effectiveDate) throws RatingException {
        RatingJdbcCompatUtil service = RatingJdbcCompatUtil.getInstance();
        return service.fromDatabase(conn, officeId, ratingSpecId, effectiveDate);
    }

    public static boolean compatibleUnits(String[] units1, String[] units2) {
        boolean compatible;
        block3: {
            compatible = false;
            if (units2.length == units1.length) {
                for (int i = 0; i < units1.length; ++i) {
                    if (units1[i].equals(units2[i]) || Units.canConvertBetweenUnits((String)units1[i], (String)units2[i])) {
                        continue;
                    }
                    break block3;
                }
                compatible = true;
            }
        }
        return compatible;
    }

    public static boolean compatibleUnits(String units1, String units2) {
        return AbstractRating.compatibleUnits(TextUtil.split((String)TextUtil.replaceAll((String)units1, (String)";", (String)",", (String)"L"), (String)",", (String)"L"), TextUtil.split((String)TextUtil.replaceAll((String)units2, (String)";", (String)",", (String)"L"), (String)",", (String)"L"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(Observer o) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.observationTarget.addObserver(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObserver(Observer o) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.observationTarget.deleteObserver(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRatingSpecId() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.ratingSpecId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOfficeId() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.officeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOfficeId(String officeId) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.officeId = officeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRatingSpecId(String ratingSpecId) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.ratingSpecId = ratingSpecId;
            if (ratingSpecId == null) {
                this.ratingParameters = null;
            } else {
                String[] parts = TextUtil.split((String)ratingSpecId, (String)".");
                this.ratingParameters = TextUtil.split((String)parts[1].replaceAll(";", ","), (String)",");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRatingUnitsId() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.ratingUnitsId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRatingUnitsId(String ratingUnitsId) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.ratingUnitsId = ratingUnitsId;
            this.ratingUnits = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataUnitsId() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.dataUnitsId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataUnitsId(String dataUnitsId) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            try {
                this.setDataUnits(TextUtil.split((String)TextUtil.replaceAll((String)dataUnitsId, (String)";", (String)","), (String)","));
            }
            catch (RatingException e) {
                logger.warning("Invalid data units string : " + dataUnitsId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.ratingSpecId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws RatingException {
        String[] parts = TextUtil.split((String)name, (String)".", (String)"L");
        if (parts.length != 4) {
            throw new RatingException(String.format("Invalid name: %s", name));
        }
        if ((parts = TextUtil.split((String)parts[1], (String)";", (String)"L")).length != 2) {
            throw new RatingException(String.format("Invalid name: %s", name));
        }
        String[] newIndParams = TextUtil.split((String)parts[0], (String)",", (String)"L");
        if (newIndParams.length != this.getIndParamCount()) {
            throw new RatingException("Name has different number of independent parameters than rating");
        }
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.ratingSpecId = name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRatingParameters() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            if (this.ratingParameters == null) {
                if (this.ratingSpecId == null) {
                    return null;
                }
                String parametersId = TextUtil.split((String)this.ratingSpecId, (String)".", (String)"L")[1];
                this.ratingParameters = TextUtil.split((String)TextUtil.replaceAll((String)parametersId, (String)";", (String)",", (String)"L"), (String)",", (String)"L");
            }
            return Arrays.copyOf(this.ratingParameters, this.ratingParameters.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRatingUnits() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            if (this.ratingUnits == null) {
                if (this.ratingUnitsId == null) {
                    return null;
                }
                this.ratingUnits = TextUtil.split((String)TextUtil.replaceAll((String)this.ratingUnitsId, (String)";", (String)",", (String)"L"), (String)",", (String)"L");
            }
            return Arrays.copyOf(this.ratingUnits, this.ratingUnits.length);
        }
    }

    public void setRatingUnits(String[] units) throws RatingException {
        if (units == null) {
            this.ratingUnits = null;
            return;
        }
        String[] parameters = this.getRatingParameters();
        if (parameters != null) {
            if (units.length != parameters.length) {
                throw new RatingException(String.format("Invalid number of rating units (%d units for %d parameters)", units.length, parameters.length));
            }
            Units parameterUnit = null;
            for (int i = 0; i < parameters.length; ++i) {
                try {
                    parameterUnit = new Parameter(parameters[i]).getUnits();
                }
                catch (Throwable t) {
                    if (!this.allowUnsafe) {
                        throw new RatingException(t);
                    }
                    if (this.warnUnsafe) {
                        logger.warning(t.getMessage());
                    }
                    parameterUnit = null;
                }
                if (parameterUnit == null || Units.canConvertBetweenUnits((String)units[i], (String)parameterUnit.toString())) continue;
                String msg = String.format("Cannot convert from \"%s\" to \"%s\".", units[i], parameterUnit.toString());
                if (!this.allowUnsafe) {
                    throw new RatingException(msg);
                }
                if (!this.warnUnsafe) continue;
                logger.warning(msg);
            }
        }
        this.setDataUnits(this.getDataUnits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDataUnits() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            if (this.dataUnits == null) {
                if (this.dataUnitsId == null) {
                    return this.getRatingUnits();
                }
                this.dataUnits = this.dataUnitsId == null ? this.getRatingUnits() : TextUtil.split((String)TextUtil.replaceAll((String)this.dataUnitsId, (String)";", (String)",", (String)"L"), (String)",", (String)"L");
            }
            return Arrays.copyOf(this.dataUnits, this.dataUnits.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataUnits(String[] units) throws RatingException {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            if (units == null) {
                this.dataUnitsId = null;
                this.dataUnits = null;
                return;
            }
            String[] ratingUnits = this.getRatingUnits();
            String[] parameters = this.getRatingParameters();
            if (ratingUnits == null ? parameters != null && units.length != parameters.length : units.length != ratingUnits.length) {
                throw new RatingException("Invalid number of data units.");
            }
            Units dataUnit = null;
            Units parameterUnit = null;
            for (int i = 0; i < units.length; ++i) {
                String msg;
                try {
                    dataUnit = new Units(units[i]);
                }
                catch (Throwable t) {
                    if (!this.allowUnsafe) {
                        throw new RatingException(t);
                    }
                    if (this.warnUnsafe) {
                        logger.warning(t.getMessage());
                    }
                    dataUnit = null;
                }
                if (dataUnit == null) continue;
                if (ratingUnits == null) {
                    try {
                        parameterUnit = new Parameter(parameters[i]).getUnits();
                    }
                    catch (Throwable t) {
                        if (!this.allowUnsafe) {
                            throw new RatingException(t);
                        }
                        if (this.warnUnsafe) {
                            logger.warning(t.getMessage());
                        }
                        parameterUnit = null;
                    }
                    if (parameterUnit == null || units[i].equals(parameterUnit.toString()) || Units.canConvertBetweenUnits((String)units[i], (String)parameterUnit.toString())) continue;
                    msg = String.format("Cannot convert from \"%s\" to \"%s\".", units[i], parameterUnit.toString());
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (!this.warnUnsafe) continue;
                    if (i == parameters.length - 1) {
                        logger.warning(msg + "  Rated values will be unconverted.");
                        continue;
                    }
                    logger.warning(msg + "  Rating will be performed using unconverted values.");
                    continue;
                }
                if (units[i].equals(ratingUnits[i]) || Units.canConvertBetweenUnits((String)units[i], (String)ratingUnits[i])) continue;
                msg = String.format("Cannot convert from \"%s\" to \"%s\".", units[i], ratingUnits[i]);
                if (!this.allowUnsafe) {
                    throw new RatingException(msg);
                }
                if (!this.warnUnsafe) continue;
                if (i == ratingUnits.length - 1) {
                    logger.warning(msg + "  Rated values will be unconverted.");
                    continue;
                }
                logger.warning(msg + "  Rating will be performed using unconverted values.");
            }
            StringBuilder sb = new StringBuilder(units[0]);
            for (int i = 1; i < units.length - 1; ++i) {
                sb.append(",").append(units[i]);
            }
            sb.append(";").append(units[units.length - 1]);
            this.dataUnitsId = sb.toString();
            this.dataUnits = Arrays.copyOf(units, units.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndParamCount() throws RatingException {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.getRatingParameters().length - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesAllowUnsafe() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.allowUnsafe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowUnsafe(boolean allowUnsafe) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.allowUnsafe = allowUnsafe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesWarnUnsafe() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.warnUnsafe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWarnUnsafe(boolean warnUnsafe) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.warnUnsafe = warnUnsafe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEffectiveDate() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.effectiveDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffectiveDate(long effectiveDate) throws RatingException {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.effectiveDate = effectiveDate;
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTransitionStartDate() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.transitionStartDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransitionStartDate(long transitionStartDate) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.transitionStartDate = transitionStartDate;
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCreateDate() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.createDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreateDate(long createDate) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.createDate = createDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActive(boolean active) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.active = active;
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDescription() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String description) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.description = description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDefaultValueTime() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.defaultValueTime == Long.MIN_VALUE ? System.currentTimeMillis() : this.defaultValueTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultValueTime(long defaultValueTime) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.defaultValueTime = defaultValueTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDefaultValuetime() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.defaultValueTime = Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRatingTime() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.ratingTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRatingTime(long ratingTime) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.ratingTime = ratingTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRatingTime() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.ratingTime = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getRatingExtents() throws RatingException {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.getRatingExtents(this.getRatingTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getEffectiveDates() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return new long[]{this.effectiveDate};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getCreateDates() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return new long[]{this.createDate};
        }
    }

    public abstract AbstractRatingContainer getData();

    public abstract void setData(AbstractRatingContainer var1) throws RatingException;

    public TimeSeriesContainer rate(TimeSeriesContainer tsc) throws RatingException {
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[]{tsc};
        return this.rate(tscs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeriesContainer rate(TimeSeriesContainer[] tscs) throws RatingException {
        if (this.tsRater == null) {
            this.tsRater = new TimeSeriesRater(this, this.allowUnsafe, this.warnUnsafe);
        }
        TimeSeriesRater timeSeriesRater = this.tsRater;
        synchronized (timeSeriesRater) {
            return this.tsRater.rate(tscs);
        }
    }

    public TimeSeriesMath rate(TimeSeriesMath tsm) throws RatingException {
        try {
            return new TimeSeriesMath(this.rate((TimeSeriesContainer)tsm.getData()));
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    public TimeSeriesMath rate(TimeSeriesMath[] tsms) throws RatingException {
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[tsms.length];
        try {
            for (int i = 0; i < tsms.length; ++i) {
                tscs[i] = (TimeSeriesContainer)tsms[i].getData();
            }
            return new TimeSeriesMath(this.rate(tscs));
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    public double reverseRate(double depVal) throws RatingException {
        long[] valTimes = new long[]{this.getDefaultValueTime()};
        double[] depVals = new double[]{depVal};
        return this.reverseRate(valTimes, depVals)[0];
    }

    public double[] reverseRate(double[] depVals) throws RatingException {
        long[] valTimes = new long[depVals.length];
        Arrays.fill(valTimes, this.getDefaultValueTime());
        return this.reverseRate(valTimes, depVals);
    }

    public double reverseRate(long valTime, double depVal) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[] depVals = new double[]{depVal};
        return this.reverseRate(valTimes, depVals)[0];
    }

    public double[] reverseRate(long valTime, double[] depVals) throws RatingException {
        long[] valTimes = new long[depVals.length];
        Arrays.fill(valTimes, valTime);
        return this.reverseRate(valTimes, depVals);
    }

    public abstract double[] reverseRate(long[] var1, double[] var2) throws RatingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeriesContainer reverseRate(TimeSeriesContainer tsc) throws RatingException {
        TimeSeriesRater timeSeriesRater = this.tsRater;
        synchronized (timeSeriesRater) {
            if (this.tsRater == null) {
                this.tsRater = new TimeSeriesRater(this, this.allowUnsafe, this.warnUnsafe);
            }
            return this.tsRater.reverseRate(tsc);
        }
    }

    public TimeSeriesMath reverseRate(TimeSeriesMath tsm) throws RatingException {
        try {
            return new TimeSeriesMath(this.reverseRate((TimeSeriesContainer)tsm.getData()));
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNativeVerticalDatum();
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getCurrentVerticalDatum();
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        AbstractRatingContainer arc = this.getData();
        boolean change = arc.toNativeVerticalDatum();
        try {
            this.setData(arc);
        }
        catch (RatingException e) {
            throw new VerticalDatumException((Throwable)e);
        }
        return change;
    }

    public boolean toNGVD29() throws VerticalDatumException {
        AbstractRatingContainer arc = this.getData();
        boolean change = arc.toNGVD29();
        try {
            this.setData(arc);
        }
        catch (RatingException e) {
            throw new VerticalDatumException((Throwable)e);
        }
        return change;
    }

    public boolean toNAVD88() throws VerticalDatumException {
        AbstractRatingContainer arc = this.getData();
        boolean change = arc.toNAVD88();
        try {
            this.setData(arc);
        }
        catch (RatingException e) {
            throw new VerticalDatumException((Throwable)e);
        }
        return change;
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        AbstractRatingContainer arc = this.getData();
        boolean change = arc.toVerticalDatum(datum);
        try {
            this.setData(arc);
        }
        catch (RatingException e) {
            throw new VerticalDatumException((Throwable)e);
        }
        return change;
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        AbstractRatingContainer arc = this.getData();
        boolean change = arc.forceVerticalDatum(datum);
        try {
            this.setData(arc);
        }
        catch (RatingException e) {
            throw new VerticalDatumException((Throwable)e);
        }
        return change;
    }

    public double getCurrentOffset() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getCurrentOffset();
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getCurrentOffset(unit);
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNGVD29Offset();
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNAVD88Offset();
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getVerticalDatumInfo();
    }

    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        if (this.vdc == null && xmlStr != null) {
            this.vdc = new VerticalDatumContainer(xmlStr);
        } else if (xmlStr == null || xmlStr.trim().length() == 0) {
            this.vdc = null;
        } else {
            this.vdc.setVerticalDatumInfo(xmlStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getData(AbstractRatingContainer arc) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            arc.officeId = this.officeId;
            arc.ratingSpecId = this.ratingSpecId;
            arc.unitsId = this.ratingUnitsId;
            arc.effectiveDateMillis = this.effectiveDate;
            arc.transitionStartDateMillis = this.transitionStartDate;
            arc.createDateMillis = this.createDate;
            arc.active = this.active;
            arc.description = this.description;
            if (this.vdc != null) {
                arc.setVerticalDatumContainer(this.vdc.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _setData(AbstractRatingContainer arc) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.officeId = arc.officeId;
            this.ratingSpecId = arc.ratingSpecId;
            this.ratingUnitsId = arc.unitsId;
            this.effectiveDate = arc.effectiveDateMillis;
            this.transitionStartDate = arc.transitionStartDateMillis;
            this.createDate = arc.createDateMillis;
            this.active = arc.active;
            this.description = arc.description;
            if (arc.getVerticalDatumContainer() != null) {
                this.vdc = arc.getVerticalDatumContainer().clone();
            }
        }
    }

    protected double convertUnits(double val, String fromUnit, String toUnit) throws RatingException {
        if (fromUnit != null && toUnit != null) {
            try {
                val = Units.convertUnits((double)val, (String)fromUnit, (String)toUnit);
            }
            catch (UnitsConversionException e) {
                throw new RatingException((Throwable)e);
            }
        }
        return val;
    }

    public abstract RatingValue[] getValues(Integer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRatingSpecification getRatingSpecification() throws DataSetException {
        String officeId2 = null;
        String ratingSpecId2 = null;
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            officeId2 = this.getOfficeId();
            ratingSpecId2 = this.getRatingSpecId();
        }
        JDomRatingSpecification ratingSpecification = new JDomRatingSpecification(officeId2, ratingSpecId2);
        return ratingSpecification;
    }

    public IRatingTemplate getRatingTemplate() throws DataSetException {
        IRatingSpecification ratingSpecification = this.getRatingSpecification();
        IRatingTemplate ratingTemplate = ratingSpecification.getTemplate();
        return ratingTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            return this.modified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModified(boolean bool) {
        AbstractRating abstractRating = this;
        synchronized (abstractRating) {
            this.modified = bool;
        }
    }

    public abstract AbstractRating getInstance(AbstractRatingContainer var1) throws RatingException;

    public static Logger getLogger() {
        return logger;
    }

    @Deprecated
    public void storeToDatabase(Connection conn, boolean overwriteExisting) throws RatingException {
        RatingJdbcCompatUtil service = RatingJdbcCompatUtil.getInstance();
        service.storeToDatabase(this, conn, overwriteExisting);
    }

    public boolean hasVerticalDatum() {
        return this.vdc != null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    @Deprecated
    public abstract String toXmlString(CharSequence var1, int var2) throws RatingException;

    public VerticalDatumContainer getVerticalDatumContainer() {
        return this.vdc;
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) {
        this.vdc = vdc;
    }
}

