/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.DataSetException;
import hec.data.IRating;
import hec.data.Parameter;
import hec.data.RatingException;
import hec.data.RatingObjectDoesNotExistException;
import hec.data.Units;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.CwmsRatingSet;
import hec.data.cwmsRating.ICwmsRating;
import hec.data.cwmsRating.RatingConst;
import hec.data.cwmsRating.RatingSet;
import hec.data.cwmsRating.RatingSpec;
import hec.data.cwmsRating.RatingUtil;
import hec.data.cwmsRating.SourceRating;
import hec.data.cwmsRating.TransitionalRating;
import hec.data.cwmsRating.UsgsStreamTableRating;
import hec.data.cwmsRating.VirtualRating;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.IndependentValuesContainer;
import hec.data.cwmsRating.io.RatingSetContainer;
import hec.data.cwmsRating.io.RatingSetStateContainer;
import hec.data.rating.IRatingSpecification;
import hec.data.rating.IRatingTemplate;
import hec.heclib.util.HecTime;
import hec.hecmath.TimeSeriesMath;
import hec.io.Conversion;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.Observable;
import hec.util.TextUtil;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Observer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public abstract class AbstractRatingSet
extends RatingSet
implements CwmsRatingSet {
    protected static final Logger LOGGER = Logger.getLogger(AbstractRatingSet.class.getPackage().getName());
    protected static boolean alwaysAllowUnsafe = true;
    protected static boolean alwaysWarnUnsafe = true;
    protected Observable observationTarget = null;
    protected RatingSpec ratingSpec = null;
    protected String[] dataUnits = null;
    protected TreeMap<Long, AbstractRating> ratings = new TreeMap();
    protected TreeMap<Long, AbstractRating> activeRatings = new TreeMap();
    protected long defaultValueTime = Long.MIN_VALUE;
    protected long ratingTime = Long.MAX_VALUE;
    protected boolean allowUnsafe = alwaysAllowUnsafe;
    protected boolean warnUnsafe = alwaysWarnUnsafe;

    protected AbstractRatingSet() {
        this.observationTarget = new Observable();
    }

    public static boolean getAlwaysAllowUnsafe() {
        return alwaysAllowUnsafe;
    }

    public static void setAlwaysAllowUnsafe(Boolean alwaysAllowUnsafe) {
        AbstractRatingSet.alwaysAllowUnsafe = alwaysAllowUnsafe;
    }

    public static boolean getAlwaysWarnUnsafe() {
        return alwaysWarnUnsafe;
    }

    public static void setAlwaysWarnUnsafe(Boolean alwaysWarnUnsafe) {
        AbstractRatingSet.alwaysWarnUnsafe = alwaysWarnUnsafe;
    }

    private static void getAllRatingSpecs(HashMap<String, Object[]> specMap, Iterable<AbstractRating> ratings, String path) throws RatingException {
        if (specMap == null) {
            throw new RatingException("Cannot use a null specMap parameter");
        }
        for (AbstractRating r : ratings) {
            RatingSpec spec;
            String thisPath = path + "/" + r.getRatingSpecId();
            if (r instanceof VirtualRating) {
                VirtualRating vr = (VirtualRating)r;
                for (SourceRating sr : vr.getSourceRatings()) {
                    if (sr.ratings == null) continue;
                    AbstractRatingSet.getAllRatingSpecs(specMap, Arrays.asList(sr.ratings.getRatings()), thisPath);
                }
            } else if (r instanceof TransitionalRating) {
                TransitionalRating tr = (TransitionalRating)r;
                for (SourceRating sr : tr.getSourceRatings()) {
                    if (sr.ratings == null) continue;
                    AbstractRatingSet.getAllRatingSpecs(specMap, Arrays.asList(sr.ratings.getRatings()), thisPath);
                }
            }
            if ((spec = r.ratingSpec) == null) continue;
            String specId = spec.getRatingSpecId();
            if (specMap.containsKey(specId)) {
                if (spec.equals(specMap.get(specId)[1])) continue;
                throw new RatingException("Ratings contain multiple definitions of rating spec \"" + specId + "\"");
            }
            specMap.put(specId, new Object[]{thisPath, spec});
        }
    }

    @Override
    public final void addRating(AbstractRating rating) throws RatingException {
        this.addRatings(Arrays.asList(rating));
    }

    @Override
    public final void addRatings(AbstractRating[] ratings) throws RatingException {
        this.addRatings(Arrays.asList(ratings));
    }

    @Override
    public synchronized void addRatings(Iterable<AbstractRating> ratings) throws RatingException {
        String ratingSpecId = null;
        String unitsId = null;
        for (AbstractRating rating : ratings) {
            if (rating.getEffectiveDate() == Long.MIN_VALUE) {
                throw new RatingException("Cannot add rating with undefined effective date.");
            }
            if (this.ratings.containsKey(rating.getEffectiveDate())) {
                throw new RatingException("Rating with same effective date already exists; cannot add rating");
            }
            if (this.ratingSpec != null && rating.getIndParamCount() != this.ratingSpec.getIndParamCount()) {
                throw new RatingException("Number of independent parameters does not match rating specification");
            }
            if (ratingSpecId == null) {
                ratingSpecId = rating.getRatingSpecId();
            } else if (!rating.getRatingSpecId().equals(ratingSpecId)) {
                throw new RatingException("Ratings have inconsistent rating specifications.");
            }
            if (unitsId == null) {
                unitsId = rating.getRatingUnitsId();
                continue;
            }
            if (AbstractRating.compatibleUnits(unitsId, rating.getRatingUnitsId())) continue;
            throw new RatingException(String.format("Rating units of \"%s\" aren't compatible with rating units of \"%s\"", rating.getRatingUnitsId(), unitsId));
        }
        HashMap<String, Object[]> newSpecs = new HashMap<String, Object[]>();
        AbstractRatingSet.getAllRatingSpecs(newSpecs, ratings, "");
        if (this.ratings.size() > 0) {
            if (!this.ratings.firstEntry().getValue().getRatingSpecId().equals(ratingSpecId)) {
                throw new RatingException("Cannot add ratings with different rating specification IDs");
            }
            HashMap<String, Object[]> oldSpecs = new HashMap<String, Object[]>();
            AbstractRatingSet.getAllRatingSpecs(oldSpecs, this.ratings.values(), "");
            for (String specId : oldSpecs.keySet()) {
                if (!newSpecs.containsKey(specId) || newSpecs.get(specId)[1].equals(oldSpecs.get(specId)[1])) continue;
                StringBuilder sb = new StringBuilder("Cannot add ratings with different rating template or specification definitions.\n");
                sb.append("Existing :").append((String)oldSpecs.get(specId)[0]).append("\n").append("Incoming :").append((String)newSpecs.get(specId)[0]).append("\n");
                String oldXml = ((RatingSpec)oldSpecs.get(specId)[1]).toTemplateXml("  ", 3);
                String newXml = ((RatingSpec)newSpecs.get(specId)[1]).toTemplateXml("  ", 3);
                if (!newXml.equals(oldXml)) {
                    sb.append("Definitions for template \"").append(((RatingSpec)oldSpecs.get(specId)[1]).getTemplateId()).append("\" differ.\nExisting Definition :\n").append(oldXml).append("New Definition :\n").append(newXml);
                }
                oldXml = ((RatingSpec)oldSpecs.get(specId)[1]).toSpecXml("  ", 3);
                newXml = ((RatingSpec)newSpecs.get(specId)[1]).toSpecXml("  ", 3);
                if (!newXml.equals(oldXml)) {
                    sb.append("Definitions for specification \"").append(((RatingSpec)oldSpecs.get(specId)[1]).getRatingSpecId()).append("\"differ.\nExisting Definition :\n").append(oldXml).append("New Definition :\n").append(newXml);
                }
                throw new RatingException(sb.toString());
            }
            if (!AbstractRating.compatibleUnits(unitsId, this.ratings.firstEntry().getValue().getRatingUnitsId())) {
                throw new RatingException(String.format("Rating units of \"%s\" aren't compatible with rating units of \"%s\"", unitsId, this.ratings.firstEntry().getValue().getRatingUnitsId()));
            }
        }
        for (AbstractRating rating : ratings) {
            if (rating instanceof UsgsStreamTableRating) {
                UsgsStreamTableRating streamRating = (UsgsStreamTableRating)rating;
                if (streamRating.shifts != null) {
                    streamRating.shifts.getRatingSpec().inRangeMethod = this.ratingSpec.inRangeMethod;
                }
            }
            if (rating instanceof VirtualRating) {
                VirtualRating vr = (VirtualRating)rating;
                if (vr.isNormalized()) {
                    this.ratings.put(rating.getEffectiveDate(), vr);
                } else {
                    this.ratings.put(rating.getEffectiveDate(), vr.normalizedCopy());
                }
            } else {
                this.ratings.put(rating.getEffectiveDate(), rating);
            }
            AbstractRating ar = this.ratings.get(rating.getEffectiveDate());
            ar.ratingSpec = this.ratingSpec;
            ar.setDefaultValueTime(this.getDefaultValueTime());
            ar.setRatingTime(this.getRatingTime());
            ar.setDataUnits(this.getDataUnits());
            try {
                ar.setVerticalDatumInfo(this.getVerticalDatumInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ar.setAllowUnsafe(this.doesAllowUnsafe());
            ar.setWarnUnsafe(this.doesWarnUnsafe());
            if (rating.isActive() && rating.createDate <= this.ratingTime) {
                this.activeRatings.put(rating.getEffectiveDate(), rating);
                this.activeRatings.get((Object)Long.valueOf((long)rating.getEffectiveDate())).ratingSpec = this.ratingSpec;
            }
            rating.deleteObserver(this);
            rating.addObserver(this);
            this.validate();
        }
        if (this.observationTarget != null) {
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    @Override
    public final synchronized void removeRating(long effectiveDate) throws RatingException {
        ICwmsRating cwmsRating = this.ratings.get(effectiveDate);
        if (cwmsRating == null) {
            throw new RatingException("Rating with specified effective date does not exist; cannot remove rating");
        }
        cwmsRating.deleteObserver(this);
        this.ratings.remove(effectiveDate);
        if (this.activeRatings.containsKey(effectiveDate)) {
            this.activeRatings.remove(effectiveDate);
        }
        if (this.observationTarget != null) {
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    @Override
    public final synchronized void removeAllRatings() {
        for (ICwmsRating iCwmsRating : this.ratings.values()) {
            iCwmsRating.deleteObserver(this);
        }
        this.ratings.clear();
        this.activeRatings.clear();
        if (this.observationTarget != null) {
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    @Override
    public final synchronized void replaceRating(AbstractRating rating) throws RatingException {
        Long effectiveDate = rating.getEffectiveDate();
        if (!this.ratings.containsKey(effectiveDate)) {
            throw new RatingException("Rating with same effective date does not exist; cannot replace rating");
        }
        if (this.ratingSpec != null && rating.getIndParamCount() != this.ratingSpec.getIndParamCount()) {
            throw new RatingException("Number of independent parameters does not match rating specification");
        }
        if (!rating.getRatingSpecId().equals(this.ratings.firstEntry().getValue().getRatingSpecId())) {
            throw new RatingException("Cannot replace rating with different rating specification.");
        }
        if (!rating.getRatingUnitsId().equals(this.ratings.firstEntry().getValue().getRatingUnitsId())) {
            throw new RatingException("Cannot replace rating with different units.");
        }
        rating.ratingSpec = this.ratingSpec;
        rating.setDataUnits(this.getDataUnits());
        rating.setDefaultValueTime(this.getDefaultValuetime());
        rating.setRatingTime(this.getRatingTime());
        rating.setName(this.getName());
        rating.setAllowUnsafe(this.doesAllowUnsafe());
        rating.setWarnUnsafe(this.doesWarnUnsafe());
        for (AbstractRating r : this.ratings.values()) {
            if (r.getVerticalDatumContainer() == null) continue;
            try {
                rating.setVerticalDatumInfo(r.getVerticalDatumInfo());
                break;
            }
            catch (VerticalDatumException ex) {
                throw new RatingException((Throwable)ex);
            }
        }
        this.ratings.put(effectiveDate, rating).deleteObserver(this);
        if (rating.isActive()) {
            this.activeRatings.put(effectiveDate, rating);
        }
        rating.deleteObserver(this);
        rating.addObserver(this);
        this.validate();
        if (this.observationTarget != null) {
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    @Override
    public final synchronized void replaceRatings(AbstractRating[] ratings) throws RatingException {
        this.replaceRatings(Arrays.asList(ratings));
    }

    @Override
    public synchronized void replaceRatings(Iterable<AbstractRating> ratings) throws RatingException {
        String ratingSpecId = null;
        String unitsId = null;
        for (AbstractRating rating : ratings) {
            if (!this.ratings.containsKey(rating.getEffectiveDate())) {
                throw new RatingException("Rating with same effective date does not exist; cannot replace rating");
            }
            if (this.ratingSpec != null && rating.getIndParamCount() != this.ratingSpec.getIndParamCount()) {
                throw new RatingException("Number of independent parameters does not match rating specification");
            }
            if (ratingSpecId == null) {
                ratingSpecId = rating.getRatingSpecId();
            } else if (!rating.getRatingSpecId().equals(ratingSpecId)) {
                throw new RatingException("Ratings have inconsistent rating specifications.");
            }
            if (unitsId == null) {
                unitsId = rating.getRatingUnitsId();
                continue;
            }
            if (rating.getRatingUnitsId().equals(unitsId)) continue;
            throw new RatingException("Ratings have inconsistent units.");
        }
        if (!this.ratings.firstEntry().getValue().getRatingSpecId().equals(ratingSpecId)) {
            throw new RatingException("Cannot replace ratings with different rating specification.");
        }
        if (!this.ratings.firstEntry().getValue().getRatingUnitsId().equals(unitsId)) {
            throw new RatingException("Cannot replace ratings with different units.");
        }
        for (AbstractRating rating : ratings) {
            this.ratings.put(rating.getEffectiveDate(), rating).deleteObserver(this);
            if (rating.isActive() && rating.createDate <= this.ratingTime) {
                this.activeRatings.put(rating.getEffectiveDate(), rating);
            }
            rating.deleteObserver(this);
            rating.addObserver(this);
        }
        this.validate();
        if (this.observationTarget != null) {
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    @Override
    public final double rate(double value, long valueTime) throws RatingException {
        double[] values = new double[]{value};
        return this.rate(values, valueTime)[0];
    }

    @Override
    public final double[] rate(double[] values, long valueTime) throws RatingException {
        long[] valueTimes = new long[values.length];
        Arrays.fill(valueTimes, valueTime);
        return this.rateOne(values, valueTimes);
    }

    @Override
    public final double[] rateOne(double[] values, long[] valueTimes) throws RatingException {
        double[][] valueSets = new double[values.length][1];
        for (int i = 0; i < values.length; ++i) {
            valueSets[i][0] = values[i];
        }
        return this.rate(valueSets, valueTimes);
    }

    @Override
    public final double rateOne(double[] valueSet, long valueTime) throws RatingException {
        double[][] valueSets = new double[][]{valueSet};
        long[] valueTimes = new long[]{valueTime};
        return this.rate(valueSets, valueTimes)[0];
    }

    @Override
    public synchronized double[] rate(double[][] valueSets, long[] valueTimes) throws RatingException {
        double[] Y = new double[valueSets.length];
        int activeRatingCount = this.activeRatings.size();
        if (activeRatingCount == 0) {
            throw new RatingException("No active ratings.");
        }
        if (valueSets.length != valueTimes.length) {
            throw new RatingException("Values and times have different lengths");
        }
        for (int i = 1; i < valueSets.length; ++i) {
            if (valueSets[i].length != valueSets[0].length) {
                throw new RatingException("Value sets are not all of same length.");
            }
            if (valueSets[i].length == this.ratings.firstEntry().getValue().getIndParamCount()) continue;
            throw new RatingException("Value sets have different parameter counts than ratings.");
        }
        if (this.getDataUnits() == null) {
            Map.Entry<Long, AbstractRating> entry1 = this.ratings.firstEntry();
            Map.Entry<Long, AbstractRating> entry2 = this.ratings.higherEntry(entry1.getKey());
            while (entry2 != null) {
                if (!entry1.getValue().getRatingUnitsId().equalsIgnoreCase(entry2.getValue().getRatingUnitsId())) {
                    throw new RatingException("Data units must be specified when rating set has multiple rating units.");
                }
                entry1 = entry2;
                entry2 = this.ratings.higherEntry(entry1.getKey());
            }
        }
        Map.Entry<Long, AbstractRating> lowerRating = null;
        Map.Entry<Long, AbstractRating> upperRating = null;
        IRating lastUsedRating = null;
        RatingConst.RatingMethod method = null;
        block22: for (int i = 0; i < valueSets.length; ++i) {
            if (i > 0 && valueTimes[i] == valueTimes[i - 1] && lastUsedRating != null) {
                Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                continue;
            }
            lowerRating = this.activeRatings.floorEntry(valueTimes[i]);
            upperRating = this.activeRatings.ceilingEntry(valueTimes[i]);
            if (lowerRating == null) {
                method = this.ratingSpec.getOutRangeLowMethod();
                switch (method) {
                    case ERROR: {
                        throw new RatingException("Effective date is before earliest rating");
                    }
                    case NULL: {
                        Y[i] = -3.4028234663852886E38;
                        lastUsedRating = null;
                        continue block22;
                    }
                    case NEXT: 
                    case NEAREST: 
                    case HIGHER: 
                    case CLOSEST: {
                        lastUsedRating = this.activeRatings.firstEntry().getValue();
                        Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                        continue block22;
                    }
                    default: {
                        if (this.activeRatings.size() == 1) {
                            throw new RatingException(String.format("Cannot use rating method %s with only one active rating.", new Object[]{method}));
                        }
                        lowerRating = this.activeRatings.firstEntry();
                        upperRating = this.activeRatings.higherEntry(lowerRating.getKey());
                    }
                }
            }
            if (upperRating == null) {
                method = this.ratingSpec.getOutRangeHighMethod();
                switch (method) {
                    case ERROR: {
                        throw new RatingException("Effective date is after latest rating");
                    }
                    case NULL: {
                        Y[i] = -3.4028234663852886E38;
                        lastUsedRating = null;
                        continue block22;
                    }
                    case NEAREST: 
                    case CLOSEST: 
                    case PREVIOUS: 
                    case LOWER: {
                        lastUsedRating = this.activeRatings.lastEntry().getValue();
                        Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                        continue block22;
                    }
                    default: {
                        if (this.activeRatings.size() == 1) {
                            switch (method) {
                                case LINEAR: {
                                    lastUsedRating = this.activeRatings.lastEntry().getValue();
                                    Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                                    continue block22;
                                }
                                default: {
                                    throw new RatingException(String.format("Cannot use rating method %s with only one active rating.", new Object[]{method}));
                                }
                            }
                        }
                        upperRating = this.activeRatings.lastEntry();
                        lowerRating = this.activeRatings.lowerEntry(upperRating.getKey());
                    }
                }
            }
            if (lowerRating.getKey() == valueTimes[i]) {
                Y[i] = lowerRating.getValue().rateOne(valueTimes[i], valueSets[i]);
                continue;
            }
            if (upperRating.getKey() == valueTimes[i]) {
                lastUsedRating = upperRating.getValue();
                Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                continue;
            }
            switch (this.ratingSpec.getInRangeMethod()) {
                case ERROR: {
                    throw new RatingException("Effective date is between existing rating");
                }
                case NULL: {
                    Y[i] = -3.4028234663852886E38;
                    lastUsedRating = null;
                    continue block22;
                }
                case PREVIOUS: 
                case LOWER: {
                    lastUsedRating = lowerRating.getValue();
                    Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                    continue block22;
                }
                case NEXT: 
                case HIGHER: {
                    lastUsedRating = upperRating.getValue();
                    Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                    continue block22;
                }
                case CLOSEST: {
                    lastUsedRating = valueTimes[i] - lowerRating.getKey() < upperRating.getKey() - valueTimes[i] ? (IRating)lowerRating.getValue() : (IRating)upperRating.getValue();
                    Y[i] = lastUsedRating.rateOne(valueTimes[i], valueSets[i]);
                    continue block22;
                }
                default: {
                    method = this.ratingSpec.getInRangeMethod();
                    lastUsedRating = null;
                    long transitionStartMillis = upperRating.getValue().getTransitionStartDate();
                    long t = valueTimes[i];
                    long t1 = lowerRating.getKey();
                    long t2 = upperRating.getKey();
                    double Y1 = lowerRating.getValue().rateOne(valueTimes[i], valueSets[i]);
                    double Y2 = upperRating.getValue().rateOne(valueTimes[i], valueSets[i]);
                    if (Y1 == -3.4028234663852886E38 || Y2 == -3.4028234663852886E38) {
                        Y[i] = -3.4028234663852886E38;
                        continue block22;
                    }
                    double y1 = Y1;
                    double y2 = Y2;
                    if (lowerRating.getValue() instanceof UsgsStreamTableRating) {
                        t1 = ((UsgsStreamTableRating)lowerRating.getValue()).getLatestEffectiveDate(t2);
                    }
                    if (transitionStartMillis > t1 && transitionStartMillis < t2) {
                        t1 = transitionStartMillis;
                    }
                    Y[i] = y1;
                    if (t <= t1) continue block22;
                    int n = i;
                    Y[n] = Y[n] + ((double)t - (double)t1) / (double)(t2 - t1) * (y2 - y1);
                }
            }
        }
        return Y;
    }

    @Override
    public final TimeSeriesContainer rate(TimeSeriesContainer tsc) throws RatingException {
        return this.rate(tsc, null);
    }

    @Override
    public final synchronized TimeSeriesContainer rate(TimeSeriesContainer tsc, String ratedUnitStr) throws RatingException {
        if (this.ratingSpec.getIndParamCount() != 1) {
            throw new RatingException(String.format("Cannot rate a TimeSeriesContainer with a rating that has %d independent parameters", this.ratingSpec.getIndParamCount()));
        }
        if (this.ratings.size() == 0) {
            throw new RatingException("No ratings.");
        }
        String[] units = this.getRatingUnits();
        String[] params = this.ratingSpec.getIndParameters();
        if (ratedUnitStr == null || ratedUnitStr.length() == 0) {
            ratedUnitStr = units[units.length - 1];
        }
        try {
            String msg;
            boolean convertRatedUnit;
            boolean convertTscUnit;
            Units ratedUnit;
            TimeZone tz;
            block43: {
                Units tscUnit;
                Parameter tscParam;
                block42: {
                    block41: {
                        tz = null;
                        if (tsc.timeZoneID != null && !(tz = TimeZone.getTimeZone(tsc.timeZoneID)).getID().equals(tsc.timeZoneID)) {
                            String msg2 = String.format("TimeSeriesContainer has invalid time zone \"%s\".", tsc.timeZoneID);
                            if (!this.allowUnsafe) {
                                throw new RatingException(msg2);
                            }
                            if (this.warnUnsafe) {
                                LOGGER.warning(msg2 + "  Value times will be treated as UTC.");
                            }
                            tz = null;
                        }
                        tscParam = null;
                        tscUnit = null;
                        ratedUnit = null;
                        convertTscUnit = false;
                        convertRatedUnit = false;
                        try {
                            tscParam = new Parameter(tsc.parameter);
                        }
                        catch (Throwable t) {
                            if (!this.allowUnsafe) {
                                throw new RatingException(t);
                            }
                            if (!this.warnUnsafe) break block41;
                            LOGGER.warning(t.getMessage());
                        }
                    }
                    if (tscParam != null && !tscParam.getParameter().equals(params[0])) {
                        msg = String.format("Parameter \"%s\" does not match rating parameter \"%s\".", tscParam.getParameter(), params[0]);
                        if (!this.allowUnsafe) {
                            throw new RatingException(msg);
                        }
                        if (this.warnUnsafe) {
                            LOGGER.warning(msg);
                        }
                    }
                    try {
                        tscUnit = new Units(tsc.units);
                    }
                    catch (Throwable t) {
                        if (!this.allowUnsafe) {
                            throw new RatingException(t);
                        }
                        if (!this.warnUnsafe) break block42;
                        LOGGER.warning(t.getMessage());
                    }
                }
                if (tscParam != null && !Units.canConvertBetweenUnits((String)tsc.units, (String)tscParam.getUnitsString())) {
                    msg = String.format("Unit \"%s\" is not valid for parameter \"%s\".", tsc.units, tscParam.getParameter());
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (this.warnUnsafe) {
                        LOGGER.warning(msg);
                    }
                }
                if (tscUnit != null && !tsc.units.equals(units[0])) {
                    if (Units.canConvertBetweenUnits((String)tsc.units, (String)units[0])) {
                        convertTscUnit = true;
                    } else {
                        msg = String.format("Cannot convert from \"%s\" to \"%s\".", tsc.units, units[0]);
                        if (!this.allowUnsafe) {
                            throw new RatingException(msg);
                        }
                        if (this.warnUnsafe) {
                            LOGGER.warning(msg + "  Rating will be performed on unconverted values.");
                        }
                    }
                }
                try {
                    ratedUnit = new Units(ratedUnitStr);
                }
                catch (Throwable t) {
                    if (!this.allowUnsafe) {
                        throw new RatingException(t);
                    }
                    if (!this.warnUnsafe) break block43;
                    LOGGER.warning(t.getMessage());
                }
            }
            if (ratedUnit != null && !ratedUnitStr.equals(units[units.length - 1])) {
                if (Units.canConvertBetweenUnits((String)ratedUnitStr, (String)units[units.length - 1])) {
                    convertRatedUnit = true;
                } else {
                    msg = String.format("Cannot convert from \"%s\" to \"%s\".", units[units.length - 1], ratedUnit);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (this.warnUnsafe) {
                        LOGGER.warning(msg + "  Rated values will be unconverted.");
                    }
                }
            }
            double[] indVals = null;
            long[] millis = new long[tsc.times.length];
            if (tz == null) {
                for (int i = 0; i < millis.length; ++i) {
                    millis[i] = Conversion.toMillis((int)tsc.times[i]);
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTimeZone(tz);
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy, HH:mm");
                HecTime t = new HecTime();
                for (int i = 0; i < millis.length; ++i) {
                    t.set(tsc.times[i]);
                    cal.setTime(sdf.parse(t.dateAndTime(4)));
                    millis[i] = cal.getTimeInMillis();
                }
            }
            if (convertTscUnit) {
                indVals = Arrays.copyOf(tsc.values, tsc.values.length);
                Units.convertUnits((double[])indVals, (String)tsc.units, (String)units[0]);
            } else {
                indVals = tsc.values;
            }
            double[] depVals = this.rateOne(indVals, millis);
            if (convertRatedUnit) {
                Units.convertUnits((double[])depVals, (String)units[units.length - 1], (String)ratedUnitStr);
            }
            TimeSeriesContainer ratedTsc = new TimeSeriesContainer();
            tsc.clone(ratedTsc);
            ratedTsc.values = depVals;
            String paramStr = this.getRatingSpec().getDepParameter();
            ratedTsc.fullName = tsc.subParameter == null ? TextUtil.replaceAll((String)tsc.fullName, (String)tsc.parameter, (String)paramStr, (String)"IL") : TextUtil.replaceAll((String)tsc.fullName, (String)String.format("%s-%s", tsc.parameter, tsc.subParameter), (String)paramStr, (String)"IL");
            String[] parts = TextUtil.split((String)paramStr, (String)"-", (String)"L", (int)2);
            ratedTsc.parameter = parts[0];
            ratedTsc.subParameter = parts.length > 1 ? parts[1] : null;
            ratedTsc.units = ratedUnitStr;
            return ratedTsc;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public final TimeSeriesContainer rate(TimeSeriesContainer[] tscs) throws RatingException {
        return this.rate(tscs, null);
    }

    @Override
    public final synchronized TimeSeriesContainer rate(TimeSeriesContainer[] tscs, String ratedUnitStr) throws RatingException {
        if (this.ratingSpec.getIndParamCount() != tscs.length) {
            throw new RatingException(String.format("Cannot rate a set of %d TimeSeriesContainers with a rating that has %d independent parameters", tscs.length, this.ratingSpec.getIndParamCount()));
        }
        String[] params = this.ratingSpec.getIndParameters();
        if (this.ratings.size() == 0) {
            throw new RatingException("No ratings.");
        }
        String[] units = this.getRatingUnits();
        if (ratedUnitStr == null || ratedUnitStr.length() == 0) {
            ratedUnitStr = units[units.length - 1];
        }
        int ratedInterval = tscs[0].interval;
        int indParamCount = tscs.length;
        try {
            boolean convertRatedUnit;
            Units ratedUnit;
            TimeZone tz;
            block49: {
                String msg;
                for (int i = 1; i < tscs.length; ++i) {
                    if (tscs[i].interval == tscs[0].interval) continue;
                    String msg2 = "TimeSeriesContainers have inconsistent intervals.";
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg2);
                    }
                    if (this.warnUnsafe) {
                        LOGGER.warning(msg2 + "  Rated values will be irregular interval.");
                    }
                    ratedInterval = 0;
                    break;
                }
                String tzid = tscs[0].timeZoneID;
                for (int i = 1; i < tscs.length; ++i) {
                    if (TextUtil.equals((CharSequence)tscs[i].timeZoneID, (CharSequence)tzid)) continue;
                    msg = "TimeSeriesContainers have inconsistent time zones.";
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (this.warnUnsafe) {
                        LOGGER.warning(msg + "  Value times will be treated as UTC.");
                    }
                    tzid = null;
                    break;
                }
                tz = null;
                if (tzid != null && !(tz = TimeZone.getTimeZone(tzid)).getID().equals(tzid)) {
                    msg = String.format("TimeSeriesContainers have invalid time zone \"%s\".", tzid);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (this.warnUnsafe) {
                        LOGGER.warning(msg + "  Value times will be treated as UTC.");
                    }
                    tz = null;
                }
                Parameter[] tscParam = new Parameter[indParamCount];
                Units[] tscUnit = new Units[indParamCount];
                ratedUnit = null;
                boolean[] convertTscUnit = new boolean[indParamCount];
                convertRatedUnit = false;
                for (int i = 0; i < indParamCount; ++i) {
                    String msg3;
                    block48: {
                        block47: {
                            tscParam[i] = null;
                            try {
                                tscParam[i] = new Parameter(tscs[i].parameter);
                            }
                            catch (Throwable t) {
                                if (!this.allowUnsafe) {
                                    throw new RatingException(t);
                                }
                                if (!this.warnUnsafe) break block47;
                                LOGGER.warning(t.getMessage());
                            }
                        }
                        if (tscParam[i] != null) {
                            String[] parts = TextUtil.split((String)params[i], (String)"-", (int)2);
                            if (!tscParam[i].getBaseParameter().equals(parts[0]) || parts.length == 2 && !tscParam[i].getSubParameter().equals(parts[1])) {
                                String msg4 = String.format("Parameter \"%s\" does not match rating parameter \"%s\".", tscParam[i].getParameter(), params[i]);
                                if (!this.allowUnsafe) {
                                    throw new RatingException(msg4);
                                }
                                if (this.warnUnsafe) {
                                    LOGGER.warning(msg4);
                                }
                            }
                        }
                        try {
                            tscUnit[i] = new Units(tscs[i].units);
                        }
                        catch (Throwable t) {
                            if (!this.allowUnsafe) {
                                throw new RatingException(t);
                            }
                            if (!this.warnUnsafe) break block48;
                            LOGGER.warning(t.getMessage());
                        }
                    }
                    if (tscParam[i] != null && !Units.canConvertBetweenUnits((String)tscs[i].units, (String)tscParam[i].getUnitsString())) {
                        msg3 = String.format("Unit \"%s\" is not valid for parameter \"%s\".", tscs[i].units, tscParam[i].getParameter());
                        if (!this.allowUnsafe) {
                            throw new RatingException(msg3);
                        }
                        if (this.warnUnsafe) {
                            LOGGER.warning(msg3);
                        }
                    }
                    if (tscUnit == null || tscs[i].units.equals(units[i])) continue;
                    if (Units.canConvertBetweenUnits((String)tscs[i].units, (String)units[i])) {
                        convertTscUnit[i] = true;
                        continue;
                    }
                    msg3 = String.format("Cannot convert from \"%s\" to \"%s\".", tscs[i].units, units[i]);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg3);
                    }
                    if (!this.warnUnsafe) continue;
                    LOGGER.warning(msg3 + "  Rating will be performed on unconverted values.");
                }
                try {
                    ratedUnit = new Units(ratedUnitStr);
                }
                catch (Throwable t) {
                    if (!this.allowUnsafe) {
                        throw new RatingException(t);
                    }
                    if (!this.warnUnsafe) break block49;
                    LOGGER.warning(t.getMessage());
                }
            }
            if (ratedUnit != null && !ratedUnitStr.equals(units[units.length - 1])) {
                if (Units.canConvertBetweenUnits((String)ratedUnitStr, (String)units[units.length - 1])) {
                    convertRatedUnit = true;
                } else {
                    String msg = String.format("Cannot convert from \"%s\" to \"%s\".", units[units.length - 1], ratedUnit);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (this.warnUnsafe) {
                        LOGGER.warning(msg + "  Rated values will be unconverted.");
                    }
                }
            }
            IndependentValuesContainer ivc = RatingUtil.tscsToIvc(tscs, units, tz, this.allowUnsafe, this.warnUnsafe);
            double[] depVals = this.rate(ivc.indVals, ivc.valTimes);
            if (convertRatedUnit) {
                Units.convertUnits((double[])depVals, (String)units[units.length - 1], (String)ratedUnitStr);
            }
            TimeSeriesContainer ratedTsc = new TimeSeriesContainer();
            tscs[0].clone(ratedTsc);
            ratedTsc.interval = ratedInterval;
            if (ivc.valTimes.length == tscs[0].times.length) {
                ratedTsc.times = Arrays.copyOf(tscs[0].times, tscs[0].times.length);
            } else {
                ratedTsc.times = new int[ivc.valTimes.length];
                if (tz == null) {
                    for (int i = 0; i < ivc.valTimes.length; ++i) {
                        ratedTsc.times[i] = Conversion.toMinutes((long)ivc.valTimes[i]);
                    }
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeZone(tz);
                    SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy, HH:mm");
                    HecTime t = new HecTime();
                    for (int i = 0; i < ivc.valTimes.length; ++i) {
                        cal.setTimeInMillis(ivc.valTimes[i]);
                        t.set(sdf.format(cal.getTime()));
                        ratedTsc.times[i] = t.value();
                    }
                }
            }
            ratedTsc.values = depVals;
            ratedTsc.numberValues = ratedTsc.times.length;
            String paramStr = this.ratingSpec.getDepParameter();
            if (ratedTsc.fullName.startsWith("/")) {
                paramStr = paramStr.toUpperCase();
            }
            ratedTsc.fullName = tscs[0].subParameter == null || tscs[0].subParameter.length() == 0 ? TextUtil.replaceAll((String)tscs[0].fullName, (String)tscs[0].parameter, (String)paramStr, (String)"IL") : TextUtil.replaceAll((String)tscs[0].fullName, (String)String.format("%s-%s", tscs[0].parameter, tscs[0].subParameter), (String)paramStr, (String)"IL");
            String[] parts = TextUtil.split((String)paramStr, (String)"-", (String)"L", (int)2);
            ratedTsc.parameter = parts[0];
            ratedTsc.subParameter = parts.length > 1 ? parts[1] : null;
            ratedTsc.units = ratedUnitStr;
            return ratedTsc;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public final TimeSeriesMath rate(TimeSeriesMath tsm) throws RatingException {
        return this.rate(tsm, null);
    }

    @Override
    public final TimeSeriesMath rate(TimeSeriesMath tsm, String ratedUnitStr) throws RatingException {
        try {
            return new TimeSeriesMath(this.rate((TimeSeriesContainer)tsm.getData(), ratedUnitStr));
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public final TimeSeriesMath rate(TimeSeriesMath[] tsms) throws RatingException {
        return this.rate(tsms, null);
    }

    @Override
    public final TimeSeriesMath rate(TimeSeriesMath[] tsms, String ratedUnitStr) throws RatingException {
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[tsms.length];
        try {
            for (int i = 0; i < tsms.length; ++i) {
                tscs[i] = (TimeSeriesContainer)tsms[i].getData();
            }
            return new TimeSeriesMath(this.rate(tscs, ratedUnitStr));
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public final synchronized RatingSpec getRatingSpec() {
        return this.ratingSpec;
    }

    @Override
    public final synchronized IRatingSpecification getRatingSpecification() throws DataSetException {
        IRatingSpecification ratingSpecification = this.getRatingSpec().getRatingSpecification();
        return ratingSpecification;
    }

    @Override
    public final synchronized IRatingTemplate getRatingTemplate() throws DataSetException {
        IRatingTemplate ratingTemplate = this.getRatingSpec().getRatingTemplate();
        return ratingTemplate;
    }

    @Override
    public final synchronized void setRatingSpec(RatingSpec ratingSpec) throws RatingException {
        if (this.ratings != null && this.ratings.size() > 0 && ratingSpec.getIndParamCount() != this.ratings.firstEntry().getValue().getIndParamCount()) {
            throw new RatingException("Number of independent parameters does not match existing ratings");
        }
        if (ratingSpec != null) {
            switch (ratingSpec.getInRangeMethod()) {
                case LOGARITHMIC: 
                case LOG_LIN: 
                case LIN_LOG: {
                    throw new RatingException("Invalid in-range rating method for rating times: " + ratingSpec.getInRangeMethod());
                }
            }
            switch (ratingSpec.getOutRangeLowMethod()) {
                case PREVIOUS: 
                case LOGARITHMIC: 
                case LOG_LIN: 
                case LIN_LOG: {
                    throw new RatingException("Invalid out-of-range low rating method for rating times: " + ratingSpec.getOutRangeLowMethod());
                }
            }
            switch (ratingSpec.getOutRangeHighMethod()) {
                case NEXT: 
                case LOGARITHMIC: 
                case LOG_LIN: 
                case LIN_LOG: {
                    throw new RatingException("Invalid out-of-range high rating method for rating times: " + ratingSpec.getOutRangeHighMethod());
                }
            }
        }
        this.ratingSpec = ratingSpec;
        for (Long effectiveDate : this.ratings.keySet()) {
            this.ratings.get((Object)effectiveDate).ratingSpec = this.ratingSpec;
        }
        for (Long effectiveDate : this.activeRatings.keySet()) {
            this.activeRatings.get((Object)effectiveDate).ratingSpec = this.ratingSpec;
        }
    }

    @Override
    public final synchronized AbstractRating[] getRatings() {
        return this.ratings.values().toArray(new AbstractRating[this.ratings.size()]);
    }

    @Override
    public NavigableSet<AbstractRating> getRatingsSorted() {
        TreeSet<AbstractRating> retval = new TreeSet<AbstractRating>(Comparator.comparing(AbstractRating::getEffectiveDate));
        retval.addAll(this.ratings.values());
        return retval;
    }

    @Override
    public final synchronized TreeMap<Long, AbstractRating> getRatingsMap() {
        return this.ratings;
    }

    @Override
    public final synchronized AbstractRating getRating(Long effectiveDate) {
        AbstractRating retval = null;
        if (this.ratings != null) {
            retval = this.ratings.get(effectiveDate);
        }
        return retval;
    }

    @Override
    public final synchronized AbstractRating getFloorRating(Long effectiveDate) {
        Map.Entry<Long, AbstractRating> floorEntry;
        AbstractRating retval = null;
        if (this.ratings != null && effectiveDate != null && (floorEntry = this.ratings.floorEntry(effectiveDate)) != null) {
            retval = floorEntry.getValue();
        }
        return retval;
    }

    @Override
    public final synchronized void setRatings(AbstractRating[] ratings) throws RatingException {
        this.removeAllRatings();
        this.addRatings(ratings);
    }

    @Override
    public final synchronized int getRatingCount() {
        return this.ratings == null ? 0 : this.ratings.size();
    }

    @Override
    public final synchronized int getActiveRatingCount() {
        int count = this.ratings.size();
        for (AbstractRating abstractRating : this.ratings.values()) {
            if (abstractRating.active) continue;
            --count;
        }
        return count;
    }

    @Override
    @Deprecated
    public final synchronized long getDefaultValuetime() {
        return this.defaultValueTime;
    }

    @Override
    public final synchronized void resetDefaultValuetime() {
        this.resetDefaultValueTime();
    }

    @Override
    public final synchronized long getRatingTime() {
        return this.ratingTime;
    }

    @Override
    public final synchronized void setRatingTime(long ratingTime) {
        this.ratingTime = ratingTime;
        for (AbstractRating rating : this.ratings.values()) {
            rating.setRatingTime(ratingTime);
        }
    }

    @Override
    public final synchronized void resetRatingTime() {
        Long[] effectiveDates;
        this.ratingTime = Long.MAX_VALUE;
        for (Long effectiveDate : effectiveDates = this.ratings.keySet().toArray(new Long[0])) {
            this.ratings.get(effectiveDate).resetRatingTime();
        }
    }

    @Override
    public final synchronized boolean doesAllowUnsafe() {
        return this.allowUnsafe;
    }

    @Override
    public final synchronized void setAllowUnsafe(boolean allowUnsafe) {
        this.allowUnsafe = allowUnsafe;
        for (AbstractRating ar : this.ratings.values()) {
            ar.setAllowUnsafe(allowUnsafe);
        }
    }

    @Override
    public final synchronized boolean doesWarnUnsafe() {
        return this.warnUnsafe;
    }

    @Override
    public final synchronized void setWarnUnsafe(boolean warnUnsafe) {
        this.warnUnsafe = warnUnsafe;
        for (AbstractRating ar : this.ratings.values()) {
            ar.setWarnUnsafe(this.allowUnsafe);
        }
    }

    @Override
    public final synchronized String getDssPathname() {
        return this.ratingSpec == null ? null : this.ratingSpec.getDssPathname();
    }

    @Override
    public final synchronized String getName() {
        String name = null;
        if (this.ratingSpec == null) {
            if (this.ratings.size() > 0) {
                name = this.ratings.firstEntry().getValue().getName();
            }
        } else {
            name = this.ratingSpec.getRatingSpecId();
        }
        return name;
    }

    @Override
    public final synchronized void setName(String name) throws RatingException {
        for (AbstractRating rating : this.ratings.values()) {
            rating.setName(name);
        }
        if (this.ratingSpec != null) {
            String[] parts = TextUtil.split((String)name, (String)".", (String)"L");
            this.ratingSpec.setLocationId(parts[0]);
            this.ratingSpec.setParametersId(parts[1]);
            this.ratingSpec.setTemplateVersion(parts[2]);
            this.ratingSpec.setVersion(parts[3]);
        }
    }

    @Override
    public final synchronized String[] getRatingParameters() {
        return this.getRatingSpec().getParameters();
    }

    @Override
    public synchronized String[] getRatingUnits() {
        String[] units = null;
        if (this.ratings.size() > 0) {
            units = this.ratings.firstEntry().getValue().getRatingUnits();
        }
        return units;
    }

    @Override
    public synchronized String[] getDataUnits() {
        String[] units = null;
        if (this.dataUnits != null) {
            units = Arrays.copyOf(this.dataUnits, this.dataUnits.length);
        } else if (this.ratings.size() > 0) {
            units = this.ratings.firstEntry().getValue().getDataUnits();
        }
        return units;
    }

    @Override
    public synchronized void setDataUnits(String[] units) throws RatingException {
        for (AbstractRating rating : this.ratings.values()) {
            rating.setDataUnits(units);
        }
        this.dataUnits = units == null ? null : Arrays.copyOf(units, units.length);
    }

    @Override
    public double[][] getRatingExtents() throws RatingException {
        return this.getRatingExtents(this.getRatingTime());
    }

    @Override
    public synchronized double[][] getRatingExtents(long ratingTime) throws RatingException {
        if (this.activeRatings.size() == 0) {
            throw new RatingException("No active ratings.");
        }
        Map.Entry<Long, AbstractRating> rating = this.activeRatings.floorEntry(ratingTime);
        if (rating == null) {
            rating = this.activeRatings.ceilingEntry(ratingTime);
        }
        return rating.getValue().getRatingExtents();
    }

    @Override
    public synchronized long[] getEffectiveDates() {
        long[] effectiveDates = new long[this.activeRatings.size()];
        Iterator<AbstractRating> it = this.activeRatings.values().iterator();
        for (int i = 0; i < effectiveDates.length; ++i) {
            effectiveDates[i] = it.next().effectiveDate;
        }
        return effectiveDates;
    }

    @Override
    public synchronized long[] getCreateDates() {
        long[] createDates = new long[this.activeRatings.size()];
        Iterator<AbstractRating> it = this.activeRatings.values().iterator();
        for (int i = 0; i < createDates.length; ++i) {
            createDates[i] = it.next().createDate;
        }
        return createDates;
    }

    @Override
    public final synchronized long getDefaultValueTime() {
        return this.defaultValueTime;
    }

    @Override
    public final synchronized void setDefaultValueTime(long defaultValueTime) {
        this.defaultValueTime = defaultValueTime;
        for (ICwmsRating iCwmsRating : this.ratings.values()) {
            if (iCwmsRating == null) continue;
            iCwmsRating.setDefaultValueTime(defaultValueTime);
        }
    }

    @Override
    public final synchronized double rate(double indVal) throws RatingException {
        if (this.defaultValueTime == Long.MIN_VALUE) {
            throw new RatingException("Default value time is not set");
        }
        return this.rate(indVal, this.defaultValueTime);
    }

    @Override
    public final synchronized double rateOne(double ... indVals) throws RatingException {
        if (this.defaultValueTime == Long.MIN_VALUE) {
            throw new RatingException("Default value time is not set");
        }
        return this.rateOne(indVals, this.defaultValueTime);
    }

    @Override
    public final synchronized double rateOne2(double[] indVals) throws RatingException {
        if (this.defaultValueTime == Long.MIN_VALUE) {
            throw new RatingException("Default value time is not set");
        }
        return this.rateOne(indVals, this.defaultValueTime);
    }

    @Override
    public final synchronized double[] rate(double[] indVals) throws RatingException {
        if (this.defaultValueTime == Long.MIN_VALUE) {
            throw new RatingException("Default value time is not set");
        }
        return this.rate(indVals, this.defaultValueTime);
    }

    @Override
    public final synchronized double[] rate(double[][] indVals) throws RatingException {
        if (this.defaultValueTime == Long.MIN_VALUE) {
            throw new RatingException("Default value time is not set");
        }
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, this.defaultValueTime);
        return this.rate(indVals, valTimes);
    }

    @Override
    public final synchronized double rate(long valTime, double indVal) throws RatingException {
        return this.rate(indVal, valTime);
    }

    @Override
    public final synchronized double rateOne(long valTime, double ... indVals) throws RatingException {
        return this.rateOne(indVals, valTime);
    }

    @Override
    public double[] rateOne(long[] valueTimes, double[] indVals) throws RatingException {
        return this.rateOne(indVals, valueTimes);
    }

    @Override
    public final synchronized double rateOne2(long valTime, double ... indVals) throws RatingException {
        return this.rateOne(indVals, valTime);
    }

    @Override
    public final synchronized double[] rate(long valTime, double[] indVals) throws RatingException {
        return this.rate(indVals, valTime);
    }

    @Override
    public final synchronized double[] rate(long[] valTimes, double[] indVals) throws RatingException {
        return this.rateOne(indVals, valTimes);
    }

    @Override
    public final synchronized double[] rate(long valTime, double[][] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, valTime);
        return this.rate(indVals, valTimes);
    }

    @Override
    public final synchronized double[] rate(long[] valTimes, double[][] indVals) throws RatingException {
        return this.rate(indVals, valTimes);
    }

    @Override
    public final synchronized double reverseRate(double depVal) throws RatingException {
        if (this.defaultValueTime == Long.MIN_VALUE) {
            throw new RatingException("Default value time is not set");
        }
        long[] valTimes = new long[]{this.defaultValueTime};
        double[] depVals = new double[]{depVal};
        return this.reverseRate(valTimes, depVals)[0];
    }

    @Override
    public final synchronized double[] reverseRate(double[] depVals) throws RatingException {
        if (this.defaultValueTime == Long.MIN_VALUE) {
            throw new RatingException("Default value time is not set");
        }
        return this.reverseRate(this.defaultValueTime, depVals);
    }

    @Override
    public final synchronized double reverseRate(long valTime, double depVal) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[] depVals = new double[]{depVal};
        return this.reverseRate(valTimes, depVals)[0];
    }

    @Override
    public final synchronized double[] reverseRate(long valTime, double[] depVals) throws RatingException {
        long[] valTimes = new long[depVals.length];
        Arrays.fill(valTimes, valTime);
        return this.reverseRate(valTimes, depVals);
    }

    @Override
    public synchronized double[] reverseRate(long[] valTimes, double[] depVals) throws RatingException {
        double[] Y = new double[depVals.length];
        if (this.activeRatings.size() == 0) {
            throw new RatingException("No active ratings.");
        }
        if (this.getDataUnits() == null) {
            Map.Entry<Long, AbstractRating> entry1 = this.ratings.firstEntry();
            Map.Entry<Long, AbstractRating> entry2 = this.ratings.higherEntry(entry1.getKey());
            while (entry2 != null) {
                if (!entry1.getValue().getRatingUnitsId().equalsIgnoreCase(entry2.getValue().getRatingUnitsId())) {
                    throw new RatingException("Data units must be specified when rating set has multiple rating units.");
                }
                entry1 = entry2;
                entry2 = this.ratings.higherEntry(entry1.getKey());
            }
        }
        Map.Entry<Long, AbstractRating> lowerRating = null;
        Map.Entry<Long, AbstractRating> upperRating = null;
        IRating lastUsedRating = null;
        RatingConst.RatingMethod method = null;
        block21: for (int i = 0; i < depVals.length; ++i) {
            if (i > 0 && valTimes[i] == valTimes[i - 1]) {
                if (lastUsedRating == null) {
                    Y[i] = Y[i - 1];
                    continue;
                }
                Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                continue;
            }
            lowerRating = this.activeRatings.floorEntry(valTimes[i]);
            upperRating = this.activeRatings.ceilingEntry(valTimes[i]);
            if (lowerRating == null) {
                method = this.ratingSpec.getOutRangeLowMethod();
                switch (method) {
                    case ERROR: {
                        throw new RatingException("Effective date is before earliest rating");
                    }
                    case NULL: {
                        Y[i] = -3.4028234663852886E38;
                        lastUsedRating = null;
                        continue block21;
                    }
                    case NEXT: 
                    case NEAREST: 
                    case HIGHER: 
                    case CLOSEST: {
                        lastUsedRating = this.activeRatings.firstEntry().getValue();
                        Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                        continue block21;
                    }
                    default: {
                        if (this.activeRatings.size() == 1) {
                            throw new RatingException(String.format("Cannot use rating method %s with only one active rating.", new Object[]{method}));
                        }
                        lowerRating = this.activeRatings.firstEntry();
                        upperRating = this.activeRatings.higherEntry(lowerRating.getKey());
                    }
                }
            }
            if (upperRating == null) {
                method = this.ratingSpec.getOutRangeHighMethod();
                switch (method) {
                    case ERROR: {
                        throw new RatingException("Effective date is after latest rating");
                    }
                    case NULL: {
                        Y[i] = -3.4028234663852886E38;
                        lastUsedRating = null;
                        continue block21;
                    }
                    case NEAREST: 
                    case CLOSEST: 
                    case PREVIOUS: 
                    case LOWER: {
                        lastUsedRating = this.activeRatings.lastEntry().getValue();
                        Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                        continue block21;
                    }
                    default: {
                        if (this.activeRatings.size() == 1) {
                            switch (method) {
                                case LINEAR: {
                                    lastUsedRating = this.activeRatings.lastEntry().getValue();
                                    Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                                    continue block21;
                                }
                                default: {
                                    throw new RatingException(String.format("Cannot use rating method %s with only one active rating.", new Object[]{method}));
                                }
                            }
                        }
                        upperRating = this.activeRatings.lastEntry();
                        lowerRating = this.activeRatings.lowerEntry(upperRating.getKey());
                    }
                }
            }
            if (lowerRating.getKey() == valTimes[i]) {
                Y[i] = lowerRating.getValue().reverseRate(valTimes[i], depVals[i]);
                continue;
            }
            if (upperRating.getKey() == valTimes[i]) {
                lastUsedRating = upperRating.getValue();
                Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                continue;
            }
            switch (this.ratingSpec.getInRangeMethod()) {
                case ERROR: {
                    throw new RatingException("Effective date is between existing rating");
                }
                case NULL: {
                    Y[i] = -3.4028234663852886E38;
                    lastUsedRating = null;
                    continue block21;
                }
                case PREVIOUS: 
                case LOWER: {
                    lastUsedRating = lowerRating.getValue();
                    Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                    continue block21;
                }
                case NEXT: 
                case HIGHER: {
                    lastUsedRating = upperRating.getValue();
                    Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                    continue block21;
                }
                case CLOSEST: {
                    lastUsedRating = valTimes[i] - lowerRating.getKey() < upperRating.getKey() - valTimes[i] ? (IRating)lowerRating.getValue() : (IRating)upperRating.getValue();
                    Y[i] = lastUsedRating.reverseRate(valTimes[i], depVals[i]);
                    continue block21;
                }
                default: {
                    method = this.ratingSpec.getInRangeMethod();
                    lastUsedRating = null;
                    boolean ind_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LIN_LOG;
                    boolean dep_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LOG_LIN;
                    double x = valTimes[i];
                    double x1 = lowerRating.getKey().longValue();
                    double x2 = upperRating.getKey().longValue();
                    double Y1 = lowerRating.getValue().reverseRate(valTimes[i], depVals[i]);
                    double Y2 = upperRating.getValue().reverseRate(valTimes[i], depVals[i]);
                    double y1 = Y1;
                    double y2 = Y2;
                    if (ind_log) {
                        x = Math.log10(x);
                        x1 = Math.log10(x1);
                        x2 = Math.log10(x2);
                        if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(x1) || Double.isInfinite(x1) || Double.isNaN(x2) || Double.isInfinite(x2)) {
                            x = valTimes[i];
                            x1 = lowerRating.getKey().longValue();
                            x2 = upperRating.getKey().longValue();
                            dep_log = false;
                        }
                    }
                    if (dep_log) {
                        y1 = Math.log10(y1);
                        y2 = Math.log10(y2);
                        if (Double.isNaN(y1) || Double.isInfinite(y1) || Double.isNaN(y2) || Double.isInfinite(y2)) {
                            x = valTimes[i];
                            x1 = lowerRating.getKey().longValue();
                            x2 = upperRating.getKey().longValue();
                            y1 = Y1;
                            y2 = Y2;
                            dep_log = false;
                        }
                    }
                    double y = y1 + (x - x1) / (x2 - x1) * (y2 - y1);
                    if (dep_log) {
                        y = Math.pow(10.0, y);
                    }
                    Y[i] = y;
                }
            }
        }
        return Y;
    }

    @Override
    public final synchronized TimeSeriesContainer reverseRate(TimeSeriesContainer tsc) throws RatingException {
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[]{tsc};
        String[] units = new String[]{tsc.units};
        TimeZone tz = null;
        if (tsc.timeZoneID != null && !(tz = TimeZone.getTimeZone(tsc.timeZoneID)).getID().equals(tsc.timeZoneID)) {
            String msg = String.format("TimeSeriesContainers have invalid time zone \"%s\".", tsc.timeZoneID);
            if (!this.allowUnsafe) {
                throw new RatingException(msg);
            }
            if (this.warnUnsafe) {
                LOGGER.warning(msg + "  Value times will be treated as UTC.");
            }
            tz = null;
        }
        IndependentValuesContainer ivc = RatingUtil.tscsToIvc(tscs, units, tz, this.allowUnsafe, this.warnUnsafe);
        TimeSeriesContainer ratedTsc = new TimeSeriesContainer();
        tsc.clone(ratedTsc);
        double[] depVals = new double[ivc.indVals.length];
        for (int i = 0; i < depVals.length; ++i) {
            depVals[i] = ivc.indVals[i][0];
        }
        ratedTsc.values = this.reverseRate(ivc.valTimes, depVals);
        String[] params = this.getRatingParameters();
        String paramStr = params[0];
        ratedTsc.fullName = tsc.subParameter == null ? TextUtil.replaceAll((String)tsc.fullName, (String)tsc.parameter, (String)paramStr, (String)"IL") : TextUtil.replaceAll((String)tsc.fullName, (String)String.format("%s-%s", tsc.parameter, tsc.subParameter), (String)paramStr, (String)"IL");
        String[] parts = TextUtil.split((String)paramStr, (String)"-", (String)"L", (int)2);
        ratedTsc.parameter = parts[0];
        ratedTsc.subParameter = parts.length > 1 ? parts[1] : null;
        String[] dataUnits = this.getDataUnits();
        ratedTsc.units = dataUnits == null ? this.getRatingUnits()[0] : dataUnits[0];
        return ratedTsc;
    }

    @Override
    public final synchronized TimeSeriesMath reverseRate(TimeSeriesMath tsm) throws RatingException {
        try {
            return new TimeSeriesMath(this.reverseRate((TimeSeriesContainer)tsm.getData()));
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public final synchronized int getIndParamCount() throws RatingException {
        return this.ratingSpec != null ? this.ratingSpec.getIndParamCount() : this.ratings.firstEntry().getValue().getIndParamCount();
    }

    @Override
    public void update(java.util.Observable arg0, Object arg1) {
        this.observationTarget.setChanged();
        this.observationTarget.notifyObservers();
    }

    @Override
    public final synchronized void addObserver(Observer o) {
        this.observationTarget.addObserver(o);
    }

    @Override
    public final synchronized void deleteObserver(Observer o) {
        this.observationTarget.deleteObserver(o);
    }

    @Override
    public synchronized RatingSetContainer getData() {
        RatingSetContainer rsc = new RatingSetContainer();
        if (this.ratingSpec != null) {
            rsc.ratingSpecContainer = this.ratingSpec.getData();
        }
        if (this.ratings.size() > 0) {
            rsc.abstractRatingContainers = new AbstractRatingContainer[this.ratings.size()];
            Iterator<AbstractRating> it = this.ratings.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                rsc.abstractRatingContainers[i] = it.next().getData();
                ++i;
            }
        }
        return rsc;
    }

    @Override
    public synchronized void setData(RatingSetContainer rsc) throws RatingException {
        try {
            this.removeAllRatings();
            if (rsc.ratingSpecContainer == null) {
                this.ratingSpec = null;
            } else {
                this.setRatingSpec(new RatingSpec(rsc.ratingSpecContainer));
            }
            if (rsc.abstractRatingContainers == null) {
                throw new RatingObjectDoesNotExistException("RatingSetContainer contains no ratings.");
            }
            for (int i = 0; i < rsc.abstractRatingContainers.length; ++i) {
                this.addRating(rsc.abstractRatingContainers[i].newRating());
            }
            if (this.observationTarget != null) {
                this.observationTarget.setChanged();
                this.observationTarget.notifyObservers();
            }
        }
        catch (RuntimeException t) {
            throw new RatingException((Throwable)t);
        }
    }

    @Override
    public boolean hasVerticalDatum() {
        try {
            return this.getNativeVerticalDatum() != null;
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
            return false;
        }
    }

    @Override
    public String getNativeVerticalDatum() throws VerticalDatumException {
        return this.getData().getNativeVerticalDatum();
    }

    @Override
    public String getCurrentVerticalDatum() throws VerticalDatumException {
        return this.getData().getCurrentVerticalDatum();
    }

    @Override
    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        return this.getData().isCurrentVerticalDatumEstimated();
    }

    @Override
    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        RatingSetContainer rsc = this.getData();
        boolean change = rsc.toNativeVerticalDatum();
        if (change) {
            try {
                this.setData(rsc);
            }
            catch (RatingException e) {
                throw new VerticalDatumException((Throwable)e);
            }
        }
        return change;
    }

    @Override
    public boolean toNGVD29() throws VerticalDatumException {
        RatingSetContainer rsc = this.getData();
        boolean change = rsc.toNGVD29();
        if (change) {
            try {
                this.setData(rsc);
            }
            catch (RatingException e) {
                throw new VerticalDatumException((Throwable)e);
            }
        }
        return change;
    }

    @Override
    public boolean toNAVD88() throws VerticalDatumException {
        RatingSetContainer rsc = this.getData();
        boolean change = rsc.toNAVD88();
        if (change) {
            try {
                this.setData(rsc);
            }
            catch (RatingException e) {
                throw new VerticalDatumException((Throwable)e);
            }
        }
        return change;
    }

    @Override
    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        RatingSetContainer rsc = this.getData();
        boolean change = rsc.toVerticalDatum(datum);
        if (change) {
            try {
                this.setData(rsc);
            }
            catch (RatingException e) {
                throw new VerticalDatumException((Throwable)e);
            }
        }
        return change;
    }

    @Override
    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        RatingSetContainer rsc = this.getData();
        boolean change = rsc.forceVerticalDatum(datum);
        if (change) {
            try {
                this.setData(rsc);
            }
            catch (RatingException e) {
                throw new VerticalDatumException((Throwable)e);
            }
        }
        return change;
    }

    @Override
    public double getCurrentOffset() throws VerticalDatumException {
        return this.getData().getCurrentOffset();
    }

    @Override
    public double getCurrentOffset(String unit) throws VerticalDatumException {
        return this.getData().getCurrentOffset(unit);
    }

    @Override
    public double getNGVD29Offset() throws VerticalDatumException {
        return this.getData().getNGVD29Offset();
    }

    @Override
    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        return this.getData().getNGVD29Offset(unit);
    }

    @Override
    public double getNAVD88Offset() throws VerticalDatumException {
        return this.getData().getNAVD88Offset();
    }

    @Override
    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        return this.getData().getNAVD88Offset(unit);
    }

    @Override
    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        return this.getData().isNGVD29OffsetEstimated();
    }

    @Override
    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        return this.getData().isNAVD88OffsetEstimated();
    }

    @Override
    public String getVerticalDatumInfo() throws VerticalDatumException {
        return this.getData().getVerticalDatumInfo();
    }

    @Override
    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        for (AbstractRating ar : this.ratings.values()) {
            ar.setVerticalDatumInfo(xmlStr);
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean same;
        boolean bl = obj == this || obj instanceof AbstractRatingSet && ((AbstractRatingSet)obj).allowUnsafe == this.allowUnsafe && ((AbstractRatingSet)obj).warnUnsafe == this.warnUnsafe && ((AbstractRatingSet)obj).defaultValueTime == this.defaultValueTime && ((AbstractRatingSet)obj).ratingTime == this.ratingTime && this.getData().equals(((AbstractRatingSet)obj).getData()) && ((AbstractRatingSet)obj).activeRatings == null == (this.activeRatings == null) ? true : (same = false);
        if (same && this.activeRatings != null) {
            if (((AbstractRatingSet)obj).activeRatings.size() != this.activeRatings.size()) {
                return false;
            }
            for (Long key : this.activeRatings.keySet()) {
                if (!((AbstractRatingSet)obj).activeRatings.containsKey(key)) {
                    return false;
                }
                if (((AbstractRatingSet)obj).activeRatings.get(key).equals(this.activeRatings.get(key))) continue;
                return false;
            }
        }
        return same;
    }

    @Override
    public int hashCode() {
        int hashCode = this.getClass().getName().hashCode() + 11 * (this.allowUnsafe ? 1 : 11) + 13 * (this.warnUnsafe ? 1 : 13) + 17 * (int)this.defaultValueTime + 19 * (int)this.ratingTime + this.getData().hashCode();
        if (this.activeRatings != null) {
            Iterator<AbstractRating> it = this.activeRatings.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                hashCode += 23 * i * it.next().hashCode();
                ++i;
            }
        }
        return hashCode;
    }

    protected synchronized void validate() throws RatingException {
        if (this.ratings.size() == 0) {
            return;
        }
        String unitsId = this.ratings.firstEntry().getValue().getRatingUnitsId();
        String[] units = unitsId == null ? null : TextUtil.split((String)unitsId.replace(";", ","), (String)",", (String)"L");
        String[] params = null;
        boolean[] validParams = null;
        boolean[] validUnits = null;
        try {
            if (this.ratingSpec != null) {
                int i;
                params = this.ratingSpec.getIndParameters();
                validParams = new boolean[this.ratingSpec.getIndParamCount() + 1];
                validUnits = new boolean[this.ratingSpec.getIndParamCount() + 1];
                Parameter ratingParam = null;
                Units ratingUnit = null;
                for (i = 0; i < params.length; ++i) {
                    ratingParam = null;
                    validParams[i] = false;
                    if (this.ratingSpec == null) continue;
                    try {
                        ratingParam = new Parameter(params[i]);
                        validParams[i] = true;
                        continue;
                    }
                    catch (Throwable t) {
                        if (!this.allowUnsafe) {
                            throw new RatingException(t);
                        }
                        if (!this.warnUnsafe) continue;
                        LOGGER.warning(t.getMessage());
                    }
                }
                if (units != null) {
                    for (i = 0; i < units.length; ++i) {
                        ratingUnit = null;
                        validUnits[i] = false;
                        try {
                            ratingUnit = new Units(units[i], true);
                            validUnits[i] = true;
                            continue;
                        }
                        catch (Throwable t) {
                            if (!this.allowUnsafe) {
                                throw new RatingException(t);
                            }
                            if (!this.warnUnsafe) continue;
                            LOGGER.warning(t.getMessage());
                        }
                    }
                }
                for (i = 0; i < params.length; ++i) {
                    if (!validParams[i] || !validUnits[i]) continue;
                    ratingParam = new Parameter(params[i]);
                    ratingUnit = new Units(units[i], true);
                    if (Units.canConvertBetweenUnits((String)ratingParam.getUnitsString(), (String)ratingUnit.toString())) continue;
                    String msg = String.format("Unit \"%s\" is not consistent with parameter \"%s\".", units[i], params[i]);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (!this.warnUnsafe) continue;
                    LOGGER.warning(msg + "  Rating will be performed on unconverted values.");
                }
            }
        }
        catch (RuntimeException t) {
            throw new RatingException((Throwable)t);
        }
    }

    @Override
    public VerticalDatumContainer getVerticalDatumContainer() {
        VerticalDatumContainer retval = null;
        for (AbstractRating ar : this.ratings.values()) {
            if (!ar.hasVerticalDatum()) continue;
            retval = ar.getVerticalDatumContainer();
            break;
        }
        return retval;
    }

    @Override
    public void setVerticalDatumContainer(VerticalDatumContainer vdc) {
        for (AbstractRating ar : this.ratings.values()) {
            ar.setVerticalDatumContainer(vdc);
        }
    }

    @Override
    public synchronized TextContainer getDssData() throws RatingException {
        throw new RatingException("getDssData() unsupported. Use factory methods instead");
    }

    @Override
    public String toCompressedXmlString() throws RatingException {
        throw new RatingException("toCompressedXmlString() unsupported. Use factory methods instead");
    }

    @Override
    public String toXmlString(CharSequence indent) throws RatingException {
        throw new RatingException("toXmlString(CharSequence) unsupported. Use factory methods instead");
    }

    @Override
    @Deprecated
    public void getConcreteRatings(Connection conn) throws RatingException {
    }

    @Override
    @Deprecated
    public void getConcreteRatings(long date) throws RatingException {
    }

    @Override
    @Deprecated
    public void getConcreteRatings() throws RatingException {
    }

    @Override
    @Deprecated
    public RatingSetStateContainer getState() {
        return null;
    }

    @Override
    public synchronized void resetDefaultValueTime() {
        this.defaultValueTime = Long.MIN_VALUE;
    }
}

