/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.RatingException;
import hec.data.Units;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingValue;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.ExpressionRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingXmlCompatUtil;
import hec.hecmath.computation.MathExpression;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import hec.lang.Observable;
import hec.util.TextUtil;
import java.util.Arrays;

public class ExpressionRating
extends AbstractRating {
    protected String expressionString = null;
    protected MathExpression expression = null;
    protected Variable[] variables = null;

    public ExpressionRating(String expr, String officeId, String ratingSpecId, String ratingUnitsId, long effectiveDate, long createDate, boolean active, String description) throws RatingException {
        this.init(expr, officeId, ratingSpecId, ratingUnitsId, effectiveDate, createDate, active, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionRating(ExpressionRatingContainer erc) throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            super._setData(erc);
            this.setExpression(erc.expression);
            this.observationTarget = new Observable();
        }
    }

    @Deprecated
    public ExpressionRating(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        ExpressionRatingContainer expressionRatingContainer = service.createExpressionRatingContainer(xmlText);
        this.setData(expressionRatingContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpression() {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            return this.expressionString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpression(String expr) throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            try {
                String expr2 = TextUtil.replaceAll((String)expr, (String)"(^|\\W)(arg|i)([1-9])", (String)"$1\\$$2$3", (String)"i");
                this.expression = new MathExpression(expr2);
                VariableSet varset = this.expression.getVariables();
                Object[] varnames = new String[varset.getVariableCount()];
                varset.getVariableNames().toArray(varnames);
                Arrays.sort(varnames);
                this.variables = new Variable[varnames.length];
                for (int i = 0; i < varnames.length; ++i) {
                    this.variables[i] = varset.getVariable((String)varnames[i]);
                }
                this.expressionString = expr;
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getRatingExtents(long ratingTime) throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            double[][] extents = new double[2][this.getIndParamCount() + 1];
            Arrays.fill(extents[0], Double.NEGATIVE_INFINITY);
            Arrays.fill(extents[1], Double.POSITIVE_INFINITY);
            return extents;
        }
    }

    public double rate(double pIndVal) throws RatingException {
        double[] indVals = new double[]{pIndVal};
        return this.rate(indVals)[0];
    }

    public double rateOne(double ... pIndVals) throws RatingException {
        return this.rateOne2(pIndVals);
    }

    public double rateOne2(double[] pIndVals) throws RatingException {
        double[][] indVals = new double[][]{pIndVals};
        return this.rate(indVals)[0];
    }

    public double[] rate(double[] pIndVals) throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            if (this.variables.length != 1) {
                throw new RatingException(String.format("Data has 1 independent parameter; rating %s requires %d", this.ratingSpecId, this.getIndParamCount()));
            }
            try {
                String[] dataUnits = this.getDataUnits();
                String[] ratingUnits = this.getRatingUnits();
                for (int i = 0; i < ratingUnits.length; ++i) {
                    if (TextUtil.equals((CharSequence)dataUnits[i], (CharSequence)ratingUnits[i])) {
                        ratingUnits[i] = null;
                        dataUnits[i] = null;
                        continue;
                    }
                    if (Units.canConvertBetweenUnits((String)dataUnits[i], (String)ratingUnits[i])) continue;
                    String msg = String.format("Cannot convert from \"%s\" to \"%s\".", dataUnits[i], ratingUnits[i]);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (!this.warnUnsafe) continue;
                    logger.warning(msg + "  Rating will be performed on unconverted values.");
                }
                double[] rated = new double[pIndVals.length];
                for (int i = 0; i < pIndVals.length; ++i) {
                    this.variables[0].setValue(this.convertUnits(pIndVals[i], dataUnits[0], ratingUnits[0]));
                    rated[i] = this.convertUnits(this.expression.evaluate(), ratingUnits[1], dataUnits[1]);
                }
                return rated;
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
        }
    }

    public double[] rate(double[][] pIndVals) throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            for (int i = 1; i < pIndVals.length; ++i) {
                if (pIndVals[i].length == pIndVals[0].length) continue;
                throw new RatingException("Independent value sets have varying lengths.");
            }
            if (pIndVals[0].length != this.variables.length) {
                throw new RatingException(String.format("Data has %d independent parameters; rating %s requires %d", pIndVals[0].length, this.ratingSpecId, this.variables.length));
            }
            try {
                String[] ratingUnits = this.getRatingUnits();
                if (ratingUnits == null) {
                    throw new RatingException("Rating units have not been set");
                }
                Object[] dataUnits = this.getDataUnits();
                if (dataUnits == null) {
                    dataUnits = new String[ratingUnits.length];
                    Arrays.fill(dataUnits, null);
                }
                for (int i = 0; i < ratingUnits.length; ++i) {
                    if (dataUnits[i] == null || TextUtil.equals((CharSequence)dataUnits[i], (CharSequence)ratingUnits[i])) {
                        ratingUnits[i] = null;
                        dataUnits[i] = null;
                        continue;
                    }
                    if (Units.canConvertBetweenUnits((String)dataUnits[i], (String)ratingUnits[i])) continue;
                    String msg = String.format("Cannot convert from \"%s\" to \"%s\".", dataUnits[i], ratingUnits[i]);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (!this.warnUnsafe) continue;
                    logger.warning(msg + "  Rating will be performed on unconverted values.");
                }
                double[] rated = new double[pIndVals.length];
                for (int i = 0; i < pIndVals.length; ++i) {
                    for (int j = 0; j < this.variables.length; ++j) {
                        if (pIndVals[i][j] == -3.4028234663852886E38) {
                            rated[i] = -3.4028234663852886E38;
                            break;
                        }
                        this.variables[j].setValue(this.convertUnits(pIndVals[i][j], (String)dataUnits[j], ratingUnits[j]));
                    }
                    if (rated[i] == -3.4028234663852886E38) continue;
                    rated[i] = this.convertUnits(this.expression.evaluate(), ratingUnits[this.variables.length], (String)dataUnits[this.variables.length]);
                }
                return rated;
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
        }
    }

    public double rate(long pValTime, double pIndVal) throws RatingException {
        return this.rate(pIndVal);
    }

    public double rateOne(long pValTime, double ... pIndVals) throws RatingException {
        return this.rateOne(pIndVals);
    }

    public double rateOne2(long pValTime, double[] pIndVals) throws RatingException {
        return this.rateOne2(pIndVals);
    }

    public double[] rate(long pValTime, double[] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    public double[] rate(long[] pValTimes, double[] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    public double[] rate(long pValTime, double[][] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    public double[] rate(long[] pValTimes, double[][] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    @Override
    public double[] reverseRate(long[] valTimes, double[] depVals) throws RatingException {
        throw new RatingException("Reverse rating is not supported for formula-based ratings.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndParamCount() throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            return this.variables.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExpressionRatingContainer getData() {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            ExpressionRatingContainer erc = new ExpressionRatingContainer();
            super.getData(erc);
            erc.expression = this.expressionString;
            return erc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(AbstractRatingContainer rc) throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            if (!(rc instanceof ExpressionRatingContainer)) {
                throw new RatingException("setData() requires a ExpressionRatingContainer object.");
            }
            try {
                super._setData(rc);
                ExpressionRatingContainer erc = (ExpressionRatingContainer)rc;
                this.setExpression(erc.expression);
                this.observationTarget.setChanged();
                this.observationTarget.notifyObservers();
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
        }
    }

    @Override
    @Deprecated
    public String toXmlString(CharSequence indent, int indentLevel) throws RatingException {
        return RatingXmlCompatUtil.getInstance().toXml(this, indent, indentLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String expr, String officeId, String ratingSpecId, String ratingUnitsId, long effectiveDate, long createDate, boolean active, String description) throws RatingException {
        ExpressionRating expressionRating = this;
        synchronized (expressionRating) {
            if (this.observationTarget == null) {
                this.observationTarget = new Observable();
            }
            this.setOfficeId(officeId);
            this.setRatingSpecId(ratingSpecId);
            this.setRatingUnitsId(ratingUnitsId);
            this.setEffectiveDate(effectiveDate);
            this.setCreateDate(createDate);
            this.setActive(active);
            this.setDescription(description);
            this.setExpression(expr);
        }
    }

    @Override
    public RatingValue[] getValues(Integer defaultInterval) {
        return null;
    }

    @Override
    public ExpressionRating getInstance(AbstractRatingContainer ratingContainer) throws RatingException {
        if (!(ratingContainer instanceof ExpressionRatingContainer)) {
            throw new UnsupportedOperationException("Expression Ratings only support Expression Rating Containers.");
        }
        return new ExpressionRating((ExpressionRatingContainer)ratingContainer);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((ExpressionRating)obj).getData());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }
}

