/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.RatingException;

public class RatingConst {
    public static final String SEPARATOR1 = ".";
    public static final String SEPARATOR2 = ";";
    public static final String SEPARATOR3 = ",";
    public static final String USGS_SHIFTS_SUBPARAM = "shift";
    public static final String USGS_SHIFTS_TEMPLATE_VERSION = "Linear";
    public static final String USGS_SHIFTS_SPEC_VERSION = "Production";
    public static final String USGS_OFFSETS_SUBPARAM = "offset";
    public static final String USGS_OFFSETS_TEMPLATE_VERSION = "Step";
    public static final String USGS_OFFSETS_SPEC_VERSION = "Production";

    public static enum RatingMethod {
        NULL("NULL", "Return null if between values or outside range"),
        ERROR("ERROR", "Raise an exception if between values or outsie range"),
        LINEAR("LINEAR", "Linear interpolation or extrapolation of independent and dependent values"),
        LOGARITHMIC("LOGARITHMIC", "Logarithmic interpolation or extrapolation of independent and dependent values"),
        LIN_LOG("LIN-LOG", "Linear interpolation/extrapolation of independent values, Logarithmic of dependent values"),
        LOG_LIN("LOG-LIN", "Logarithmic interpolation/extrapolation of independent values, Linear of dependent values"),
        PREVIOUS("PREVIOUS", "Return the value that is lower in position"),
        NEXT("NEXT", "Return the value that is higher in position"),
        NEAREST("NEAREST", "Return the value that is nearest in position"),
        LOWER("LOWER", "Return the value that is lower in magnitude"),
        HIGHER("HIGHER", "Return the value that is higher in magnitude"),
        CLOSEST("CLOSEST", "Return the value that is closest in magnitude");

        private String xmlName;
        private String description;

        private RatingMethod(String xmlName, String description) {
            this.xmlName = xmlName;
            this.description = description;
        }

        public static RatingMethod fromString(String xmlName) throws RatingException {
            for (RatingMethod rm : RatingMethod.values()) {
                if (!rm.toString().equalsIgnoreCase(xmlName)) continue;
                return rm;
            }
            throw new RatingException("\"" + xmlName + "\" is not a valid rating method.");
        }

        public String description() {
            return this.description;
        }

        public String toString() {
            return this.xmlName;
        }
    }
}

