/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import java.util.ArrayList;

public enum RatingMethodId {
    Null("NULL", true, false, false, true, true, true),
    Error("ERROR", true, false, false, true, true, true),
    Linear("LINEAR", true, true, true, true, true, true),
    Logarithmic("LOGARITHMIC", false, false, false, true, true, true),
    LinLog("LIN-LOG", false, false, false, true, true, true),
    LogLin("LOG-LIN", false, false, false, true, true, true),
    Previous("PREVIOUS", false, true, true, false, true, true),
    Next("NEXT", true, true, false, true, true, false),
    Nearest("NEAREST", true, false, true, true, false, true),
    Lower("LOWER", false, true, true, false, true, true),
    Higher("HIGHER", true, true, false, true, true, false),
    Closest("CLOSEST", true, true, true, true, true, true);

    String _dbId;
    boolean[] _rangeIdentifier = new boolean[6];
    public static final int SPECLO = 0;
    public static final int SPECINRANGE = 1;
    public static final int SPECHI = 2;
    public static final int TEMPLATELO = 3;
    public static final int TEMPLATEINRANGE = 4;
    public static final int TEMPLATEHI = 5;

    private RatingMethodId(String dbId, boolean specLo, boolean specInRange, boolean specHi, boolean templateLo, boolean templateInRange, boolean templateHi) {
        this._dbId = dbId;
        this._rangeIdentifier[0] = specLo;
        this._rangeIdentifier[1] = specInRange;
        this._rangeIdentifier[2] = specHi;
        this._rangeIdentifier[3] = templateLo;
        this._rangeIdentifier[4] = templateInRange;
        this._rangeIdentifier[5] = templateHi;
    }

    public String getDbId() {
        return this._dbId;
    }

    public static RatingMethodId getRatingMethodIdFromDbId(String dbId) {
        for (RatingMethodId value : RatingMethodId.values()) {
            if (!value.getDbId().equalsIgnoreCase(dbId)) continue;
            return value;
        }
        return null;
    }

    public static RatingMethodId[] getRatingMethodsForRangeIdentifier(int rangeIdentifierIdx) {
        if (rangeIdentifierIdx < 0 || rangeIdentifierIdx > RatingMethodId.Null._rangeIdentifier.length - 1) {
            return new RatingMethodId[0];
        }
        ArrayList<RatingMethodId> rmidList = new ArrayList<RatingMethodId>();
        for (RatingMethodId rmid : RatingMethodId.values()) {
            if (!rmid._rangeIdentifier[rangeIdentifierIdx]) continue;
            rmidList.add(rmid);
        }
        return rmidList.toArray(new RatingMethodId[rmidList.size()]);
    }

    public boolean isRatingMethodValidForRangeIdentifier(int rangeIdentifierIdx) {
        if (rangeIdentifierIdx < 0 || rangeIdentifierIdx > RatingMethodId.Null._rangeIdentifier.length - 1) {
            return false;
        }
        return this._rangeIdentifier[rangeIdentifierIdx];
    }
}

