/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.DataSetException;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.RatingException;
import hec.data.RoundingException;
import hec.data.UsgsRounder;
import hec.data.cwmsRating.RatingConst;
import hec.data.cwmsRating.RatingSet;
import hec.data.cwmsRating.RatingTemplate;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingJdbcCompatUtil;
import hec.data.cwmsRating.io.RatingSpecContainer;
import hec.data.cwmsRating.io.RatingTemplateContainer;
import hec.data.cwmsRating.io.RatingXmlCompatUtil;
import hec.data.rating.IRatingSpecification;
import hec.data.rating.JDomRatingSpecification;
import hec.util.TextUtil;
import java.sql.Connection;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class RatingSpec
extends RatingTemplate {
    protected static final Logger logger = Logger.getLogger(RatingSet.class.getPackage().getName());
    protected String locationId = null;
    protected String version = null;
    protected String sourceAgencyId = null;
    protected RatingConst.RatingMethod inRangeMethod = RatingConst.RatingMethod.LINEAR;
    protected RatingConst.RatingMethod outRangeLowMethod = RatingConst.RatingMethod.NEXT;
    protected RatingConst.RatingMethod outRangeHighMethod = RatingConst.RatingMethod.PREVIOUS;
    protected boolean active = true;
    protected boolean autoUpdate = true;
    protected boolean autoActivate = false;
    protected boolean autoMigrateExtensions = false;
    protected UsgsRounder[] indRoundingSpecs = null;
    protected UsgsRounder depRoundingSpec = null;
    protected String description = null;

    public static boolean isValidRatingSpecId(String ratingSpecId) {
        boolean isValid;
        block7: {
            isValid = false;
            String[] parts = TextUtil.split((String)ratingSpecId, (String)".");
            if (parts.length == 4) {
                for (String part : parts) {
                    if (part.length() != 0) {
                        continue;
                    }
                    break block7;
                }
                if ((parts = TextUtil.split((String)parts[1].replace(";", ","), (String)",")).length >= 2) {
                    for (String part : parts) {
                        try {
                            new Parameter(part);
                        }
                        catch (DataSetIllegalArgumentException e) {
                            break block7;
                        }
                    }
                    isValid = true;
                }
            }
        }
        return isValid;
    }

    @Deprecated
    public static String getXmlfromDatabase(Connection conn, String officeId, String ratingSpecId) throws RatingException {
        return RatingJdbcCompatUtil.getInstance().getSpecXmlFromDatabase(conn, officeId, ratingSpecId);
    }

    @Deprecated
    public static RatingSpec fromDatabase(Connection conn, String officeId, String ratingSpecId) throws RatingException {
        return RatingJdbcCompatUtil.getInstance().specFromDatabase(conn, officeId, ratingSpecId);
    }

    public RatingSpec(String officeId, String ratingSpecId, String sourceAgencyId, String inRangeMethod, String outRangeLowMethod, String outRangeHighMethod, boolean active, boolean autoUpdate, boolean autoActivate, boolean autoMigrateExtensions, String[] indRoundingSpecs, String depRoundingSpec, String description) throws RatingException, RoundingException {
        this.setOfficeId(officeId);
        String[] parts = TextUtil.split((String)ratingSpecId, (String)".", (String)"L");
        if (parts.length != 4) {
            throw new RatingException("Invalid rating specification: " + ratingSpecId);
        }
        this.setLocationId(parts[0]);
        super.setParametersId(parts[1]);
        super.setVersion(parts[2]);
        this.setVersion(parts[3]);
        this.setSourceAgencyId(sourceAgencyId);
        this.setDescription(description);
        this.setInRangeMethod(RatingConst.RatingMethod.fromString(inRangeMethod));
        this.setOutRangeLowMethod(RatingConst.RatingMethod.fromString(outRangeLowMethod));
        this.setOutRangeHighMethod(RatingConst.RatingMethod.fromString(outRangeHighMethod));
        this.setActive(active);
        this.setAutoUpdate(autoUpdate);
        this.setAutoActivate(autoActivate);
        this.setAutoMigrateExtensions(autoMigrateExtensions);
        this.setIndRoundingSpecs(indRoundingSpecs);
        this.setDepRoundingSpec(depRoundingSpec);
    }

    public RatingSpec() {
    }

    public RatingSpec(RatingSpecContainer rsc) throws RatingException {
        this.setData(rsc);
    }

    @Deprecated
    public RatingSpec(Connection conn, String officeId, String ratingSpecId) throws RatingException {
        this.setData(conn, officeId, ratingSpecId);
    }

    @Deprecated
    public RatingSpec(Node templateNode, Node specNode) throws RatingException {
        this.setData(new RatingSpec(templateNode, specNode).getData());
    }

    @Deprecated
    public RatingSpec(String templateXml, String specXml) throws RatingException {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        RatingSpec ratingSpec = service.createRatingSpec(templateXml, specXml);
        this.setData(ratingSpec.getData());
    }

    public String getOfficeId() {
        return this.officeId;
    }

    public void setOfficeId(String officeId) {
        this.officeId = officeId;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public String getSourceAgencyId() {
        return this.sourceAgencyId;
    }

    public void setSourceAgencyId(String sourceAgencyId) {
        this.sourceAgencyId = sourceAgencyId;
    }

    public RatingConst.RatingMethod getInRangeMethod() {
        return this.inRangeMethod;
    }

    public void setInRangeMethod(RatingConst.RatingMethod inRangeMethod) throws RatingException {
        if (inRangeMethod == RatingConst.RatingMethod.NEAREST) {
            throw new RatingException("Invalid in range specification method: " + inRangeMethod);
        }
        this.inRangeMethod = inRangeMethod;
    }

    public RatingConst.RatingMethod getOutRangeLowMethod() {
        return this.outRangeLowMethod;
    }

    public void setOutRangeLowMethod(RatingConst.RatingMethod outRangeLowMethod) throws RatingException {
        switch (outRangeLowMethod) {
            case PREVIOUS: 
            case LOWER: {
                throw new RatingException("Invalid out of range low specification method: " + outRangeLowMethod);
            }
        }
        this.outRangeLowMethod = outRangeLowMethod;
    }

    public RatingConst.RatingMethod getOutRangeHighMethod() {
        return this.outRangeHighMethod;
    }

    public void setOutRangeHighMethod(RatingConst.RatingMethod outRangeHighMethod) throws RatingException {
        switch (outRangeHighMethod) {
            case NEXT: 
            case HIGHER: {
                throw new RatingException("Invalid out of range high specification method: " + outRangeHighMethod);
            }
        }
        this.outRangeHighMethod = outRangeHighMethod;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isAutoActivate() {
        return this.autoActivate;
    }

    public void setAutoActivate(boolean autoActivate) {
        this.autoActivate = autoActivate;
    }

    public boolean isAutoMigrateExtensions() {
        return this.autoMigrateExtensions;
    }

    public void setAutoMigrateExtensions(boolean autoMigrateExtensions) {
        this.autoMigrateExtensions = autoMigrateExtensions;
    }

    public UsgsRounder[] getIndRoundingSpecs() throws RoundingException {
        UsgsRounder[] specs = new UsgsRounder[this.indRoundingSpecs.length];
        for (int i = 0; i < this.indRoundingSpecs.length; ++i) {
            specs[i] = new UsgsRounder((CharSequence)this.indRoundingSpecs[i].getRoundingSpec());
        }
        return specs;
    }

    public String[] getIndRoundingSpecStrings() {
        String[] roundingSpecs = new String[this.indRoundingSpecs.length];
        for (int i = 0; i < this.indRoundingSpecs.length; ++i) {
            roundingSpecs[i] = this.indRoundingSpecs[i].getRoundingSpec();
        }
        return roundingSpecs;
    }

    public void setIndRoundingSpecs(UsgsRounder[] indRoundingSpecs) throws RoundingException {
        this.indRoundingSpecs = new UsgsRounder[indRoundingSpecs.length];
        for (int i = 0; i < indRoundingSpecs.length; ++i) {
            this.indRoundingSpecs[i] = new UsgsRounder((CharSequence)indRoundingSpecs[i].getRoundingSpec());
        }
    }

    public void setIndRoundingSpecs(String[] indRoundingSpecs) throws RoundingException {
        this.indRoundingSpecs = new UsgsRounder[indRoundingSpecs.length];
        for (int i = 0; i < indRoundingSpecs.length; ++i) {
            this.indRoundingSpecs[i] = new UsgsRounder((CharSequence)indRoundingSpecs[i]);
        }
    }

    public UsgsRounder getDepRoundingSpec() throws RoundingException {
        return new UsgsRounder((CharSequence)this.depRoundingSpec.getRoundingSpec());
    }

    public String getDepRoundingSpecString() {
        return this.depRoundingSpec.getRoundingSpec();
    }

    public void setDepRoundingSpec(UsgsRounder depRoundingSpec) throws RoundingException {
        this.depRoundingSpec = new UsgsRounder((CharSequence)depRoundingSpec.getRoundingSpec());
    }

    public void setDepRoundingSpec(String depRoundingSpec) throws RoundingException {
        this.depRoundingSpec = new UsgsRounder((CharSequence)depRoundingSpec);
    }

    @Override
    public synchronized String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getParametersId() {
        return super.getParametersId();
    }

    @Override
    public void setParametersId(String parametersId) throws RatingException {
        super.setParametersId(parametersId);
    }

    @Override
    public String getTemplateId() {
        return super.getTemplateId();
    }

    @Override
    public void setTemplateId(String templateId) throws RatingException {
        super.setTemplateId(templateId);
    }

    @Override
    public String[] getIndParameters() {
        return super.getIndParameters();
    }

    @Override
    public void setIndParameters(String[] indParameters) {
        super.setIndParameters(indParameters);
    }

    @Override
    public int getIndParamCount() {
        return super.getIndParamCount();
    }

    @Override
    public String getDepParameter() {
        return super.getDepParameter();
    }

    @Override
    public void setDepParameter(String depParameter) {
        super.setDepParameter(depParameter);
    }

    @Override
    public RatingConst.RatingMethod[] getInRangeMethods() {
        return super.getInRangeMethods();
    }

    @Override
    public void setInRangeMethods(RatingConst.RatingMethod[] inRangeMethods) throws RatingException {
        super.setInRangeMethods(inRangeMethods);
    }

    @Override
    public RatingConst.RatingMethod[] getOutRangeLowMethods() {
        return super.getOutRangeLowMethods();
    }

    @Override
    public void setOutRangeLowMethods(RatingConst.RatingMethod[] outRangeLowMethods) throws RatingException {
        super.setOutRangeLowMethods(outRangeLowMethods);
    }

    @Override
    public RatingConst.RatingMethod[] getOutRangeHighMethods() {
        return super.getOutRangeHighMethods();
    }

    @Override
    public void setOutRangeHighMethods(RatingConst.RatingMethod[] outRangeHighMethods) throws RatingException {
        super.setOutRangeHighMethods(outRangeHighMethods);
    }

    public String getRatingSpecId() {
        return this.locationId + "." + this.getTemplateId() + "." + this.version;
    }

    public String getDssPathname() {
        return String.format("/%s/%s/%s//%s/%s/", this.officeId, this.locationId, this.getParametersId(), this.getTemplateVersion(), this.getVersion());
    }

    @Override
    public RatingSpecContainer getData() {
        return this.getData(true);
    }

    public RatingSpecContainer getData(boolean getTemplate) {
        RatingSpecContainer rsc = new RatingSpecContainer();
        if (getTemplate) {
            super.getData(rsc);
        }
        rsc.officeId = this.officeId;
        rsc.specOfficeId = this.officeId;
        rsc.templateId = this.getTemplateId();
        rsc.specId = this.locationId + "." + rsc.templateId + "." + this.version;
        rsc.locationId = this.locationId;
        rsc.specVersion = this.version;
        rsc.sourceAgencyId = this.sourceAgencyId;
        rsc.inRangeMethod = this.inRangeMethod.toString();
        rsc.outRangeLowMethod = this.outRangeLowMethod.toString();
        rsc.outRangeHighMethod = this.outRangeHighMethod.toString();
        rsc.active = this.active;
        rsc.autoUpdate = this.autoUpdate;
        rsc.autoActivate = this.autoActivate;
        rsc.autoMigrateExtensions = this.autoMigrateExtensions;
        rsc.indRoundingSpecs = new String[this.indRoundingSpecs.length];
        for (int i = 0; i < this.indRoundingSpecs.length; ++i) {
            rsc.indRoundingSpecs[i] = this.indRoundingSpecs[i].toString();
        }
        rsc.depRoundingSpec = this.depRoundingSpec.toString();
        rsc.specDescription = this.description;
        return rsc;
    }

    public void setData(RatingSpecContainer rsc) throws RatingException {
        try {
            super.setData(rsc, true);
            if (this.officeId == null && rsc.specOfficeId != null) {
                this.officeId = rsc.specOfficeId;
            }
            this.locationId = rsc.locationId;
            this.version = rsc.specVersion;
            this.sourceAgencyId = rsc.sourceAgencyId;
            this.inRangeMethod = RatingConst.RatingMethod.fromString(rsc.inRangeMethod);
            this.outRangeLowMethod = RatingConst.RatingMethod.fromString(rsc.outRangeLowMethod);
            this.outRangeHighMethod = RatingConst.RatingMethod.fromString(rsc.outRangeHighMethod);
            this.active = rsc.active;
            this.autoUpdate = rsc.autoUpdate;
            this.autoActivate = rsc.autoActivate;
            this.autoMigrateExtensions = rsc.autoMigrateExtensions;
            int indParamCount = rsc.indRoundingSpecs.length;
            if (indParamCount != this.getIndParamCount()) {
                throw new RatingException("Number of independent parameter rounding specifications does not equal number of independent parameters.");
            }
            this.indRoundingSpecs = new UsgsRounder[indParamCount];
            for (int i = 0; i < indParamCount; ++i) {
                this.indRoundingSpecs[i] = new UsgsRounder((CharSequence)rsc.indRoundingSpecs[i]);
            }
            this.depRoundingSpec = new UsgsRounder((CharSequence)rsc.depRoundingSpec);
            this.description = rsc.specDescription;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    @Deprecated
    public synchronized void setData(Connection conn, String officeId, String ratingSpecId) throws RatingException {
        RatingSpec ratingSpec = RatingJdbcCompatUtil.getInstance().specFromDatabase(conn, officeId, ratingSpecId);
        this.setData(ratingSpec.getData());
    }

    @Deprecated
    public void setData(String templateXml, String specXml) throws RatingException {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        RatingSpecContainer container = service.createRatingSpec(templateXml, specXml).getData();
        this.setData(container);
    }

    @Deprecated
    public void setData(Node templateNode, Node specNode) throws RatingException {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        RatingSpecContainer container = service.createRatingSpec(templateNode, specNode).getData();
        this.setData((RatingTemplateContainer)container);
    }

    public String toSpecXml(CharSequence indent) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this.getData(), indent, 0, false);
    }

    public String toSpecXml(CharSequence indent, int level) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this.getData(), indent, level, false);
    }

    public String toTemplateXml(CharSequence indent) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this.getData(), indent, 0);
    }

    public String toTemplateXml(CharSequence indent, int level) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this.getData(), indent, level);
    }

    @Deprecated
    public String toXml(CharSequence indent) {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        return service.toXml(this, indent, 0, false);
    }

    @Deprecated
    public String toXml(CharSequence indent, int level) {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        return service.toXml(this, indent, level, false);
    }

    @Deprecated
    public String toXml(CharSequence indent, int level, boolean includeTemplate) {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        return service.toXml(this, indent, level, includeTemplate);
    }

    @Override
    @Deprecated
    public String toXmlString(CharSequence indent, int level) {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        return service.toXml(this, indent, level, false);
    }

    @Deprecated
    public String toXmlString(CharSequence indent, int level, boolean includeTemplate) {
        RatingXmlCompatUtil service = RatingXmlCompatUtil.getInstance();
        return service.toXml(this, indent, level, includeTemplate);
    }

    public IRatingSpecification getRatingSpecification() throws DataSetException {
        String officeId = this.getOfficeId();
        String specificationId = this.getRatingSpecId();
        JDomRatingSpecification specification = new JDomRatingSpecification(officeId, specificationId);
        return specification;
    }

    @Override
    @Deprecated
    public void storeToDatabase(Connection conn, boolean overwriteExisting) throws RatingException {
        RatingJdbcCompatUtil.getInstance().storeToDatabase(this, conn, overwriteExisting, false);
    }

    @Deprecated
    public void storeToDatabase(Connection conn, boolean overwriteExisting, boolean storeTemplate) throws RatingException {
        RatingJdbcCompatUtil.getInstance().storeToDatabase(this, conn, overwriteExisting, storeTemplate);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((RatingSpec)obj).getData());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }
}

