/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.RatingException;
import hec.data.cwmsRating.RatingSpec;
import hec.data.cwmsRating.RatingTemplate;
import hec.data.location.LocationTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public final class RatingSpecCatalog {
    private final NavigableMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>> locSpecMap;

    RatingSpecCatalog() {
        this.locSpecMap = new TreeMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>>();
    }

    RatingSpecCatalog(Collection<RatingSpec> specs) throws RatingException {
        this.locSpecMap = RatingSpecCatalog.unmodifiableOf(RatingSpecCatalog.buildLocSpecMap(specs));
    }

    public Map<RatingTemplate, Set<RatingSpec>> getSpecifications(LocationTemplate locRef) {
        return this.locSpecMap.getOrDefault(locRef, Collections.emptyMap());
    }

    public NavigableMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>> getSpecifications() {
        return this.locSpecMap;
    }

    private static NavigableMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>> buildLocSpecMap(Collection<RatingSpec> specs) {
        TreeMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>> locSpecMap = new TreeMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>>(LocationTemplate.LocationComparator);
        if (specs != null) {
            for (RatingSpec spec : specs) {
                LocationTemplate locationRef = new LocationTemplate(spec.getOfficeId(), spec.getLocationId());
                Map templateSpecMap = locSpecMap.computeIfAbsent(locationRef, k -> new LinkedHashMap());
                Set ratingSpecSet = templateSpecMap.computeIfAbsent(spec, k -> new LinkedHashSet());
                ratingSpecSet.add(spec);
            }
        }
        return locSpecMap;
    }

    private static NavigableMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>> unmodifiableOf(NavigableMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>> input) throws RatingException {
        TreeMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>> locSpecMap = new TreeMap<LocationTemplate, Map<RatingTemplate, Set<RatingSpec>>>(LocationTemplate.LocationComparator);
        Set entries = input.entrySet();
        for (Map.Entry entry : entries) {
            LocationTemplate copy = new LocationTemplate((LocationTemplate)entry.getKey());
            locSpecMap.put(copy, RatingSpecCatalog.unmodifiableOf((Map)entry.getValue()));
        }
        return Collections.unmodifiableNavigableMap(locSpecMap);
    }

    private static Map<RatingTemplate, Set<RatingSpec>> unmodifiableOf(Map<RatingTemplate, Set<RatingSpec>> value) throws RatingException {
        LinkedHashMap<RatingTemplate, Set<RatingSpec>> templateSpecMap = new LinkedHashMap<RatingTemplate, Set<RatingSpec>>();
        Set<Map.Entry<RatingTemplate, Set<RatingSpec>>> entries = value.entrySet();
        for (Map.Entry<RatingTemplate, Set<RatingSpec>> entry : entries) {
            RatingTemplate copy = new RatingTemplate(entry.getKey().getData());
            templateSpecMap.put(copy, RatingSpecCatalog.unmodifiableOf(entry.getValue()));
        }
        return Collections.unmodifiableMap(templateSpecMap);
    }

    private static Set<RatingSpec> unmodifiableOf(Set<RatingSpec> specs) throws RatingException {
        LinkedHashSet<RatingSpec> retval = new LinkedHashSet<RatingSpec>();
        if (specs != null) {
            for (RatingSpec spec : specs) {
                RatingSpec copy = new RatingSpec(spec.getData());
                retval.add(copy);
            }
        }
        return Collections.unmodifiableSet(retval);
    }

    public int size() {
        int size = 0;
        Set entrySet = this.locSpecMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Map templateSpecMap = (Map)entry.getValue();
            size += templateSpecMap.size();
        }
        return size;
    }

    public static final class Builder {
        final LinkedHashSet<RatingSpec> ratingSpecs = new LinkedHashSet();

        public RatingSpecCatalog build() throws RatingException {
            return new RatingSpecCatalog(this.ratingSpecs);
        }

        public Builder addRatingSpec(RatingSpec spec) {
            this.ratingSpecs.add(spec);
            return this;
        }

        public Builder addRatingSpecs(Collection<RatingSpec> specs) {
            if (specs != null) {
                this.ratingSpecs.addAll(specs);
            }
            return this;
        }
    }
}

