/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.DataSetException;
import hec.data.RatingException;
import hec.data.cwmsRating.RatingConst;
import hec.data.cwmsRating.RatingSet;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingJdbcCompatUtil;
import hec.data.cwmsRating.io.RatingTemplateContainer;
import hec.data.rating.IRatingTemplate;
import hec.data.rating.JDomRatingTemplate;
import hec.util.TextUtil;
import java.sql.Connection;
import java.util.Arrays;
import java.util.logging.Logger;
import rma.lang.Modifiable;

public class RatingTemplate
implements Modifiable {
    protected static final Logger logger = Logger.getLogger(RatingSet.class.getPackage().getName());
    private String templateVersion = null;
    private String[] indParameters = null;
    private RatingConst.RatingMethod[] inRangeMethods = null;
    private RatingConst.RatingMethod[] outRangeLowMethods = null;
    private RatingConst.RatingMethod[] outRangeHighMethods = null;
    private String depParameter = null;
    private String description = null;
    private int indParamCount = 0;
    private boolean modified = false;
    protected String officeId = null;

    public static String getXmlfromDatabase(Connection conn, String officeId, String templateId) throws RatingException {
        return RatingJdbcCompatUtil.getInstance().getTemplateXmlFromDatabase(conn, officeId, templateId);
    }

    @Deprecated
    public static RatingTemplate fromDatabase(Connection conn, String officeId, String templateId) throws RatingException {
        return RatingJdbcCompatUtil.getInstance().templateFromDatabase(conn, officeId, templateId);
    }

    protected RatingTemplate() {
    }

    public RatingTemplate(String officeId, String templateId, RatingConst.RatingMethod[] inRangeMethods, RatingConst.RatingMethod[] outRangeLowMethods, RatingConst.RatingMethod[] outRangeHighMethods, String description) throws RatingException {
        this.officeId = officeId;
        this.setTemplateId(templateId);
        this.setInRangeMethods(inRangeMethods);
        this.setOutRangeLowMethods(outRangeLowMethods);
        this.setOutRangeHighMethods(outRangeHighMethods);
        this.description = description;
    }

    public RatingTemplate(RatingTemplateContainer rtc) throws RatingException {
        this.setData(rtc);
    }

    @Deprecated
    public RatingTemplate(Connection conn, String officeId, String templateId) throws RatingException {
        this.setData(conn, officeId, templateId);
    }

    public String getParametersId() {
        StringBuilder sb = new StringBuilder(this.indParameters[0]);
        for (int i = 1; i < this.indParameters.length; ++i) {
            sb.append(",").append(this.indParameters[i]);
        }
        sb.append(";").append(this.depParameter);
        return sb.toString();
    }

    public void setParametersId(String parametersId) throws RatingException {
        String[] parts = TextUtil.split((String)parametersId, (String)";", (String)"L");
        if (parts.length != 2) {
            throw new RatingException("Invalid parameters identifier: " + parametersId);
        }
        this.depParameter = parts[1];
        this.indParameters = TextUtil.split((String)parts[0], (String)",", (String)"L");
        this.indParamCount = this.indParameters.length;
    }

    public String[] getParameters() {
        String[] parameters = Arrays.copyOf(this.indParameters, this.indParamCount + 1);
        parameters[this.indParamCount] = this.depParameter;
        return parameters;
    }

    public int getIndParamCount() {
        return this.indParamCount;
    }

    public RatingConst.RatingMethod[] getInRangeMethods() {
        return this.inRangeMethods;
    }

    public void setInRangeMethods(RatingConst.RatingMethod[] inRangeMethods) throws RatingException {
        if (inRangeMethods.length != this.indParamCount) {
            throw new RatingException("Number of in-range rating methods is not the same as the number of independent parameters.");
        }
        for (RatingConst.RatingMethod m : inRangeMethods) {
            switch (m) {
                case NEAREST: {
                    throw new RatingException("Invalid in range template method: " + m.toString());
                }
            }
        }
        this.inRangeMethods = inRangeMethods;
    }

    public RatingConst.RatingMethod[] getOutRangeLowMethods() {
        return this.outRangeLowMethods;
    }

    public void setOutRangeLowMethods(RatingConst.RatingMethod[] outRangeLowMethods) throws RatingException {
        if (outRangeLowMethods.length != this.indParamCount) {
            throw new RatingException("Number of out-of-range low rating methods is not the same as the number of independent parameters.");
        }
        for (RatingConst.RatingMethod m : outRangeLowMethods) {
            switch (m) {
                case LOWER: 
                case PREVIOUS: {
                    throw new RatingException("Invalid out of range low template method: " + m.toString());
                }
            }
        }
        this.outRangeLowMethods = outRangeLowMethods;
    }

    public RatingConst.RatingMethod[] getOutRangeHighMethods() {
        return this.outRangeHighMethods;
    }

    public void setOutRangeHighMethods(RatingConst.RatingMethod[] outRangeHighMethods) throws RatingException {
        if (outRangeHighMethods.length != this.indParamCount) {
            throw new RatingException("Number of out-of-range high rating methods is not the same as the number of independent parameters.");
        }
        for (RatingConst.RatingMethod m : outRangeHighMethods) {
            switch (m) {
                case HIGHER: 
                case NEXT: {
                    throw new RatingException("Invalid out of range high template method: " + m.toString());
                }
            }
        }
        this.outRangeHighMethods = outRangeHighMethods;
    }

    public String getTemplateId() {
        StringBuilder sb = new StringBuilder(this.getParametersId());
        sb.append(".").append(this.templateVersion);
        return sb.toString();
    }

    public void setTemplateId(String templateId) throws RatingException {
        String[] parts = TextUtil.split((String)templateId, (String)".", (String)"L");
        if (parts.length != 2) {
            throw new RatingException("Invalid template identifier: " + templateId);
        }
        this.setParametersId(parts[0]);
        this.templateVersion = parts[1];
    }

    public String getVersion() {
        return this.templateVersion;
    }

    public void setVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    public String[] getIndParameters() {
        return Arrays.copyOf(this.indParameters, this.indParameters.length);
    }

    public void setIndParameters(String[] indParameters) {
        this.indParameters = Arrays.copyOf(indParameters, indParameters.length);
        this.indParamCount = this.indParameters.length;
    }

    public String getDepParameter() {
        return this.depParameter;
    }

    public void setDepParameter(String depParameter) {
        this.depParameter = depParameter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RatingTemplateContainer getData() {
        RatingTemplateContainer rtc = new RatingTemplateContainer();
        this.getData(rtc);
        return rtc;
    }

    @Deprecated
    public synchronized void setData(Connection conn, String officeId, String templateId) throws RatingException {
        RatingTemplate ratingTemplate = RatingJdbcCompatUtil.getInstance().templateFromDatabase(conn, officeId, templateId);
        this.setData(ratingTemplate.getData());
    }

    @Deprecated
    public void setData(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        RatingTemplateContainer container = service.createRatingTemplateContainer(xmlText);
        this.setData(container);
    }

    public void setData(RatingTemplateContainer rtc) throws RatingException {
        this.setData(rtc, false);
    }

    public void setData(RatingTemplateContainer rtc, boolean allowNulls) throws RatingException {
        int indParamCount = 0;
        RatingConst.RatingMethod[] inRangeMethods = null;
        RatingConst.RatingMethod[] outRangeLowMethods = null;
        RatingConst.RatingMethod[] outRangeHighMethods = null;
        if (!allowNulls && rtc.officeId == null) {
            throw new RatingException("RatingTemplateContainer has no office identifier.");
        }
        this.officeId = rtc.officeId;
        if (!allowNulls || rtc.templateId != null) {
            String[] parts = TextUtil.split((String)rtc.templateId, (String)".", (String)"L");
            if (parts.length != 2) {
                throw new RatingException("RatingTemplateContainer has invalid rating template identifier.");
            }
            if ((parts = TextUtil.split((String)parts[0], (String)";", (String)"L")).length != 2) {
                throw new RatingException("RatingTemplateContainer has invalid rating template identifier.");
            }
            parts = TextUtil.split((String)parts[0], (String)",", (String)"L");
            indParamCount = parts.length;
        }
        if (!allowNulls || rtc.indParams != null && rtc.depParam != null) {
            if (!String.format("%s;%s", TextUtil.join((String)",", (String[])rtc.indParams), rtc.depParam).equals(rtc.parametersId)) {
                throw new RatingException("RatingTemplateContainer parameters  not consistent with parameters identifier.");
            }
            if (rtc.templateVersion != null && !String.format("%s;%s.%s", TextUtil.join((String)",", (String[])rtc.indParams), rtc.depParam, rtc.templateVersion).equals(rtc.templateId)) {
                throw new RatingException("RatingTemplateContainer parameters and/or templateVersion are not consistent with template identifier.");
            }
        }
        if (!allowNulls || rtc.inRangeMethods != null && rtc.outRangeLowMethods != null && rtc.outRangeHighMethods != null) {
            if (rtc.inRangeMethods.length != indParamCount || rtc.outRangeLowMethods.length != indParamCount || rtc.outRangeHighMethods.length != indParamCount) {
                throw new RatingException("RatingTemplateContainer has inconsistent number of independent parameters");
            }
            inRangeMethods = new RatingConst.RatingMethod[indParamCount];
            outRangeLowMethods = new RatingConst.RatingMethod[indParamCount];
            outRangeHighMethods = new RatingConst.RatingMethod[indParamCount];
            for (int i = 0; i < indParamCount; ++i) {
                inRangeMethods[i] = RatingConst.RatingMethod.fromString(rtc.inRangeMethods[i]);
                outRangeLowMethods[i] = RatingConst.RatingMethod.fromString(rtc.outRangeLowMethods[i]);
                outRangeHighMethods[i] = RatingConst.RatingMethod.fromString(rtc.outRangeHighMethods[i]);
            }
        }
        this.setTemplateId(rtc.templateId);
        this.description = rtc.templateDescription;
        this.indParamCount = indParamCount;
        if (outRangeLowMethods != null) {
            this.setOutRangeLowMethods(outRangeLowMethods);
        }
        if (inRangeMethods != null) {
            this.setInRangeMethods(inRangeMethods);
        }
        if (outRangeHighMethods != null) {
            this.setOutRangeHighMethods(outRangeHighMethods);
        }
    }

    protected void getData(RatingTemplateContainer rtc) {
        rtc.officeId = this.officeId;
        rtc.templateId = this.getTemplateId();
        String[] parts = TextUtil.split((String)rtc.templateId, (String)".", (String)"L");
        rtc.parametersId = parts[0];
        rtc.templateVersion = parts[1];
        parts = TextUtil.split((String)rtc.parametersId, (String)";", (String)"L");
        rtc.indParams = TextUtil.split((String)parts[0], (String)",", (String)"L");
        rtc.depParam = parts[1];
        rtc.inRangeMethods = new String[this.indParamCount];
        rtc.outRangeLowMethods = new String[this.indParamCount];
        rtc.outRangeHighMethods = new String[this.indParamCount];
        for (int i = 0; i < this.indParamCount; ++i) {
            rtc.inRangeMethods[i] = this.inRangeMethods == null || this.inRangeMethods[i] == null ? null : this.inRangeMethods[i].toString();
            rtc.outRangeLowMethods[i] = this.outRangeLowMethods == null || this.outRangeLowMethods[i] == null ? null : this.outRangeLowMethods[i].toString();
            rtc.outRangeHighMethods[i] = this.outRangeHighMethods == null || this.outRangeHighMethods[i] == null ? null : this.outRangeHighMethods[i].toString();
        }
        rtc.templateDescription = this.description;
    }

    @Deprecated
    public String toXmlString(CharSequence indent, int level) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this.getData(), indent, level);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bool) {
        this.modified = bool;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    public String getTemplateDescription() {
        return this.description;
    }

    public void setTemplateDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public void storeToDatabase(Connection conn, boolean overwriteExisting) throws RatingException {
        RatingJdbcCompatUtil.getInstance().storeToDatabase(this, conn, overwriteExisting);
    }

    public IRatingTemplate getRatingTemplate() throws DataSetException {
        String templateId = this.getTemplateId();
        JDomRatingTemplate template = new JDomRatingTemplate(this.officeId, templateId);
        return template;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((RatingTemplate)obj).getData());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }
}

