/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.RatingException;
import hec.data.Units;
import hec.data.cwmsRating.io.IndependentValuesContainer;
import hec.heclib.util.HecTime;
import hec.io.Conversion;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerAligner;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;

final class RatingUtil {
    RatingUtil() {
    }

    public static IndependentValuesContainer tscsToIvc(TimeSeriesContainer[] tscs, String[] units, TimeZone tz, boolean allowUnsafe, boolean warnUnsafe) throws RatingException {
        IndependentValuesContainer ivc = new IndependentValuesContainer();
        int indParamCount = tscs.length;
        try {
            int i;
            Vector<Integer> commonTimes = new Vector<Integer>();
            Vector<double[]> indVals = new Vector<double[]>();
            TimeSeriesContainerAligner tsca = new TimeSeriesContainerAligner(tscs);
            while (tsca.hasCurrent()) {
                if (tsca.getAlignedCount() == indParamCount) {
                    commonTimes.add(tsca.getTime());
                    double[] v = new double[indParamCount];
                    for (i = 0; i < indParamCount; ++i) {
                        v[i] = !tscs[i].units.equals(units[i]) ? Units.convertUnits((double)tsca.getValue(i), (String)tscs[i].units, (String)units[i]) : tsca.getValue(i);
                    }
                    indVals.add(v);
                }
                tsca.alignNext();
            }
            if (commonTimes.size() == 0) {
                throw new RatingException("No common times in TimeSeriesContainers.");
            }
            long[] valTimes = new long[commonTimes.size()];
            if (tz == null) {
                for (i = 0; i < valTimes.length; ++i) {
                    valTimes[i] = Conversion.toMillis((int)((Integer)commonTimes.get(i)));
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTimeZone(tz);
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy, HH:mm");
                HecTime t = new HecTime();
                for (int i2 = 0; i2 < valTimes.length; ++i2) {
                    t.set(((Integer)commonTimes.get(i2)).intValue());
                    cal.setTime(sdf.parse(t.dateAndTime(4)));
                    valTimes[i2] = cal.getTimeInMillis();
                }
            }
            ivc.valTimes = valTimes;
            ivc.indVals = (double[][])indVals.toArray((T[])new double[indVals.size()][]);
            return ivc;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }
}

