/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.RatingException;
import hec.data.cwmsRating.TableRating;
import hec.data.cwmsRating.io.RatingValueContainer;
import hec.lang.Observable;
import java.util.Observer;

public class RatingValue
implements Observer {
    protected Observable observationTarget = null;
    protected double indValue;
    protected double depValue;
    protected String note = null;
    protected TableRating depTable = null;
    protected boolean hasDepTable = false;

    static String format(double val) {
        String s;
        boolean negative;
        boolean bl = negative = val < 0.0;
        if (negative) {
            val = Math.abs(val);
        }
        if ((s = String.format("%s", val)).endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.startsWith("0.")) {
            s = s.substring(1);
        }
        return negative ? "-" + s : s;
    }

    public RatingValue(double indValue, double depValue) {
        this(indValue, depValue, null);
    }

    public RatingValue(double indValue, double depValue, String note) {
        this.indValue = indValue;
        this.depValue = depValue;
        if (note != null && note.length() > 0) {
            this.note = note;
        }
        this.observationTarget = new Observable();
        this.hasDepTable = false;
    }

    public RatingValue(double indValue, TableRating depValues) {
        this.indValue = indValue;
        this.depTable = depValues;
        this.observationTarget = new Observable();
        this.hasDepTable = true;
    }

    public RatingValue(RatingValueContainer rvc) throws RatingException {
        this.indValue = rvc.indValue;
        if (rvc.depTable == null) {
            this.depValue = rvc.depValue;
            this.note = rvc.note;
            this.depTable = null;
            this.hasDepTable = false;
        } else {
            this.depValue = -3.4028234663852886E38;
            this.note = null;
            this.depTable = new TableRating(rvc.depTable);
            this.hasDepTable = true;
        }
        this.observationTarget = new Observable();
    }

    public double getIndValue() {
        return this.indValue;
    }

    public void setIndValue(double indValue) {
        this.indValue = indValue;
        this.observationTarget.setChanged();
        this.observationTarget.notifyObservers();
    }

    public double getDepValue() throws RatingException {
        if (this.hasDepTable) {
            throw new RatingException("RatingPoint has a dependent value set and not a dependent value.");
        }
        return this.depValue;
    }

    public void setDepValue(double depValue) {
        if (this.depTable != null) {
            this.depTable.deleteObserver(this);
        }
        this.depTable = null;
        this.depValue = depValue;
        this.observationTarget.setChanged();
        this.observationTarget.notifyObservers();
    }

    public String getNote() throws RatingException {
        if (this.hasDepTable) {
            throw new RatingException("No note is available because RatingPoint has a dependent table of values.");
        }
        return this.note;
    }

    public void setNote(CharSequence note) throws RatingException {
        if (this.hasDepTable) {
            throw new RatingException("Cannot set note because RatingPoint has a dependent table of values.");
        }
        this.note = (String)note;
    }

    public boolean hasNote() {
        return this.note != null;
    }

    public boolean hasDepValue() {
        return !this.hasDepTable;
    }

    public boolean hasDepTable() {
        return this.hasDepTable;
    }

    public TableRating getDepValues() throws RatingException {
        if (!this.hasDepTable) {
            throw new RatingException("RatingPoint has a single dependent value.");
        }
        return this.depTable;
    }

    public void setDepValues(TableRating depTable) throws RatingException {
        if (depTable == null) {
            throw new RatingException("Cannot set dependent values to a null table.");
        }
        this.depValue = -3.4028234663852886E38;
        this.depTable = depTable;
        this.depTable.addObserver(this);
        this.observationTarget.setChanged();
        this.observationTarget.notifyObservers();
    }

    public RatingValueContainer getData() {
        RatingValueContainer rvc = new RatingValueContainer();
        rvc.indValue = this.indValue;
        rvc.depValue = this.depValue;
        rvc.note = this.note;
        rvc.depTable = this.depTable == null ? null : this.depTable.getData();
        return rvc;
    }

    public void setData(RatingValueContainer rvc) throws RatingException {
        if (this.depTable != null) {
            this.depTable.deleteObserver(this);
        }
        this.indValue = rvc.indValue;
        if (rvc.depTable == null) {
            this.depValue = rvc.depValue;
            this.note = rvc.note;
            this.depTable = null;
            this.hasDepTable = false;
        } else {
            this.depValue = -3.4028234663852886E38;
            this.note = null;
            this.depTable = new TableRating(rvc.depTable);
            this.hasDepTable = true;
        }
        this.observationTarget.setChanged();
        this.observationTarget.notifyObservers();
    }

    @Override
    public void update(java.util.Observable arg0, Object arg1) {
        this.observationTarget.setChanged();
        this.observationTarget.notifyObservers();
    }

    public void addObserver(Observer o) {
        this.observationTarget.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observationTarget.deleteObserver(o);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((RatingValue)obj).getData());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }
}

